/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.patcher.util.world.sound;

import club.sk1er.patcher.config.ConfigUtil;
import club.sk1er.patcher.config.PatcherConfig;
import club.sk1er.patcher.mixins.accessors.PositionedSoundAccessor;
import club.sk1er.patcher.mixins.accessors.SoundHandlerAccessor;
import club.sk1er.patcher.mixins.accessors.SoundRegistryAccessor;
import gg.essential.vigilance.data.PropertyData;
import gg.essential.vigilance.data.PropertyType;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SoundCategory;
import net.minecraft.client.audio.SoundEventAccessorComposite;
import net.minecraft.client.audio.SoundManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.apache.commons.lang3.text.WordUtils;
import org.lwjgl.opengl.Display;

public class SoundHandler
implements IResourceManagerReloadListener {
    private final Map<ResourceLocation, PropertyData> data = new HashMap<ResourceLocation, PropertyData>();
    private boolean previousActive = Display.isActive();
    private float previousVolume = -1.0f;

    public SoundHandler() {
        this.handleFocusChange();
    }

    @SubscribeEvent
    public void onSound(PlaySoundEvent event) {
        ISound soundResult = event.result;
        if (soundResult instanceof PositionedSoundAccessor) {
            PositionedSoundAccessor result = (PositionedSoundAccessor)soundResult;
            result.setVolume(result.getVolumeField() * this.getVolumeMultiplier(soundResult.func_147650_b()));
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        boolean active = Display.isActive();
        if (active != this.previousActive) {
            this.previousActive = active;
            this.handleFocusChange();
        }
    }

    private void handleFocusChange() {
        if (!this.previousActive) {
            SoundManager soundManager = ((SoundHandlerAccessor)Minecraft.func_71410_x().func_147118_V()).getSndManager();
            this.previousVolume = Minecraft.func_71410_x().field_71474_y.func_151438_a(SoundCategory.MASTER);
            if (this.previousVolume == -1.0f) {
                return;
            }
            soundManager.func_148601_a(SoundCategory.MASTER, PatcherConfig.unfocusedSounds * this.previousVolume);
        } else {
            ((SoundHandlerAccessor)Minecraft.func_71410_x().func_147118_V()).getSndManager().func_148601_a(SoundCategory.MASTER, this.previousVolume);
            this.previousVolume = -1.0f;
        }
    }

    private float getVolumeMultiplier(ResourceLocation sound) {
        Object asAny;
        PropertyData propertyData = this.data.get(sound);
        if (propertyData != null && (asAny = propertyData.getAsAny()) instanceof Integer) {
            return ((Integer)asAny).floatValue() / 100.0f;
        }
        return 1.0f;
    }

    public void func_110549_a(IResourceManager resourceManager) {
        Map<ResourceLocation, SoundEventAccessorComposite> soundRegistry = ((SoundRegistryAccessor)((SoundHandlerAccessor)Minecraft.func_71410_x().func_147118_V()).getSndRegistry()).getSoundRegistry();
        for (Map.Entry<ResourceLocation, SoundEventAccessorComposite> entry : soundRegistry.entrySet()) {
            this.data.computeIfAbsent(entry.getKey(), location -> {
                String name = this.getName((ResourceLocation)location);
                return ConfigUtil.createAndRegisterConfig(PropertyType.SLIDER, WordUtils.capitalizeFully((String)((SoundEventAccessorComposite)entry.getValue()).func_148728_d().func_147155_a()), "Sounds", name, "Sound Multiplier for " + name, 100, 0, 200, __ -> {});
            });
        }
    }

    private String getName(ResourceLocation location) {
        return WordUtils.capitalizeFully((String)location.func_110623_a().replace(".", " ").replace("_", " "));
    }
}

