/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.patcher.tweaker;

import club.sk1er.patcher.tweaker.ClassTransformer;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.MalformedJsonException;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import net.minecraft.launchwrapper.ITweaker;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LaunchClassLoader;
import net.minecraftforge.fml.relauncher.CoreModManager;
import net.minecraftforge.fml.relauncher.FMLLaunchHandler;
import net.minecraftforge.fml.relauncher.IFMLLoadingPlugin;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.filter.RegexFilter;

@IFMLLoadingPlugin.MCVersion(value="1.8.9")
public class PatcherTweaker
implements IFMLLoadingPlugin {
    public static long clientLoadTime;

    public PatcherTweaker() {
        clientLoadTime = System.currentTimeMillis();
        try {
            FMLLaunchHandler launchHandler = (FMLLaunchHandler)ReflectionHelper.getPrivateValue(FMLLaunchHandler.class, null, (String[])new String[]{"INSTANCE"});
            LaunchClassLoader classLoader = (LaunchClassLoader)ReflectionHelper.getPrivateValue(FMLLaunchHandler.class, (Object)launchHandler, (String[])new String[]{"classLoader"});
            Method loadCoreMod = ReflectionHelper.findMethod(CoreModManager.class, null, (String[])new String[]{"loadCoreMod"}, (Class[])new Class[]{LaunchClassLoader.class, String.class, File.class});
            URL path = PatcherTweaker.class.getProtectionDomain().getCodeSource().getLocation();
            File mod = new File(path.toURI().getSchemeSpecificPart().split("!")[0]);
            ITweaker coreMod = (ITweaker)loadCoreMod.invoke(null, classLoader, "club.sk1er.patcher.tweaker.other.ModTweaker", mod);
            if (!((List)Launch.blackboard.get("TweakClasses")).contains("net.minecraftforge.fml.common.launcher.FMLInjectionAndSortingTweaker")) {
                ((List)Launch.blackboard.get("Tweaks")).add(coreMod);
            }
        }
        catch (Exception e) {
            System.out.println("Failed creating a second tweaker");
            e.printStackTrace();
        }
        this.unlockLwjgl();
        this.detectMods();
    }

    public String[] getASMTransformerClass() {
        return new String[]{ClassTransformer.class.getName()};
    }

    public String getModContainerClass() {
        return null;
    }

    public String getSetupClass() {
        return null;
    }

    public void injectData(Map<String, Object> data) {
    }

    public String getAccessTransformerClass() {
        return null;
    }

    private void unlockLwjgl() {
        boolean lwjglUnlock = false;
        try {
            Field transformerExceptions = LaunchClassLoader.class.getDeclaredField("classLoaderExceptions");
            transformerExceptions.setAccessible(true);
            Object o = transformerExceptions.get(Launch.classLoader);
            lwjglUnlock = ((Set)o).remove("org.lwjgl.");
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
        if (!lwjglUnlock) {
            System.out.println("Failed to unlock LWJGL, several fixes will not work.");
        }
        this.silenceLog4j();
    }

    private void silenceLog4j() {
        try {
            Logger logger = ((LoggerContext)LogManager.getContext((ClassLoader)Launch.class.getClassLoader(), (boolean)false)).getLogger("LaunchWrapper");
            RegexFilter filter = null;
            for (Method method : RegexFilter.class.getMethods()) {
                if (!method.getName().equals("createFilter")) continue;
                if (method.getParameterCount() == 5) {
                    filter = (RegexFilter)method.invoke(null, "The jar file .* has a security seal for path .*, but that path is defined and not secure", null, false, Filter.Result.DENY, Filter.Result.NEUTRAL);
                    break;
                }
                if (method.getParameterCount() == 4) {
                    filter = (RegexFilter)method.invoke(null, "The jar file .* has a security seal for path .*, but that path is defined and not secure", "false", "deny", "neutral");
                    break;
                }
                throw new IllegalStateException("Unknown createFilter arity " + method);
            }
            if (filter == null) {
                throw new IllegalStateException("Couldn't find createFilter method");
            }
            logger.addFilter(filter);
        }
        catch (Exception e) {
            System.out.println("Failed to silence log4j");
            e.printStackTrace();
        }
    }

    private void detectMods() {
        File[] coreModList;
        File mods = new File(Launch.minecraftHome, "mods");
        if (!mods.exists()) {
            mods.mkdirs();
        }
        for (File file : coreModList = mods.listFiles((dir, name) -> name.endsWith(".jar"))) {
            try (ZipFile zipFile2 = new ZipFile(file);){
                ZipEntry entry = zipFile2.getEntry("mcmod.info");
                if (zipFile2.getEntry("io/framesplus/FramesPlus.class") != null) {
                    this.halt("Patcher is no longer compatible with Frames+ as of 1.3. The Frames+ enhancements have been rewritten for even greater performance and compatibility, and are now included in Patcher.");
                    continue;
                }
                if (zipFile2.getEntry("club/sk1er/mods/core/ModCore.class") != null) {
                    this.halt("ModCore should not be in your mods folder. This will most likely cause issues and crash. Please remove it from the mods folder.");
                    continue;
                }
                if (entry == null) continue;
                try (InputStream inputStream = zipFile2.getInputStream(entry);){
                    String modId;
                    byte[] availableBytes = new byte[inputStream.available()];
                    inputStream.read(availableBytes, 0, inputStream.available());
                    JsonObject modInfo = new JsonParser().parse(new String(availableBytes)).getAsJsonArray().get(0).getAsJsonObject();
                    if (!modInfo.has("modid") || !(modId = modInfo.get("modid").getAsString()).equals("the5zigMod") || !modInfo.has("url") || modInfo.get("url").getAsString().equalsIgnoreCase("https://5zigreborn.eu")) continue;
                    this.halt("<html><p>Patcher is not compatible with old 5zig. Please use 5zig reborn found at <a href=\"https://5zigreborn.eu\">https://5zigreborn.eu</a></p></html>");
                }
            }
            catch (MalformedJsonException | IllegalStateException zipFile2) {
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void halt(String message) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JOptionPane.showMessageDialog(null, message, "Launch Aborted", 0);
        PatcherTweaker.invokeExit();
    }

    static void invokeExit() {
        try {
            Class<?> aClass = Class.forName("java.lang.Shutdown");
            Method exit = aClass.getDeclaredMethod("exit", Integer.TYPE);
            exit.setAccessible(true);
            exit.invoke(null, 0);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }
}

