/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.patcher.asm.external.mods.levelhead;

import club.sk1er.patcher.config.PatcherConfig;
import club.sk1er.patcher.tweaker.transform.CommonTransformer;
import net.minecraft.scoreboard.ScoreObjective;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class LevelheadAboveHeadRenderTransformer
implements CommonTransformer {
    @Override
    public String[] getClassName() {
        return new String[]{"club.sk1er.mods.levelhead.renderer.LevelheadAboveHeadRender"};
    }

    @Override
    public void transform(ClassNode classNode, String name) {
        block0: for (MethodNode methodNode : classNode.methods) {
            if (methodNode.name.equals("renderName")) {
                methodNode.instructions.insert(this.modifyNametagRenderState(true));
                this.makeNametagTransparent(methodNode);
                continue;
            }
            if (!methodNode.name.equals("render")) continue;
            this.makeNametagShadowed(methodNode);
            int scoreObjectiveIndex = -1;
            for (LocalVariableNode variable : methodNode.localVariables) {
                if (!variable.name.equals("scoreObjective")) continue;
                scoreObjectiveIndex = variable.index;
                break;
            }
            for (AbstractInsnNode next : methodNode.instructions) {
                if (!(next instanceof InsnNode) || next.getOpcode() != 14) continue;
                methodNode.instructions.insert(next, this.moveNametag(scoreObjectiveIndex));
                methodNode.instructions.remove(next);
                continue block0;
            }
        }
    }

    private InsnList moveNametag(int scoreObjectiveIndex) {
        InsnList list = new InsnList();
        list.add((AbstractInsnNode)new VarInsnNode(25, scoreObjectiveIndex));
        list.add((AbstractInsnNode)new MethodInsnNode(184, "club/sk1er/patcher/asm/external/mods/levelhead/LevelheadAboveHeadRenderTransformer", "getPatcherOffset", "(Lnet/minecraft/scoreboard/ScoreObjective;)D", false));
        return list;
    }

    public static double getPatcherOffset(ScoreObjective scoreObjective) {
        return PatcherConfig.showOwnNametag ? (scoreObjective == null ? 0.3 : 0.6) : 0.0;
    }
}

