/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.eventhandler;

import com.google.common.base.Preconditions;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.ListenerList;

public abstract class Event {
    private boolean isCanceled = false;
    private EventPriority phase = null;

    public boolean isCancelable() {
        return false;
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public void setCanceled(boolean cancel) {
        if (!this.isCancelable()) {
            throw new IllegalArgumentException("Attempted to cancel a uncancelable event");
        }
        this.isCanceled = cancel;
    }

    public abstract ListenerList getListenerList();

    public EventPriority getPhase() {
        return this.phase;
    }

    public void setPhase(EventPriority value) {
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)"setPhase argument must not be null");
        int prev = this.phase == null ? -1 : this.phase.ordinal();
        Preconditions.checkArgument((prev < value.ordinal() ? 1 : 0) != 0, (String)"Attempted to set event phase to %s when already %s", (Object[])new Object[]{value, this.phase});
        this.phase = value;
    }
}

