/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.utils.texture;

import com.google.common.collect.Iterables;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import java.net.Proxy;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.labymod.support.util.Debug;
import net.labymod.utils.Consumer;
import net.labymod.utils.UUIDFetcher;

public class PlayerSkinTextureCache {
    private final Map<UUID, jy> loadedSkins = new HashMap<UUID, jy>();
    private final Map<String, jy> loadedUsernameSkins = new HashMap<String, jy>();
    private final ExecutorService executorService = Executors.newFixedThreadPool(3);
    private final YggdrasilAuthenticationService authService = new YggdrasilAuthenticationService(Proxy.NO_PROXY, UUID.randomUUID().toString());
    private final MinecraftSessionService sessionService = this.authService.createMinecraftSessionService();

    public jy getSkinTexture(GameProfile gameProfile) {
        return this.getSkinTexture(gameProfile.getId());
    }

    public jy getSkinTexture(final String username) {
        jy resourceLocation = this.loadedUsernameSkins.get(username);
        if (resourceLocation == null) {
            this.loadTexture(null, username, new Consumer<jy>(){

                @Override
                public void accept(jy loadedTexture) {
                    PlayerSkinTextureCache.this.loadedUsernameSkins.put(username, loadedTexture);
                }
            });
        }
        return resourceLocation;
    }

    public jy getSkinTexture(final UUID uuid) {
        jy resourceLocation = this.loadedSkins.get(uuid);
        if (resourceLocation == null) {
            this.loadTexture(uuid, null, new Consumer<jy>(){

                @Override
                public void accept(jy loadedTexture) {
                    PlayerSkinTextureCache.this.loadedSkins.put(uuid, loadedTexture);
                }
            });
        }
        return resourceLocation;
    }

    private void loadTexture(final UUID uuid, final String username, final Consumer<jy> callback) {
        callback.accept(bmz.a());
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    final GameProfile gameProfile = PlayerSkinTextureCache.this.updateGameprofile(new GameProfile(uuid, username));
                    final Map map = ave.A().ab().a(gameProfile);
                    ave.A().a(new Runnable(){

                        @Override
                        public void run() {
                            jy resourceLocation;
                            if (map.containsKey(MinecraftProfileTexture.Type.SKIN)) {
                                resourceLocation = ave.A().ab().a((MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN);
                            } else {
                                UUID uuid = wn.a((GameProfile)gameProfile);
                                resourceLocation = bmz.a((UUID)uuid);
                            }
                            callback.accept(resourceLocation);
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private GameProfile updateGameprofile(GameProfile input) {
        if (input != null) {
            if (input.isComplete() && input.getProperties().containsKey((Object)"textures")) {
                return input;
            }
            try {
                Property property;
                GameProfile gameprofile = input;
                if (input.getId() == null && input.getName() != null) {
                    gameprofile = new GameProfile(UUIDFetcher.getUUID(input.getName()), input.getName());
                }
                if ((property = (Property)Iterables.getFirst((Iterable)gameprofile.getProperties().get((Object)"textures"), null)) == null) {
                    gameprofile = this.sessionService.fillProfileProperties(gameprofile, true);
                }
                return gameprofile;
            }
            catch (NullPointerException exception) {
                Debug.log(Debug.EnumDebugMode.GENERAL, String.format("A player with the name \"%s\" does not exist!", input.getName()));
                return input;
            }
        }
        return input;
    }
}

