/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.utils.manager;

import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import net.labymod.support.util.Debug;
import org.apache.commons.io.IOUtils;

public class ConfigManager<T> {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private File file;
    private Class<? extends T> configDefaults;
    private T settings;

    public ConfigManager(File file, Class<? extends T> configDefaults) {
        this.file = (File)Preconditions.checkNotNull((Object)file);
        this.configDefaults = (Class)Preconditions.checkNotNull(configDefaults);
        this.loadConfig(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadConfig(boolean reload) {
        if (!this.file.getParentFile().exists()) {
            this.file.getParentFile().mkdir();
        }
        boolean createdNewFile = false;
        if (reload && this.file.exists()) {
            createdNewFile = true;
        }
        if (!this.file.exists()) {
            try {
                this.file.createNewFile();
                createdNewFile = true;
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(this.file);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        try {
            this.settings = GSON.fromJson(createdNewFile ? GSON.toJson(this.configDefaults.newInstance()) : IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8), this.configDefaults);
            Debug.log(Debug.EnumDebugMode.CONFIG_MANAGER, this.settings != null ? "Loaded " + this.file.getName() + "!" : "Loaded file but settings is null");
            if (!reload && this.settings == null) {
                this.loadConfig(true);
            } else if (this.settings != null) {
                this.save();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Debug.log(Debug.EnumDebugMode.CONFIG_MANAGER, "Failed to load " + this.file.getName() + " config!");
            if (!reload) {
                this.loadConfig(true);
            }
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void save() {
        try {
            PrintWriter w = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(this.file), StandardCharsets.UTF_8), true);
            w.print(GSON.toJson(this.settings));
            w.flush();
            w.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public T getSettings() {
        return this.settings;
    }

    public File getFile() {
        return this.file;
    }
}

