/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.utils.credentials.windows;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.nio.charset.StandardCharsets;
import net.labymod.accountmanager.storage.StorageType;
import net.labymod.accountmanager.storage.credentials.CredentialsAccessor;
import net.labymod.accountmanager.storage.credentials.windows.CredentialType;
import net.labymod.utils.credentials.windows.Advapi32_Credentials;
import net.labymod.utils.credentials.windows.Credential;

public class WindowsCredentialsAccessor
implements CredentialsAccessor {
    @Override
    public String getValue(StorageType type, String id) throws Exception {
        String key = type.createKey(id);
        IntByReference reference = new IntByReference();
        PointerByReference pointerByReference = new PointerByReference();
        boolean result = Advapi32_Credentials.INSTANCE.CredEnumerateW(null, 0, reference, pointerByReference);
        if (!result) {
            throw new RuntimeException("Failed to retrieve credential entries. Error code: " + Native.getLastError());
        }
        Pointer[] pointers = pointerByReference.getValue().getPointerArray(0L, reference.getValue());
        for (int i = 0; i < reference.getValue(); ++i) {
            try {
                String address;
                Credential credential = new Credential(pointers[i]);
                credential.read();
                if (CredentialType.fromCode(credential.Type) != CredentialType.CRED_TYPE_GENERIC || (address = credential.TargetName.getString(0L, true)) == null || !address.equals(key) || credential.CredentialBlobSize <= 0) continue;
                byte[] bytes = credential.CredentialBlob.getByteArray(0L, credential.CredentialBlobSize);
                return new String(bytes, StandardCharsets.UTF_8);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public void setValue(StorageType type, String id, String value) throws Exception {
        String key = type.createKey(id);
        byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
        Credential credential = new Credential();
        credential.Flags = 0;
        credential.Type = CredentialType.CRED_TYPE_GENERIC.getCode();
        credential.TargetName = new Memory((long)Native.WCHAR_SIZE * (long)(key.length() + 1));
        credential.TargetName.setString(0L, key, true);
        credential.CredentialBlobSize = bytes.length;
        credential.CredentialBlob = new Memory((long)credential.CredentialBlobSize);
        credential.CredentialBlob.write(0L, bytes, 0, credential.CredentialBlobSize);
        credential.Persist = Credential.CRED_PERSIST_LOCAL_MACHINE;
        boolean result = Advapi32_Credentials.INSTANCE.CredWriteW(credential, 0);
        if (!result) {
            throw new RuntimeException("Failed to create credential entry. Error code: " + Native.getLastError());
        }
    }
}

