/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.utils;

import java.util.Locale;

public enum OSUtil {
    WIN_32("dll", "windows", ""),
    WIN_64("dll", "windows", ""),
    MAC("dylib", "macos", "lib"),
    UNIX("so", "linux", "lib"),
    UNKNOWN(null, null, null);

    private static final String OS;
    private String libraryExtensionName;
    private String name;
    private String libraryPrefix;

    public static OSUtil getOS() {
        if (OSUtil.isMac()) {
            return MAC;
        }
        if (OSUtil.isUnix()) {
            return UNIX;
        }
        if (OSUtil.isWindows()) {
            return System.getenv("ProgramFiles(x86)") != null ? WIN_64 : WIN_32;
        }
        return UNKNOWN;
    }

    public String getLibraryFileName(String name) {
        return String.format("%s%s-%s.%s", this.getLibraryPrefix(), name, this.is64() ? "64" : "32", this.getLibraryExtensionName());
    }

    public String getLibraryJarName(String name, String version) {
        return String.format("%s-%s-natives-%s-x%s.jar", name, version, this.name, this.is64() ? "64" : "32");
    }

    public boolean isLibrary(String name) {
        return name.endsWith(this.libraryExtensionName);
    }

    private boolean is64() {
        return this != WIN_32;
    }

    public static boolean isWindows() {
        return OS.indexOf("win") >= 0;
    }

    public static boolean isMac() {
        return OS.indexOf("mac") >= 0;
    }

    public static boolean isUnix() {
        return OS.indexOf("nix") >= 0 || OS.indexOf("nux") >= 0 || OS.indexOf("aix") > 0;
    }

    public static boolean isSolaris() {
        return OS.indexOf("sunos") >= 0;
    }

    public String getLibraryExtensionName() {
        return this.libraryExtensionName;
    }

    public String getName() {
        return this.name;
    }

    public String getLibraryPrefix() {
        return this.libraryPrefix;
    }

    private OSUtil(String libraryExtensionName, String name, String libraryPrefix) {
        this.libraryExtensionName = libraryExtensionName;
        this.name = name;
        this.libraryPrefix = libraryPrefix;
    }

    static {
        OS = System.getProperty("os.name").toLowerCase(Locale.ENGLISH);
    }
}

