/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Formatter;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import javax.net.ssl.HttpsURLConnection;
import net.labymod.main.lang.LanguageManager;
import org.apache.commons.io.IOUtils;

public class ModUtils {
    public static String getProfileNameByIp(String ip2) {
        String[] parts;
        if (ip2 == null) {
            return null;
        }
        if (ip2.contains(":")) {
            ip2 = ip2.split(":")[0];
        }
        if (ip2.contains(".") && (parts = ip2.split("\\.")).length >= 2) {
            return parts[parts.length - 2] + "." + parts[parts.length - 1];
        }
        return ip2.toLowerCase();
    }

    public static List<String> extractUrls(String text) {
        ArrayList<String> containedUrls = new ArrayList<String>();
        String urlRegex = "((https?|ftp|gopher|telnet|file):((//)|(\\\\))+[\\w\\d:#@%/;$()~_?\\+-=\\\\\\.&]*)";
        Pattern pattern = Pattern.compile(urlRegex, 2);
        Matcher urlMatcher = pattern.matcher(text);
        while (urlMatcher.find()) {
            containedUrls.add(text.substring(urlMatcher.start(0), urlMatcher.end(0)));
        }
        return containedUrls;
    }

    public static String download(String urlStr) {
        try {
            URL url = new URL(urlStr);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            HttpURLConnection.setFollowRedirects(true);
            conn.setRequestProperty("Accept-Encoding", "gzip, deflate");
            String encoding = conn.getContentEncoding();
            InputStream inStr = null;
            inStr = encoding != null && encoding.equalsIgnoreCase("gzip") ? new GZIPInputStream(conn.getInputStream()) : (encoding != null && encoding.equalsIgnoreCase("deflate") ? new InflaterInputStream(conn.getInputStream(), new Inflater(true)) : conn.getInputStream());
            return IOUtils.toString((InputStream)inStr);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getContentString(String page) {
        try {
            String line;
            HttpURLConnection connection = (HttpURLConnection)new URL(page).openConnection();
            connection.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.95 Safari/537.11");
            connection.connect();
            BufferedReader r = new BufferedReader(new InputStreamReader(connection.getInputStream(), Charset.forName("UTF-8")));
            String s = "";
            while ((line = r.readLine()) != null) {
                s = s + line;
            }
            return s;
        }
        catch (Exception error) {
            error.printStackTrace();
            return "";
        }
    }

    public static ArrayList<String> getContentList(String page) {
        try {
            String line;
            HttpURLConnection connection = (HttpURLConnection)new URL(page).openConnection();
            connection.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.95 Safari/537.11");
            connection.connect();
            BufferedReader r = new BufferedReader(new InputStreamReader(connection.getInputStream(), Charset.forName("UTF-8")));
            ArrayList<String> s = new ArrayList<String>();
            while ((line = r.readLine()) != null) {
                s.add(line);
            }
            return s;
        }
        catch (Exception error) {
            error.printStackTrace();
            return new ArrayList<String>();
        }
    }

    public static String parseTimeNormalize(long time) {
        long formatb = time / 60L % 60L;
        long formatc = time % 60L;
        long formatd = time / 600L / 60L % 24L;
        long formate = time / 600L / 60L / 24L;
        String out = "";
        if (formate != 0L) {
            out = out + formate + "d ";
        }
        if (formatd != 0L) {
            out = out + formatd + "h ";
        }
        if (formatb != 0L) {
            out = out + formatb + "m ";
        }
        if (formatc != 0L) {
            out = out + formatc + "s";
        }
        return out;
    }

    public static String performPost(URL url, String parameters, String contentType, boolean returnErrorPage) throws IOException {
        String line;
        BufferedReader reader;
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        byte[] paramAsBytes = parameters.getBytes(Charset.forName("UTF-8"));
        connection.setConnectTimeout(15000);
        connection.setReadTimeout(15000);
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", contentType + "; charset=utf-8");
        connection.setRequestProperty("Content-Length", "" + paramAsBytes.length);
        connection.setRequestProperty("Content-Language", "en-US");
        connection.setUseCaches(false);
        connection.setDoInput(true);
        connection.setDoOutput(true);
        DataOutputStream writer = new DataOutputStream(connection.getOutputStream());
        writer.write(paramAsBytes);
        writer.flush();
        writer.close();
        try {
            reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        }
        catch (IOException e) {
            if (returnErrorPage) {
                InputStream stream = connection.getErrorStream();
                if (stream != null) {
                    reader = new BufferedReader(new InputStreamReader(stream));
                }
                throw e;
            }
            throw e;
        }
        StringBuilder response = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            response.append(line);
            response.append('\r');
        }
        reader.close();
        return response.toString();
    }

    public static URL constantURL(String input) {
        try {
            return new URL(input);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public static String jsonPost(String urlStr, String json) throws Exception {
        URL url = new URL(urlStr);
        HttpsURLConnection httpConnection = (HttpsURLConnection)url.openConnection();
        httpConnection.setDoOutput(true);
        httpConnection.setDoInput(true);
        httpConnection.setRequestProperty("Content-Type", "application/json");
        httpConnection.setRequestMethod("POST");
        OutputStreamWriter out = new OutputStreamWriter(httpConnection.getOutputStream());
        out.write(json);
        out.close();
        BufferedReader br = new BufferedReader(new InputStreamReader(httpConnection.getInputStream()));
        StringBuffer sb = new StringBuffer();
        String str = br.readLine();
        while (str != null) {
            sb.append(str);
            str = br.readLine();
        }
        br.close();
        return sb.toString();
    }

    public static String normalizeString(String input) {
        char[] c2 = input.toLowerCase().toCharArray();
        c2[0] = Character.toUpperCase(c2[0]);
        return new String(c2);
    }

    public static String sha1(String string) {
        String sha1 = "";
        try {
            MessageDigest crypt = MessageDigest.getInstance("SHA-1");
            crypt.reset();
            crypt.update(string.getBytes("UTF-8"));
            sha1 = ModUtils.byteToHex(crypt.digest());
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return sha1;
    }

    private static String byteToHex(byte[] hash) {
        Formatter formatter = new Formatter();
        for (byte b2 : hash) {
            formatter.format("%02x", b2);
        }
        String result = formatter.toString();
        formatter.close();
        return result;
    }

    public static String translateAlternateColorCodes(char altColorChar, String textToTranslate) {
        char[] b2 = textToTranslate.toCharArray();
        for (int i = 0; i < b2.length - 1; ++i) {
            if (b2[i] != altColorChar || "0123456789AaBbCcDdEeFfKkLlMmNnOoRr".indexOf(b2[i + 1]) <= -1) continue;
            b2[i] = 167;
            b2[i + 1] = Character.toLowerCase(b2[i + 1]);
        }
        return new String(b2);
    }

    public static String parseTimer(int seconds) {
        return seconds >= 3600 ? String.format("%02d:%02d", seconds / 60 / 60, seconds / 60, seconds % 60) : String.format("%02d:%02d", seconds / 60, seconds % 60);
    }

    public static String humanReadableByteCount(long bytes, boolean si, boolean space) {
        int unit;
        int n = unit = si ? 1000 : 1024;
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String pre = (si ? "kMGTPE" : "KMGTPE").charAt(exp - 1) + (si ? "" : "i");
        return String.format("%.1f" + (space ? " " : "") + "%sB", (double)bytes / Math.pow(unit, exp), pre);
    }

    public static String getTimeDiff(long timestamp) {
        if (timestamp == 0L) {
            return LanguageManager.translate("time_unknown");
        }
        long time = System.currentTimeMillis() - timestamp;
        if (time == 0L) {
            return LanguageManager.translate("time_now");
        }
        if (time < 0L) {
            return LanguageManager.translate("time_future");
        }
        long secs = time / 1000L;
        long mins = secs / 60L;
        long hours = mins / 60L;
        long days = hours / 24L;
        long months = days / 31L;
        long years = months / 12L;
        String date = null;
        date = months >= 12L ? years + " " + LanguageManager.translate("time_" + (years == 1L ? "year" : "years")) : (days >= 31L ? months + " " + LanguageManager.translate("time_" + (months == 1L ? "month" : "months")) : (hours >= 24L ? days + " " + LanguageManager.translate("time_" + (days == 1L ? "day" : "days")) : (mins >= 60L ? hours + " " + LanguageManager.translate("time_" + (hours == 1L ? "hour" : "hours")) : (secs >= 60L ? mins + " " + LanguageManager.translate("time_" + (mins == 1L ? "minute" : "minutes")) : secs + " " + LanguageManager.translate("time_" + (secs == 1L ? "second" : "seconds"))))));
        date = LanguageManager.translate("time_ago", date).toLowerCase();
        return date;
    }

    public static String getStringByInputStream(InputStream inputStream) {
        StringBuilder sb = new StringBuilder();
        try {
            int ch;
            while ((ch = inputStream.read()) != -1) {
                sb.append((char)ch);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    public static String getMAC() {
        byte[] mac = new byte[6];
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                byte[] elementMac;
                NetworkInterface networkInterface = networkInterfaces.nextElement();
                if (networkInterface.isVirtual() || !networkInterface.isUp() || (elementMac = networkInterface.getHardwareAddress()) == null) continue;
                mac = elementMac;
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < mac.length; ++i) {
            stringBuilder.append(String.format("%02X%s", mac[i], i < mac.length - 1 ? "-" : ""));
        }
        return stringBuilder.toString();
    }

    public static class ConvertJsonToObject {
        private static Gson gson = new GsonBuilder().setPrettyPrinting().create();

        public static final <T> T getFromJSON(String json, Class<T> clazz) {
            return (T)gson.fromJson(json, clazz);
        }

        public static final <T> String toJSON(T clazz) {
            return gson.toJson(clazz);
        }
    }
}

