/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.utils;

import java.io.File;

public class LauncherDirectoryUtils {
    public static File getWorkingDirectory() {
        return LauncherDirectoryUtils.getWorkingDirectory("minecraft");
    }

    public static File getWorkingDirectory(String applicationName) {
        String userHome = System.getProperty("user.home", ".");
        File workingDirectory = null;
        switch (LauncherDirectoryUtils.getPlatform()) {
            case LINUX: {
                workingDirectory = new File(userHome, '.' + applicationName + '/');
                break;
            }
            case UNKNOWN: {
                workingDirectory = new File(userHome, "Library/Application Support/" + applicationName);
                break;
            }
            case WINDOWS: {
                String applicationData = System.getenv("APPDATA");
                if (applicationData != null) {
                    workingDirectory = new File(applicationData, "." + applicationName + '/');
                    break;
                }
                workingDirectory = new File(userHome, '.' + applicationName + '/');
                break;
            }
            case MACOS: {
                workingDirectory = new File(userHome, "Library/Application Support/" + applicationName);
                break;
            }
            case SOLARIS: {
                String applicationDataW = System.getenv("APPDATA");
                if (applicationDataW != null) {
                    workingDirectory = new File(applicationDataW, "." + applicationName + '/');
                    break;
                }
                workingDirectory = new File(userHome, '.' + applicationName + '/');
                break;
            }
            default: {
                workingDirectory = new File(userHome, applicationName + '/');
            }
        }
        if (!workingDirectory.exists() && !workingDirectory.mkdirs()) {
            throw new RuntimeException("The working directory could not be created: " + workingDirectory);
        }
        return workingDirectory;
    }

    public static OS getPlatform() {
        String osName = System.getProperty("os.name").toLowerCase();
        for (OS os : OS.values()) {
            if (os == OS.UNKNOWN) continue;
            for (String name : os.getOsNames()) {
                if (!osName.contains(name)) continue;
                return os;
            }
        }
        return OS.UNKNOWN;
    }

    public static enum OS {
        LINUX("linux", "unix"),
        SOLARIS("solaris", "sunos"),
        WINDOWS("win"),
        MACOS("mac"),
        UNKNOWN(new String[0]);

        private String[] osNames;

        private OS(String ... osNames) {
            this.osNames = osNames;
        }

        public String[] getOsNames() {
            return this.osNames;
        }
    }
}

