/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.user.group;

import com.google.gson.Gson;
import java.util.HashMap;
import java.util.Map;
import net.labymod.support.util.Debug;
import net.labymod.user.User;
import net.labymod.user.group.GroupData;
import net.labymod.user.group.LabyGroup;
import net.labymod.utils.request.DownloadServerRequest;
import net.labymod.utils.request.RequestException;
import net.labymod.utils.request.ServerResponse;

public class GroupManager {
    public static final LabyGroup DEFAULT_GROUP = new LabyGroup(0, "user", "User", null, 'f', "USER", "NONE", null, null).init();
    public static final short GROUP_ID_PLUS = 10;
    public static final short GROUP_ID_COSMETIC_CREATOR = 11;
    private final Gson gson = new Gson();
    private Map<Short, LabyGroup> groups = new HashMap<Short, LabyGroup>();
    private Short[] groupOrder = new Short[0];

    public GroupManager() {
        this.load();
    }

    public void load() {
        DownloadServerRequest.getStringAsync("https://dl.labymod.net/groups.json", new ServerResponse<String>(){

            @Override
            public void success(String json) {
                HashMap<Short, LabyGroup> map = new HashMap<Short, LabyGroup>();
                GroupData groupData = (GroupData)GroupManager.this.gson.fromJson(json, GroupData.class);
                LabyGroup[] labyGroups = groupData.getGroups();
                Short[] array = new Short[labyGroups.length];
                int index = 0;
                for (LabyGroup group : labyGroups) {
                    short id = (short)group.getId();
                    group.init();
                    map.put(id, group);
                    array[index] = id;
                    ++index;
                }
                GroupManager.this.groups = map;
                GroupManager.access$202(GroupManager.this, array);
            }

            @Override
            public void failed(RequestException exception) {
                exception.printStackTrace();
                Debug.log(Debug.EnumDebugMode.USER_MANAGER, "Wrong response code while loading groups: " + exception.getCode());
            }
        });
    }

    public LabyGroup getGroupById(short id) {
        if (id == DEFAULT_GROUP.getId()) {
            return DEFAULT_GROUP;
        }
        return this.groups.get(id);
    }

    public boolean hasPermissionOf(User user, short groupId) {
        LabyGroup userGroup = user.getGroup();
        if (groupId == DEFAULT_GROUP.getId()) {
            return true;
        }
        if (userGroup == null) {
            return false;
        }
        short userGroupId = (short)userGroup.getId();
        Short[] shortArray = this.groupOrder;
        int n = shortArray.length;
        for (int i = 0; i < n; ++i) {
            short orderId = shortArray[i];
            if (orderId == userGroupId) {
                return true;
            }
            if (orderId != groupId) continue;
            return false;
        }
        return false;
    }

    static /* synthetic */ Short[] access$202(GroupManager x0, Short[] x1) {
        x0.groupOrder = x1;
        return x1;
    }
}

