/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.user.cosmetic.remote;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import net.labymod.main.LabyMod;
import net.labymod.main.Source;
import net.labymod.support.util.Debug;
import net.labymod.user.cosmetic.CosmeticRenderer;
import net.labymod.user.cosmetic.custom.AnimatedResourceLocation;
import net.labymod.user.cosmetic.custom.handler.RemoteImageHandler;
import net.labymod.user.cosmetic.geometry.IGeometryProviderCallback;
import net.labymod.user.cosmetic.remote.IRemoteCallback;
import net.labymod.user.cosmetic.remote.IRemoteLoadCallback;
import net.labymod.user.cosmetic.remote.model.EnumCosmeticType;
import net.labymod.user.cosmetic.remote.model.EnumTextureType;
import net.labymod.user.cosmetic.remote.model.RemoteCosmeticIndex;
import net.labymod.user.cosmetic.remote.model.RemoteObject;
import net.labymod.user.cosmetic.remote.objects.RemoteCosmetic;
import net.labymod.user.cosmetic.remote.objects.RemotePet;
import net.labymod.user.cosmetic.remote.objects.data.RemoteData;
import net.labymod.utils.request.DownloadServerRequest;
import net.labymod.utils.request.RequestException;
import net.labymod.utils.request.ServerResponse;
import net.labymod.utils.texture.PlayerSkinTextureCache;

public class RemoteCosmeticLoader {
    public static final Gson GSON = new Gson();
    private RemoteCosmeticIndex index;
    private final List<CosmeticRenderer<?>> remoteRenderer = new CopyOnWriteArrayList();
    private final List<IRemoteCallback> listener = new CopyOnWriteArrayList<IRemoteCallback>();
    private Map<Integer, RemoteObject> discoverableRemoteObjects = new HashMap<Integer, RemoteObject>();
    private final List<Integer> alreadyDiscovered = new ArrayList<Integer>();
    private boolean remoteRefresh;

    public void load() {
        final boolean clientCanSeeDraftCosmetics = LabyMod.getInstance().getUserManager().getClientUser().isCanSeeDraftCosmetics();
        DownloadServerRequest.getStringAsync("https://dl.labymod.net/cosmetics/index.json", new ServerResponse<String>(){

            @Override
            public void success(String json) {
                try {
                    RemoteCosmeticLoader.this.index = (RemoteCosmeticIndex)GSON.fromJson(json, RemoteCosmeticIndex.class);
                    HashMap<Integer, RemoteObject> discoverableRemoteObjects = new HashMap<Integer, RemoteObject>();
                    if (RemoteCosmeticLoader.this.index != null && ((RemoteCosmeticLoader)RemoteCosmeticLoader.this).index.cosmetics != null) {
                        for (RemoteObject cosmetic : ((RemoteCosmeticLoader)RemoteCosmeticLoader.this).index.cosmetics.values()) {
                            if (!clientCanSeeDraftCosmetics && cosmetic.draft) continue;
                            discoverableRemoteObjects.put(cosmetic.id, cosmetic);
                        }
                        RemoteCosmeticLoader.this.discoverableRemoteObjects = discoverableRemoteObjects;
                        for (Integer id : RemoteCosmeticLoader.this.alreadyDiscovered) {
                            RemoteCosmeticLoader.this.discover(id);
                        }
                        RemoteCosmeticLoader.this.alreadyDiscovered.clear();
                        if (!RemoteCosmeticLoader.this.remoteRefresh) {
                            LabyMod.getInstance().getUserManager().refresh();
                            RemoteCosmeticLoader.this.remoteRefresh = true;
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void failed(RequestException e) {
                e.printStackTrace();
            }
        });
    }

    public void discover(int objectId) {
        RemoteObject object = this.discoverableRemoteObjects.remove(objectId);
        if (object == null) {
            if (!this.alreadyDiscovered.contains(objectId)) {
                this.alreadyDiscovered.add(objectId);
            }
            return;
        }
        if (object.type == EnumCosmeticType.COSMETIC) {
            this.loadRemote(object, RemoteCosmetic::new);
        }
        if (object.type.isPet()) {
            this.loadRemote(object, RemotePet::new);
        }
    }

    protected void loadRemote(RemoteObject object, IRemoteLoadCallback callback) {
        Debug.log(Debug.EnumDebugMode.REMOTE_COSMETIC, "Load remote cosmetic " + object.name + " with id " + object.id + " as " + object.type.name());
        try {
            final String geometryJson = DownloadServerRequest.getString(String.format("https://dl.labymod.net/cosmetics/%s/geo.json", object.id));
            final String animationJson = DownloadServerRequest.getString(String.format("https://dl.labymod.net/cosmetics/%s/animation.json", object.id));
            if (object.textureType == EnumTextureType.MOJANG_BOUND) {
                CosmeticRenderer<?> renderer = callback.getRemoteRenderer(object, new IGeometryProviderCallback<RemoteData>(){

                    @Override
                    public String getGeometryJson() {
                        return geometryJson;
                    }

                    @Override
                    public String getAnimationJson() {
                        return animationJson;
                    }

                    @Override
                    public jy getTexture(pk entity, RemoteData data) {
                        PlayerSkinTextureCache textureLoader = LabyMod.getInstance().getDrawUtils().getPlayerSkinTextureCache();
                        if (data.textureUUID == null) {
                            return textureLoader.getSkinTexture(entity.aK());
                        }
                        return textureLoader.getSkinTexture(data.textureUUID);
                    }
                });
                this.remoteRenderer.add(renderer);
                for (IRemoteCallback listener : this.listener) {
                    listener.load(renderer);
                }
            } else {
                boolean userBound = object.textureType == EnumTextureType.USER_BOUND;
                final RemoteImageHandler handler = new RemoteImageHandler(object.id, Source.getUserAgent(), userBound, object.textureDirectory, object.ratio, object.textureType == EnumTextureType.USER_BOUND, object.hideCape);
                LabyMod.getInstance().getUserManager().getCosmeticImageManager().getCosmeticImageHandlers().add(handler);
                CosmeticRenderer<?> renderer = callback.getRemoteRenderer(object, new IGeometryProviderCallback<RemoteData>(){

                    @Override
                    public String getGeometryJson() {
                        return geometryJson;
                    }

                    @Override
                    public String getAnimationJson() {
                        return animationJson;
                    }

                    @Override
                    public jy getTexture(pk entity, RemoteData data) {
                        AnimatedResourceLocation texture = handler.getAnimatedResourceLocation((bet)entity);
                        if (texture != null) {
                            data.updateDepthMap(texture.getDepthMap());
                        }
                        return texture == null ? null : texture.getFrameAtCurrentTime();
                    }
                });
                this.remoteRenderer.add(renderer);
                for (IRemoteCallback listener : this.listener) {
                    listener.load(renderer);
                }
            }
        }
        catch (Exception e) {
            Debug.log(Debug.EnumDebugMode.REMOTE_COSMETIC, "Could not download remote cosmetic " + object.name + " (" + object.id + "): " + e.getMessage());
        }
    }

    public void getAsync(IRemoteCallback consumer) {
        for (CosmeticRenderer<?> cosmeticRenderer : new ArrayList(this.remoteRenderer)) {
            consumer.load(cosmeticRenderer);
        }
        this.listener.add(consumer);
    }

    public RemoteCosmeticIndex getIndex() {
        return this.index;
    }

    public RemoteObject getObject(int id) {
        Collection<RemoteObject> cosmetics = LabyMod.getInstance().getUserManager().getRemoteCosmeticLoader().getIndex().cosmetics.values();
        for (RemoteObject object : cosmetics) {
            if (object.id != id) continue;
            return object;
        }
        return null;
    }

    public void reset() {
        for (IRemoteCallback callback : this.listener) {
            for (CosmeticRenderer<?> cosmeticRenderer : new ArrayList(this.remoteRenderer)) {
                callback.unload(cosmeticRenderer);
            }
        }
        this.remoteRenderer.clear();
    }
}

