/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.user.cosmetic.pet.object;

import net.labymod.main.LabyMod;
import net.labymod.user.User;
import net.labymod.user.UserManager;
import net.labymod.user.cosmetic.CosmeticRenderer;
import net.labymod.user.cosmetic.ModelCosmetics;
import net.labymod.user.cosmetic.animation.EnumTrigger;
import net.labymod.user.cosmetic.animation.IModelTransformer;
import net.labymod.user.cosmetic.geometry.TriggerHandler;
import net.labymod.user.cosmetic.pet.PetStorage;
import net.labymod.user.cosmetic.pet.ai.PetAI;
import net.labymod.user.cosmetic.pet.ai.WalkingPet;
import net.labymod.user.cosmetic.pet.util.EnumMoveType;
import net.labymod.user.cosmetic.util.CosmeticData;
import net.labymod.user.emote.EmoteRenderer;
import net.labymod.user.emote.keys.EmoteBodyPart;
import net.labymod.user.emote.keys.PoseAtTime;
import org.lwjgl.opengl.GL11;

public abstract class CosmeticPet<T extends CosmeticData>
extends CosmeticRenderer<T>
implements IModelTransformer,
TriggerHandler {
    private int id;
    public PetAI<T> ai;
    public EnumMoveType moveType = EnumMoveType.BOTH;

    public void init(int id, PetAI<T> ai) {
        this.id = id;
        this.ai = ai;
    }

    @Override
    public void render(ModelCosmetics model, pk entityIn, T cosmeticData, float scale, float movementFactor, float walkingSpeed, float currentTick, float firstRotationX, float secondRotationX, float partialTicks, boolean firstPersonContext) {
        float clientPartialTicks;
        jy resourceLocation = this.getResourceLocation((bet)entityIn, cosmeticData);
        if (resourceLocation == null) {
            return;
        }
        ave.A().P().a(resourceLocation);
        PetStorage<T> storage = this.getStorage(cosmeticData);
        if (storage == null) {
            return;
        }
        storage.ownerPosition.setX(entityIn.s).setY(entityIn.t).setZ(entityIn.u);
        EmoteRenderer playerEmoteRenderer = LabyMod.getInstance().getEmoteRegistry().getPlayingEmotes().get(entityIn.aK());
        if (playerEmoteRenderer != null && !playerEmoteRenderer.isAborted() && playerEmoteRenderer.isVisible() && !playerEmoteRenderer.isStream() && !storage.isAttachedToOwner(currentTick)) {
            for (EmoteBodyPart bodyPart : playerEmoteRenderer.getBodyParts()) {
                block5: for (PoseAtTime pose : playerEmoteRenderer.getEmotePosesAtTime()) {
                    if (pose == null || pose.getPose().getBodyPart() != bodyPart.getId()) continue;
                    switch (bodyPart.getId()) {
                        case 5: {
                            bfl.b((float)0.0f, (float)-0.4f, (float)0.0f);
                            boolean modifier = true;
                            bfl.b((float)(-bodyPart.getX() * 57.295776f * (float)modifier), (float)1.0f, (float)0.0f, (float)0.0f);
                            bfl.b((float)(-bodyPart.getY() * 57.295776f), (float)0.0f, (float)1.0f, (float)0.0f);
                            bfl.b((float)(-bodyPart.getZ() * 57.295776f), (float)0.0f, (float)0.0f, (float)1.0f);
                            bfl.b((float)0.0f, (float)0.4f, (float)0.0f);
                            continue block5;
                        }
                        case 6: {
                            bfl.b((double)((double)(-bodyPart.getX()) / 10.0), (double)((double)(-bodyPart.getY()) / 10.0), (double)((double)(-bodyPart.getZ()) / 10.0));
                        }
                    }
                }
            }
        }
        if (partialTicks != 1.0f || storage.isAttachedToOwner(currentTick)) {
            clientPartialTicks = LabyMod.getInstance().getPartialTicks();
            if (storage.lastTicks > clientPartialTicks) {
                this.ai.onTick(model, (wn)entityIn, storage, movementFactor, walkingSpeed, currentTick, clientPartialTicks);
            }
        } else {
            return;
        }
        storage.lastTicks = clientPartialTicks;
        bfl.E();
        this.ai.preRender(model, entityIn, storage, currentTick, walkingSpeed, partialTicks);
        this.ai.firstPersonTransform(entityIn, storage, firstPersonContext, partialTicks);
        if (!storage.animationController.isPlaying(currentTick)) {
            this.handleTrigger(storage.isMoving() && !storage.fakeIdle ? EnumTrigger.MOVING : EnumTrigger.IDLE, storage.animationController, currentTick, entityIn, storage);
            if (storage.isMoving()) {
                storage.standingUp = false;
            }
        }
        double rotX = storage.prevRotation.x + (storage.rotation.x - storage.prevRotation.x) * (double)partialTicks;
        double rotY = storage.prevRotation.y + (storage.rotation.y - storage.prevRotation.y) * (double)partialTicks;
        double rotZ = storage.prevRotation.z + (storage.rotation.z - storage.prevRotation.z) * (double)partialTicks;
        if (!storage.isAttachedToOwner(currentTick)) {
            bfl.b((float)((float)rotX), (float)1.0f, (float)0.0f, (float)0.0f);
            bfl.b((float)((float)rotY), (float)0.0f, (float)1.0f, (float)0.0f);
            bfl.b((float)((float)rotZ), (float)0.0f, (float)0.0f, (float)1.0f);
        }
        bfl.l();
        bfl.e();
        bfl.G();
        boolean playing = storage.animationController.isPlaying(currentTick);
        if (playing) {
            storage.animationController.transformAndRender(this, entityIn, (CosmeticData)cosmeticData, movementFactor, walkingSpeed, currentTick, scale, partialTicks, storage.rightShoulder);
        } else {
            this.renderModel(scale);
        }
        bfl.F();
    }

    @Override
    public void onRenderWorld() {
        pk entity = ave.A().ac();
        if (entity instanceof bet && ave.A().t.aB == 0) {
            bln renderplayer = (bln)ave.A().af().a((pk)((bet)entity));
            bet player = (bet)entity;
            if (renderplayer.g() instanceof ModelCosmetics) {
                boolean allowedToSee;
                UserManager userManager = LabyMod.getInstance().getUserManager();
                User user = userManager.getUser(entity.aK());
                CosmeticData data = user.getCosmetics().get(this.id);
                User clientUser = userManager.getClientUser();
                boolean canSeeDraftCosmetics = clientUser != null && clientUser.isCanSeeDraftCosmetics();
                boolean bl = allowedToSee = data != null && (!data.isDraft() || canSeeDraftCosmetics);
                if (data != null && data.isEnabled() && allowedToSee && this.ai instanceof WalkingPet) {
                    float partialTicks = LabyMod.getInstance().getPartialTicks();
                    float renderYaw = player.aJ + (player.aI - player.aJ) * partialTicks;
                    bfl.E();
                    bfl.e();
                    bfl.c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    bfl.k();
                    bfl.e();
                    bfl.c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    bfl.e();
                    bfl.a((int)0);
                    bfl.a((int)1);
                    bfl.g();
                    bfl.a((int)1032, (int)5634);
                    bfl.a((float)1.0f, (float)-1.0f, (float)-1.0f);
                    bfl.b((double)0.0, (double)-1.5, (double)0.0);
                    bfl.b((float)renderYaw, (float)0.0f, (float)1.0f, (float)0.0f);
                    this.render((ModelCosmetics)renderplayer.g(), entity, (T)data, 0.0625f, 0.0f, 0.0f, (float)player.W + partialTicks, 0.0f, 0.0f, partialTicks, true);
                    bfl.F();
                }
            }
        }
    }

    @Override
    public boolean isOfflineAvailable() {
        return false;
    }

    protected abstract jy getResourceLocation(bet var1, T var2);

    protected abstract PetStorage<T> getStorage(T var1);
}

