/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.user.cosmetic.geometry.effect.effects;

import java.util.UUID;
import net.labymod.support.util.Debug;
import net.labymod.user.cosmetic.animation.MetaEffectFrameParameter;
import net.labymod.user.cosmetic.geometry.effect.GeometryEffect;
import net.labymod.user.cosmetic.geometry.render.GeometryModelRenderer;
import net.labymod.user.cosmetic.remote.objects.data.RemoteData;

public class GeometryLayer
extends GeometryEffect {
    private UUID uuid = null;
    private boolean negate = false;
    private boolean filterSlim = false;
    private boolean filterRightSide = false;

    public GeometryLayer(String name, GeometryModelRenderer model) {
        super(name, model);
    }

    @Override
    protected boolean parse() {
        String id = this.getParameter(0);
        if (id.equals("slim")) {
            this.filterSlim = true;
        } else if (id.equals("right")) {
            this.filterRightSide = true;
        } else {
            try {
                this.uuid = UUID.fromString(id.substring(0, 8) + "-" + id.substring(8, 12) + "-" + id.substring(12, 16) + "-" + id.substring(16, 20) + "-" + id.substring(20, 32));
            }
            catch (Exception e) {
                Debug.log(Debug.EnumDebugMode.REMOTE_COSMETIC, "Invalid layer UUID: " + id);
            }
        }
        this.negate = this.hasParameter(1) && this.getParameter(1).equals("negate");
        return true;
    }

    @Override
    protected int getParametersAmount() {
        return 1;
    }

    @Override
    public void apply(RemoteData remoteData, MetaEffectFrameParameter meta) {
        if (this.uuid != null) {
            boolean bl = this.model.showModel = remoteData.textureUUID != null && this.negate != remoteData.textureUUID.equals(this.uuid);
        }
        if (this.filterSlim) {
            boolean bl = this.model.showModel = this.negate != meta.isSlim;
        }
        if (this.filterRightSide) {
            this.model.showModel = this.negate != meta.rightSide;
        }
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public boolean isNegate() {
        return this.negate;
    }

    public boolean isFilterSlim() {
        return this.filterSlim;
    }

    public boolean isFilterRightSide() {
        return this.filterRightSide;
    }
}

