/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.user.cosmetic.geometry.effect;

import net.labymod.user.cosmetic.geometry.effect.GeometryEffect;
import net.labymod.user.cosmetic.geometry.effect.effects.GeometryColor;
import net.labymod.user.cosmetic.geometry.effect.effects.GeometryCurrentTime;
import net.labymod.user.cosmetic.geometry.effect.effects.GeometryExtrude;
import net.labymod.user.cosmetic.geometry.effect.effects.GeometryGlow;
import net.labymod.user.cosmetic.geometry.effect.effects.GeometryHeadGravity;
import net.labymod.user.cosmetic.geometry.effect.effects.GeometryLayer;
import net.labymod.user.cosmetic.geometry.effect.effects.GeometryOrientation;
import net.labymod.user.cosmetic.geometry.effect.effects.GeometryPhysic;
import net.labymod.user.cosmetic.geometry.render.GeometryModelRenderer;

public enum EnumEffectType {
    PHYSICS("physics", GeometryPhysic.class),
    HEAD_GRAVITY("headgravity", GeometryHeadGravity.class),
    COLOR("color", GeometryColor.class),
    LAYER("layer", GeometryLayer.class),
    EXTRUDE("extrude", GeometryExtrude.class),
    GLOW("glow", GeometryGlow.class),
    ORIENTATION("orientation", GeometryOrientation.class),
    CURRENT_TIME("currenttime", GeometryCurrentTime.class);

    private final String prefix;
    private final Class<? extends GeometryEffect> clazz;

    private EnumEffectType(String prefix, Class<? extends GeometryEffect> clazz) {
        this.prefix = prefix;
        this.clazz = clazz;
    }

    public static EnumEffectType getEffectType(String name) {
        for (EnumEffectType type : EnumEffectType.values()) {
            if (!name.startsWith(type.prefix + "_")) continue;
            return type;
        }
        return null;
    }

    public static GeometryEffect createEffect(String name, GeometryModelRenderer model) throws Exception {
        EnumEffectType type = EnumEffectType.getEffectType(name);
        return type == null ? null : type.create(name, model);
    }

    public GeometryEffect create(String name, GeometryModelRenderer model) throws Exception {
        return this.clazz.getConstructor(String.class, GeometryModelRenderer.class).newInstance(name, model).load();
    }
}

