/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.user.cosmetic.geometry;

import net.labymod.support.util.Debug;
import net.labymod.user.cosmetic.ModelCosmetics;
import net.labymod.user.cosmetic.animation.AnimationController;
import net.labymod.user.cosmetic.animation.AnimationLoader;
import net.labymod.user.cosmetic.animation.EnumTrigger;
import net.labymod.user.cosmetic.animation.model.Animation;
import net.labymod.user.cosmetic.animation.model.KeyframeVector;
import net.labymod.user.cosmetic.geometry.BlockBenchLoader;
import net.labymod.user.cosmetic.geometry.GeometryLoader;
import net.labymod.user.cosmetic.geometry.IGeometryProviderCallback;
import net.labymod.user.cosmetic.geometry.blockbench.Item;
import net.labymod.user.cosmetic.geometry.render.GeometryModelRenderer;
import net.labymod.user.cosmetic.pet.PetStorage;
import net.labymod.user.cosmetic.pet.ai.FlyingAI;
import net.labymod.user.cosmetic.pet.ai.WalkingPet;
import net.labymod.user.cosmetic.pet.object.CosmeticPet;
import net.labymod.user.cosmetic.remote.model.EnumCosmeticType;
import net.labymod.user.cosmetic.remote.model.RemoteObject;
import net.labymod.user.cosmetic.util.CosmeticData;

public abstract class GeometryPet<T extends CosmeticData>
extends CosmeticPet<T> {
    private final RemoteObject data;
    private final IGeometryProviderCallback<T> callback;
    private BlockBenchLoader geometry;
    private AnimationLoader animation;

    public GeometryPet(RemoteObject data, IGeometryProviderCallback<T> callback) {
        this.init(data.id, data.type == EnumCosmeticType.FLYING_PET ? new FlyingAI(this) : new WalkingPet(this));
        this.moveType = data.moveType;
        this.data = data;
        this.callback = callback;
    }

    @Override
    public void addModels(ModelCosmetics baseModel, float modelSize) {
        try {
            this.geometry = new GeometryLoader(this.callback.getGeometryJson()).toBlockBenchLoader((bbo)baseModel);
            this.animation = new AnimationLoader(this.callback.getAnimationJson()).load();
        }
        catch (Exception e) {
            Debug.log(Debug.EnumDebugMode.REMOTE_COSMETIC, "Can't load " + this.data.name + ": " + e.getMessage());
        }
    }

    @Override
    public void setInvisible(boolean invisible) {
        if (this.geometry != null && this.geometry.getModel() != null) {
            this.geometry.getModel().showModel = invisible;
        }
    }

    @Override
    public void transform(String boneName, KeyframeVector rotation, KeyframeVector position, KeyframeVector scale) {
        GeometryModelRenderer model;
        GeometryModelRenderer geometryModelRenderer = model = this.geometry == null ? null : this.geometry.getModel(boneName);
        if (model != null) {
            Item item = this.geometry.getItem(boneName);
            double fixedRotationX = item.rotation == null ? 0.0 : item.rotation.get(0);
            double fixedRotationY = item.rotation == null ? 0.0 : item.rotation.get(1);
            double fixedRotationZ = item.rotation == null ? 0.0 : item.rotation.get(2);
            model.rotateAngleX = (float)Math.toRadians(rotation.x - fixedRotationX);
            model.rotateAngleY = (float)Math.toRadians(rotation.y - fixedRotationY);
            model.rotateAngleZ = (float)Math.toRadians(rotation.z + fixedRotationZ);
            model.offsetX = (float)(position.x / 16.0);
            model.offsetY = (float)(-position.y / 16.0);
            model.offsetZ = (float)(position.z / 16.0);
            model.scaleX = (float)scale.x;
            model.scaleY = (float)scale.y;
            model.scaleZ = (float)scale.z;
        }
    }

    @Override
    public void resetTransformation(String boneName) {
        GeometryModelRenderer model;
        GeometryModelRenderer geometryModelRenderer = model = this.geometry == null ? null : this.geometry.getModel(boneName);
        if (model != null) {
            Item item = this.geometry.getItem(boneName);
            model.rotateAngleX = item.rotation == null ? 0.0f : (float)Math.toRadians(-item.rotation.get(0).doubleValue());
            model.rotateAngleY = item.rotation == null ? 0.0f : (float)Math.toRadians(-item.rotation.get(1).doubleValue());
            model.rotateAngleZ = item.rotation == null ? 0.0f : (float)Math.toRadians(item.rotation.get(2));
            model.offsetX = 0.0f;
            model.offsetY = 0.0f;
            model.offsetZ = 0.0f;
            model.scaleX = 1.0f;
            model.scaleY = 1.0f;
            model.scaleZ = 1.0f;
        }
    }

    @Override
    public BlockBenchLoader getGeometry() {
        return this.geometry;
    }

    @Override
    public void renderModel(float renderScale) {
        bfl.E();
        bfl.p();
        if (this.geometry != null && this.geometry.getModel() != null) {
            this.geometry.getModel().render(renderScale);
        }
        bfl.F();
    }

    @Override
    protected jy getResourceLocation(bet player, T data) {
        return this.callback.getTexture((pk)player, data);
    }

    @Override
    public Animation handleTrigger(EnumTrigger trigger, AnimationController controller, float currentTick, pk entity, Object data) {
        Animation animation = super.handleTrigger(trigger, controller, currentTick, entity, data);
        if (animation != null) {
            PetStorage storage = (PetStorage)data;
            storage.attached = this.ai.canAttach() && (trigger == EnumTrigger.IDLE || trigger == EnumTrigger.SNEAK_IDLE);
        }
        return animation;
    }

    @Override
    public int getCosmeticId() {
        return this.data.id;
    }

    @Override
    public String getCosmeticName() {
        return this.data.name;
    }

    @Override
    public boolean isOfflineAvailable() {
        return false;
    }

    @Override
    public AnimationLoader getLoader() {
        return this.animation;
    }
}

