/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.user.cosmetic.cosmetics.shop.head;

import java.awt.Color;
import net.labymod.main.LabyMod;
import net.labymod.main.ModTextures;
import net.labymod.user.User;
import net.labymod.user.cosmetic.CosmeticRenderer;
import net.labymod.user.cosmetic.ModelCosmetics;
import net.labymod.user.cosmetic.util.CosmeticData;
import net.labymod.user.cosmetic.util.EnumLegacyCosmeticType;
import net.labymod.user.cosmetic.util.ModelRendererHook;

public class CosmeticEyelids
extends CosmeticRenderer<CosmeticEyelidsData> {
    public static final int ID = 36;
    private static final int BLINK_SPEED = 100;
    private static final int MAX_IDLE_DURATION = 240000;
    private static final double IDLE_CLOSE_SPEED = 5000.0;
    private bct model;

    @Override
    public void addModels(ModelCosmetics modelCosmetics, float modelSize) {
        this.model = new ModelRendererHook((bbo)modelCosmetics, 0, 0).b(4, 2);
        this.model.a(0, 0).a(0.0f, 0.0f, 0.0f, 1, 1, 1, modelSize);
    }

    @Override
    public void setInvisible(boolean invisible) {
        this.model.j = invisible;
    }

    @Override
    public void render(ModelCosmetics modelCosmetics, pk entityIn, CosmeticEyelidsData cosmeticData, float scale, float movementFactor, float walkingSpeed, float tickValue, float firstRotationX, float secondRotationX, float partialTicks) {
        boolean isIdle;
        bfl.E();
        bfl.b((float)firstRotationX, (float)0.0f, (float)1.0f, (float)0.0f);
        if (entityIn.av()) {
            double sneakRotate = (double)entityIn.z / 70000.0;
            sneakRotate = Math.max(0.0, sneakRotate);
            bfl.b((double)0.0, (double)0.062, (double)0.0);
            bfl.b((double)0.0, (double)sneakRotate, (double)(-sneakRotate));
        }
        bfl.b((float)secondRotationX, (float)1.0f, (float)0.0f, (float)0.0f);
        bfl.b((float)0.11f, (float)0.0f, (float)1.0f, (float)0.0f);
        bfl.b((float)(scale * -4.0f), (float)(scale * -8.0f), (float)(scale * -4.0f - 7.0E-4f));
        int x = cosmeticData.getX();
        int y = cosmeticData.getY();
        int width = cosmeticData.getWidth();
        int height = cosmeticData.getHeight();
        long timeLeftToBlink = cosmeticData.getBlinkTimeLeft();
        double timeFrame = cosmeticData.durationBlinkPause - timeLeftToBlink - 100L;
        double animation = Math.min(Math.abs(timeFrame), 100.0);
        double percentage = cosmeticData.isCanBlink() ? 1.0 - animation / 100.0 : 0.0;
        long idleDuration = cosmeticData.getIdleDuration(entityIn);
        boolean bl = isIdle = idleDuration > 240000L && cosmeticData.isCanSleep();
        if (isIdle) {
            percentage = 2.0E-4 * Math.min(5000.0, (double)(idleDuration - 240000L));
        }
        cosmeticData.lastRenderedPercetage = percentage;
        double smooth = -Math.cos(1.5707963267948966 + 1.5707963267948966 * percentage);
        double offset = 0.001;
        if (percentage != 0.0) {
            if (entityIn.z < -40.0f) {
                bfl.f();
            } else {
                bfl.e();
            }
            this.bindTextureAndColor(cosmeticData.getColor(), ModTextures.COSMETIC_EYELIDS, null);
            for (int i = 0; i < 2; ++i) {
                bfl.E();
                bfl.b((double)((double)((float)(i == 0 ? x : 8 - x - width) * scale) - offset), (double)((double)((float)y * scale) - offset), (double)-0.001f);
                bfl.a((double)((double)width + offset * 2.0 / (double)scale), (double)((double)height * smooth + offset * 2.0 / (double)scale), (double)0.02f);
                this.model.a(scale);
                bfl.F();
            }
            bfl.e();
        }
        bfl.F();
        bfl.E();
        if (isIdle) {
            bfl.E();
            bfl.b((float)(scale * 5.0f), (float)(scale * -4.0f), (float)(scale * -(entityIn.z / 15.0f + 4.0f)));
            ave.A().P().a(ModTextures.COSMETIC_EYELIDS_SLEEP);
            int totalAmount = 4;
            int speed = 1000;
            int renderedAmount = totalAmount - Math.min(totalAmount, (int)(idleDuration - 240000L) / speed);
            int startTimeOffset = (totalAmount - 1) * speed;
            for (int i = renderedAmount; i < totalAmount + 1; ++i) {
                int sleepTimeFrame = ((int)idleDuration + i * speed + startTimeOffset) % (totalAmount * speed);
                double percentZMoved = 1.0 / ((double)totalAmount * (double)speed) * (double)sleepTimeFrame;
                bfl.E();
                bfl.b((double)(percentZMoved / 2.0), (double)(-percentZMoved / 2.0), (double)0.0);
                this.rotateToPlayersCamera(entityIn, true, true);
                bfl.b((float)((float)(Math.cos(percentZMoved * 5.0) * 20.0 - 10.0) * (float)(i % 2 == 0 ? -1 : 1)), (float)0.0f, (float)0.0f, (float)1.0f);
                double scaleZ = (double)scale / 2.0 + percentZMoved / 8.0;
                float transparency = 1.0f - (float)Math.abs((percentZMoved - 0.5) * 2.0);
                LabyMod.getInstance().getDrawUtils().drawTexture(-scaleZ / 2.0, -scaleZ / 2.0, 0.0, 0.0, 256.0, 256.0, scaleZ, scaleZ, transparency);
                bfl.F();
            }
            bfl.F();
        }
        bfl.F();
    }

    @Override
    public int getCosmeticId() {
        return 36;
    }

    @Override
    public String getCosmeticName() {
        return "Eyelids";
    }

    @Override
    public boolean isOfflineAvailable() {
        return false;
    }

    public static class CosmeticEyelidsData
    extends CosmeticData {
        public double lastRenderedPercetage = 0.0;
        public long timestampNextBlink = System.currentTimeMillis();
        public long durationBlinkPause = 0L;
        private double lastPositionHash = 0.0;
        private long lastPositionChanged = 0L;
        private int x = 1;
        private int y = 4;
        private int width = 2;
        private int height = 1;
        private Color color = Color.WHITE;
        private boolean canBlink = true;
        private boolean canSleep = true;

        @Override
        public boolean isEnabled() {
            return true;
        }

        public long getBlinkTimeLeft() {
            long currentTime = System.currentTimeMillis();
            long timeLeftToBlink = this.timestampNextBlink - currentTime;
            if (timeLeftToBlink < 0L) {
                this.durationBlinkPause = 800 + LabyMod.getRandom().nextInt(8) * 1000;
                this.timestampNextBlink = currentTime + this.durationBlinkPause;
            }
            return timeLeftToBlink;
        }

        public long getIdleDuration(pk entity) {
            double hash = entity.s + entity.t + entity.u + (double)entity.y + (double)entity.z + (double)(entity.av() ? 1 : 0);
            if (entity instanceof bet) {
                hash += (double)((bet)entity).az;
            }
            if (this.lastPositionHash != hash) {
                this.lastPositionChanged = System.currentTimeMillis();
                this.lastPositionHash = hash;
            }
            return System.currentTimeMillis() - this.lastPositionChanged;
        }

        @Override
        public void loadData(String[] data) throws Exception {
            Exception exception = null;
            try {
                this.x = Integer.parseInt(data[0]);
                this.y = Integer.parseInt(data[1]);
                this.width = Integer.parseInt(data[2]);
                this.height = Integer.parseInt(data[3]);
                this.color = Color.decode("#" + data[4]);
                this.canBlink = Integer.parseInt(data[5]) == 1;
                this.canSleep = Integer.parseInt(data[6]) == 1;
            }
            catch (Exception e) {
                exception = e;
            }
            this.x = Math.min(this.x, 7);
            this.y = Math.min(this.y, 7);
            this.width = Math.min(this.width, 4);
            this.height = Math.min(this.height, 4);
            this.x = Math.max(this.x, 0);
            this.y = Math.max(this.y, 0);
            this.width = Math.max(this.width, 1);
            this.height = Math.max(this.height, 1);
            if (exception != null) {
                throw exception;
            }
        }

        @Override
        public void init(User user) {
        }

        @Override
        public EnumLegacyCosmeticType getType() {
            return EnumLegacyCosmeticType.FACE;
        }

        public double getLastRenderedPercetage() {
            return this.lastRenderedPercetage;
        }

        public long getTimestampNextBlink() {
            return this.timestampNextBlink;
        }

        public long getDurationBlinkPause() {
            return this.durationBlinkPause;
        }

        public double getLastPositionHash() {
            return this.lastPositionHash;
        }

        public long getLastPositionChanged() {
            return this.lastPositionChanged;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public Color getColor() {
            return this.color;
        }

        public boolean isCanBlink() {
            return this.canBlink;
        }

        public boolean isCanSleep() {
            return this.canSleep;
        }
    }
}

