/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.user.cosmetic.cosmetics.shop.head;

import java.awt.Color;
import java.util.UUID;
import net.labymod.main.LabyMod;
import net.labymod.user.User;
import net.labymod.user.cosmetic.CosmeticRenderer;
import net.labymod.user.cosmetic.ModelCosmetics;
import net.labymod.user.cosmetic.custom.UserTextureContainer;
import net.labymod.user.cosmetic.util.CosmeticData;
import net.labymod.user.cosmetic.util.EnumLegacyCosmeticType;
import net.labymod.user.cosmetic.util.ModelRendererHook;

public class CosmeticCap
extends CosmeticRenderer<CosmeticCapData> {
    public static final int ID = 19;
    private bct model;

    @Override
    public void addModels(ModelCosmetics modelCosmetics, float modelSize) {
        float capScale = modelSize;
        this.model = new ModelRendererHook((bbo)modelCosmetics, 0, 0).b(168, 180);
        this.model.f = (float)Math.toRadians(-90.0);
        this.model.a(0, 0).a(-4.0f, -4.0f, -6.0f, 8, 11, 1, capScale);
        this.model.a(18, 0).a(-4.0f, -4.0f, -8.0f, 8, 8, 2, capScale);
        this.model.a(38, 0).a(-4.0f, -3.0f, -9.001f, 8, 6, 1, capScale);
        this.model.a(38, 7).a(-3.0f, -4.0f, -9.001f, 6, 1, 1, capScale);
        this.model.a(38, 9).a(-3.0f, 3.0f, -9.001f, 6, 1, 1, capScale);
        this.model.a(56, 0).a(-3.0f, 7.0f, -6.0f, 6, 1, 1, capScale);
    }

    @Override
    public void setInvisible(boolean invisible) {
        this.model.j = invisible;
    }

    @Override
    public void render(ModelCosmetics modelCosmetics, pk entityIn, CosmeticCapData cosmeticData, float scale, float movementFactor, float walkingSpeed, float tickValue, float firstRotationX, float secondRotationX, float partialTicks) {
        jy texture = LabyMod.getInstance().getUserManager().getCosmeticImageManager().getCapImageHandler().getResourceLocation((bet)entityIn);
        if (texture == null) {
            return;
        }
        bfl.E();
        if (entityIn.av()) {
            bfl.b((float)0.0f, (float)(1.0f * scale), (float)0.0f);
        }
        bfl.b((float)((float)Math.toDegrees(modelCosmetics.e.g)), (float)0.0f, (float)1.0f, (float)0.0f);
        bfl.b((float)((float)Math.toDegrees(modelCosmetics.e.f)), (float)1.0f, (float)0.0f, (float)0.0f);
        ave.A().P().a(texture);
        float scaleUp = 1.1252f;
        bfl.a((float)scaleUp, (float)scaleUp, (float)scaleUp);
        if (cosmeticData.isSnapBack()) {
            bfl.b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        this.model.a(scale);
        float scaleWolf = 0.3f;
        float cutOff = 17.066668f;
        int color = cosmeticData.getLogoColor().getRGB();
        if (cosmeticData.isLogoRainbow()) {
            color = Color.HSBtoRGB((float)(System.currentTimeMillis() % 5000L) / 5000.0f, 0.8f, 0.8f);
        }
        this.bindTextureAndColor(color, texture, null);
        bfl.b((double)0.0, (double)-0.458, (double)-0.251);
        bfl.a((float)scaleWolf, (float)scaleWolf, (float)scaleWolf);
        LabyMod.getInstance().getDrawUtils().drawTexture(-0.2, -0.2, 0.0, cutOff, 256.0, 256.0f - cutOff, 0.4, 0.4);
        bfl.d();
        bfl.F();
    }

    @Override
    public int getCosmeticId() {
        return 19;
    }

    @Override
    public String getCosmeticName() {
        return "Cap";
    }

    @Override
    public boolean isOfflineAvailable() {
        return false;
    }

    public static class CosmeticCapData
    extends CosmeticData {
        private boolean snapBack = false;
        private UserTextureContainer userTextureContainer;
        private Color logoColor = Color.WHITE;
        private boolean logoRainbow = false;

        @Override
        public boolean isEnabled() {
            return true;
        }

        @Override
        public void loadData(String[] data) throws Exception {
            boolean bl = this.snapBack = Integer.parseInt(data[0]) == 1;
            if (data[1].equals("1")) {
                this.userTextureContainer.setFileName(UUID.fromString("7a9c8635-d64f-47ee-a373-5faceffc1915"));
                return;
            }
            this.userTextureContainer.setFileName(UUID.fromString(data[1]));
            this.logoColor = Color.decode("#" + data[2]);
            this.logoRainbow = Integer.parseInt(data[3]) == 1;
        }

        @Override
        public void init(User user) {
            this.userTextureContainer = user.getCapContainer();
        }

        @Override
        public EnumLegacyCosmeticType getType() {
            return EnumLegacyCosmeticType.HAT;
        }

        public boolean isSnapBack() {
            return this.snapBack;
        }

        public Color getLogoColor() {
            return this.logoColor;
        }

        public boolean isLogoRainbow() {
            return this.logoRainbow;
        }
    }
}

