/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.user.cosmetic.animation;

import net.labymod.core.LabyModCore;
import net.labymod.user.cosmetic.animation.MetaEffectFrameParameter;
import net.labymod.user.cosmetic.animation.model.KeyframeVector;
import net.labymod.user.cosmetic.geometry.BlockBenchLoader;
import net.labymod.user.cosmetic.geometry.effect.GeometryEffect;
import net.labymod.user.cosmetic.remote.objects.data.RemoteData;
import net.labymod.user.cosmetic.util.CosmeticData;

public interface IModelTransformer {
    public static final MetaEffectFrameParameter meta = new MetaEffectFrameParameter();

    public void transform(String var1, KeyframeVector var2, KeyframeVector var3, KeyframeVector var4);

    public BlockBenchLoader getGeometry();

    public void renderModel(float var1);

    public void resetTransformation(String var1);

    default public void applyEffects(pk entity, CosmeticData cosmeticData, float movementFactory, float walkingSpeed, float currentTick, float partialTicks, boolean rightHand) {
        BlockBenchLoader geometry = this.getGeometry();
        if (geometry == null || geometry.getEffects().isEmpty()) {
            return;
        }
        bet player = (bet)entity;
        double motionX = player.bq + (player.bt - player.bq) * (double)partialTicks - (player.p + (player.s - player.p) * (double)partialTicks);
        double motionY = player.br + (player.bu - player.br) * (double)partialTicks - (player.q + (player.t - player.q) * (double)partialTicks);
        double motionZ = player.bs + (player.bv - player.bs) * (double)partialTicks - (player.r + (player.u - player.r) * (double)partialTicks);
        float motionYaw = player.aJ + (player.aI - player.aJ) * partialTicks;
        double yawSin = LabyModCore.getMath().sin(motionYaw * (float)Math.PI / 180.0f);
        double yawCos = -LabyModCore.getMath().cos(motionYaw * (float)Math.PI / 180.0f);
        float cameraMotionYaw = player.bn + (player.bo - player.bn) * partialTicks;
        float fallStrength = (float)motionY * 10.0f;
        fallStrength = LabyModCore.getMath().clamp_float(fallStrength, -6.0f, 32.0f);
        float xRot = (float)(motionX * yawSin + motionZ * yawCos) * 100.0f;
        float zRot = (float)(motionX * yawCos - motionZ * yawSin) * 100.0f;
        float gravity = (float)motionY * 10.0f;
        gravity = LabyModCore.getMath().clamp_float(gravity, -6.0f, 32.0f);
        gravity += LabyModCore.getMath().sin((player.L + (player.M - player.L) * partialTicks) * 6.0f) * 32.0f * cameraMotionYaw;
        float forward = (float)(motionX * yawSin + motionZ * yawCos) * 100.0f;
        forward = LabyModCore.getMath().clamp_float(forward, 0.0f, 150.0f);
        float strafe = (float)(motionX * yawCos - motionZ * yawSin) * 100.0f;
        strafe = LabyModCore.getMath().clamp_float(strafe, -20.0f, 20.0f);
        float pitch = player.B + (player.z - player.B) * partialTicks;
        boolean isSlim = player.l().charAt(0) == 's';
        IModelTransformer.meta.forward = (float)Math.toRadians(forward / 2.0f);
        IModelTransformer.meta.gravity = (float)Math.toRadians(gravity);
        IModelTransformer.meta.strafe = (float)Math.toRadians(strafe / 2.0f);
        IModelTransformer.meta.renderYawOffset = player.aJ + (player.aI - player.aJ) * partialTicks;
        IModelTransformer.meta.pitch = pitch;
        IModelTransformer.meta.isSlim = isSlim;
        IModelTransformer.meta.rightSide = rightHand;
        for (GeometryEffect geometryEffect : geometry.getEffects()) {
            if (!(cosmeticData instanceof RemoteData)) continue;
            geometryEffect.apply((RemoteData)cosmeticData, meta);
        }
    }
}

