/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.support.util;

import java.awt.HeadlessException;
import java.io.File;
import net.labymod.main.Source;
import net.labymod.support.gui.GuiDebugConsole;
import net.labymod.utils.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Debug {
    public static final File DEBUG_FILE = new File(Source.FILE_LABYMOD_FOLDER, ".debug");
    private static boolean active = false;
    private static final Logger logger = LogManager.getLogger();
    private static GuiDebugConsole debugConsoleGui;

    public static void init() {
        if (DEBUG_FILE.exists()) {
            DEBUG_FILE.delete();
            Debug.openDebugConsole();
        } else {
            String debugMode = System.getProperty("debugMode");
            if (debugMode != null) {
                if (debugMode.equals("true")) {
                    active = true;
                    logger.info("[Debug] Started debug logging");
                } else if (debugMode.equals("GUI")) {
                    Debug.openDebugConsole();
                } else if (!debugMode.equals("false")) {
                    logger.info("[Debug] Invalid debug mode: " + debugMode);
                }
            }
        }
    }

    public static boolean isActive() {
        return active;
    }

    public static void openDebugConsole() {
        if (debugConsoleGui != null) {
            debugConsoleGui.toFront();
            return;
        }
        try {
            debugConsoleGui = new GuiDebugConsole(new Consumer<Boolean>(){

                @Override
                public void accept(Boolean accepted) {
                    debugConsoleGui = null;
                }
            });
        }
        catch (HeadlessException e) {
            e.printStackTrace();
        }
        active = true;
        logger.info("[Debug] Started debug GUI");
    }

    public static void log(EnumDebugMode debugMode, String message) {
        if (!active) {
            return;
        }
        logger.info("{}", new Object[]{"[Debug] [" + debugMode.name() + "] " + message});
    }

    public static GuiDebugConsole getDebugConsoleGui() {
        return debugConsoleGui;
    }

    public static enum EnumDebugMode {
        ADDON,
        API,
        UPDATER,
        COSMETIC_IMAGE_MANAGER,
        USER_MANAGER,
        MINECRAFT,
        TEAMSPEAK,
        LABYMOD_CHAT,
        LABYCONNECT_NEO,
        ACCOUNT_MANAGER,
        CONFIG_MANAGER,
        ASM,
        PLUGINMESSAGE,
        GENERAL,
        LANGUAGE,
        CCP,
        EMOTE,
        STICKER,
        DISCORD,
        LABY_PLAY,
        REQUEST,
        MICROSOFT,
        REMOTE_COSMETIC;

    }
}

