/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.settings.elements;

import java.io.IOException;
import net.labymod.api.LabyModAddon;
import net.labymod.core.LabyModCore;
import net.labymod.gui.elements.ModTextField;
import net.labymod.ingamegui.Module;
import net.labymod.main.LabyMod;
import net.labymod.main.ModSettings;
import net.labymod.main.ModTextures;
import net.labymod.main.lang.LanguageManager;
import net.labymod.settings.LabyModModuleEditorGui;
import net.labymod.settings.PreviewRenderer;
import net.labymod.settings.elements.ControlElement;
import net.labymod.utils.Consumer;
import net.labymod.utils.ModColor;

public class StringElement
extends ControlElement {
    private String currentValue;
    private Consumer<String> changeListener;
    private ModTextField textField;
    private Consumer<String> callback;
    private boolean hoverExpandButton = false;

    public StringElement(String displayName, final String configEntryName, ControlElement.IconData iconData) {
        super(displayName, configEntryName, iconData);
        if (!configEntryName.isEmpty()) {
            try {
                this.currentValue = (String)ModSettings.class.getDeclaredField(configEntryName).get(LabyMod.getSettings());
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (this.currentValue == null) {
            this.currentValue = "";
        }
        this.changeListener = new Consumer<String>(){

            @Override
            public void accept(String accepted) {
                try {
                    ModSettings.class.getDeclaredField(configEntryName).set(LabyMod.getSettings(), accepted);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (StringElement.this.callback != null) {
                    StringElement.this.callback.accept(accepted);
                }
            }
        };
        this.createTextfield();
    }

    public StringElement(final Module module, ControlElement.IconData iconData, String displayName, final String attribute) {
        super(module, iconData, displayName);
        this.currentValue = module.getAttributes().get(attribute);
        if (this.currentValue == null) {
            this.currentValue = "";
        }
        this.changeListener = new Consumer<String>(){

            @Override
            public void accept(String accepted) {
                module.getAttributes().put(attribute, accepted);
                module.loadSettings();
                if (StringElement.this.callback != null) {
                    StringElement.this.callback.accept(accepted);
                }
            }
        };
        this.createTextfield();
    }

    public StringElement(String displayName, final LabyModAddon addon, ControlElement.IconData iconData, final String attribute, String currentValue) {
        super(displayName, iconData);
        if (currentValue == null) {
            currentValue = "";
        }
        this.currentValue = currentValue;
        this.changeListener = new Consumer<String>(){

            @Override
            public void accept(String accepted) {
                addon.getConfig().addProperty(attribute, accepted);
                addon.loadConfig();
                if (StringElement.this.callback != null) {
                    StringElement.this.callback.accept(accepted);
                }
            }
        };
        this.createTextfield();
    }

    public StringElement(String displayName, ControlElement.IconData iconData, String currentValue, Consumer<String> changeListener) {
        super(displayName, iconData);
        this.currentValue = currentValue;
        this.changeListener = changeListener;
        this.createTextfield();
    }

    public StringElement(String configEntryName, ControlElement.IconData iconData) {
        this(configEntryName, configEntryName, iconData);
    }

    public void createTextfield() {
        this.textField = new ModTextField(-2, LabyModCore.getMinecraft().getFontRenderer(), 0, 0, this.getObjectWidth() - 5, 20);
        this.textField.setMaxStringLength(500);
        this.updateValue();
        this.textField.setCursorPositionEnd();
        this.textField.setFocused(false);
    }

    private void updateValue() {
        this.textField.setText(this.currentValue == null ? "" : this.currentValue);
    }

    @Override
    public void draw(int x, int y, int maxX, int maxY, int mouseX, int mouseY) {
        super.draw(x, y, maxX, maxY, mouseX, mouseY);
        int width = this.getObjectWidth() - 5;
        if (this.textField == null) {
            return;
        }
        this.textField.xPosition = maxX - width - 2;
        this.textField.yPosition = y + 1;
        this.textField.drawTextBox();
        LabyMod.getInstance().getDrawUtils().drawRectangle(x - 1, y, x, maxY, ModColor.toRGB(120, 120, 120, 120));
        bfl.c((float)1.0f, (float)1.0f, (float)1.0f);
        ave.A().P().a(ModTextures.BUTTON_EXPAND);
        this.hoverExpandButton = mouseX > maxX - this.getObjectWidth() - 12 && mouseX < maxX - this.getObjectWidth() - 7 + 8 && mouseY > y + 1 && mouseY < y + 1 + 8;
        LabyMod.getInstance().getDrawUtils().drawTexture(maxX - this.getObjectWidth() - 7, y + 1, 0.0, this.hoverExpandButton ? 130.0 : 0.0, 256.0, 128.0, 8.0, 8.0);
    }

    @Override
    public void unfocus(int mouseX, int mouseY, int mouseButton) {
        super.unfocus(mouseX, mouseY, mouseButton);
        if (this.hoverExpandButton) {
            this.hoverExpandButton = false;
            ave.A().a((axu)new ExpandedStringElementGui(this.textField, ave.A().m, new Consumer<ModTextField>(){

                @Override
                public void accept(ModTextField accepted) {
                    StringElement.this.textField.setText(accepted.getText());
                    StringElement.this.textField.setFocused(true);
                    StringElement.this.textField.setCursorPosition(accepted.getCursorPosition());
                    StringElement.this.textField.setSelectionPos(accepted.getSelectionEnd());
                    StringElement.this.changeListener.accept(StringElement.this.textField.getText());
                }
            }));
        }
        this.textField.setFocused(false);
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        super.mouseClicked(mouseX, mouseY, mouseButton);
        this.textField.mouseClicked(mouseX, mouseY, 0);
    }

    @Override
    public void keyTyped(char typedChar, int keyCode) {
        if (this.textField.textboxKeyTyped(typedChar, keyCode)) {
            this.changeListener.accept(this.textField.getText());
        }
    }

    @Override
    public void updateScreen() {
        super.updateScreen();
        this.textField.updateCursorCounter();
    }

    public StringElement maxLength(int maxLength) {
        this.textField.setMaxStringLength(maxLength);
        return this;
    }

    public StringElement addCallback(Consumer<String> callback) {
        this.callback = callback;
        return this;
    }

    @Override
    public int getObjectWidth() {
        return 85;
    }

    public class ExpandedStringElementGui
    extends axu {
        private axu backgroundScreen;
        private Consumer<ModTextField> callback;
        private ModTextField preField;
        private ModTextField expandedField;

        public ExpandedStringElementGui(ModTextField preField, axu backgroundScreen, Consumer<ModTextField> callback) {
            this.backgroundScreen = backgroundScreen;
            this.callback = callback;
            this.preField = preField;
        }

        public void b() {
            super.b();
            this.backgroundScreen.l = this.l;
            this.backgroundScreen.m = this.m;
            if (this.backgroundScreen instanceof LabyModModuleEditorGui) {
                PreviewRenderer.getInstance().init(ExpandedStringElementGui.class);
            }
            this.expandedField = new ModTextField(0, LabyModCore.getMinecraft().getFontRenderer(), this.l / 2 - 150, this.m / 4 + 45, 300, 20);
            this.expandedField.setMaxStringLength(this.preField.getMaxStringLength());
            this.expandedField.setFocused(true);
            this.expandedField.setText(this.preField.getText());
            this.expandedField.setCursorPosition(this.preField.getCursorPosition());
            this.expandedField.setSelectionPos(this.preField.getSelectionEnd());
            this.n.add(new avs(1, this.l / 2 - 50, this.m / 4 + 85, 100, 20, LanguageManager.translate("button_done")));
        }

        public void a(int mouseX, int mouseY, float partialTicks) {
            this.backgroundScreen.a(mouseX, mouseY, partialTicks);
            ExpandedStringElementGui.a((int)0, (int)0, (int)this.l, (int)this.m, (int)Integer.MIN_VALUE);
            ExpandedStringElementGui.a((int)(this.l / 2 - 165), (int)(this.m / 4 + 35), (int)(this.l / 2 + 165), (int)(this.m / 4 + 120), (int)Integer.MIN_VALUE);
            this.expandedField.drawTextBox();
            super.a(mouseX, mouseY, partialTicks);
        }

        protected void a(int mouseX, int mouseY, int mouseButton) throws IOException {
            super.a(mouseX, mouseY, mouseButton);
            this.expandedField.mouseClicked(mouseX, mouseY, mouseButton);
            this.callback.accept(this.expandedField);
        }

        protected void a(char typedChar, int keyCode) throws IOException {
            if (keyCode == 1) {
                ave.A().a(this.backgroundScreen);
            }
            if (this.expandedField.textboxKeyTyped(typedChar, keyCode)) {
                this.callback.accept(this.expandedField);
            }
        }

        public void e() {
            this.backgroundScreen.e();
            this.expandedField.updateCursorCounter();
        }

        protected void a(avs button) throws IOException {
            super.a(button);
            if (button.k == 1) {
                ave.A().a(this.backgroundScreen);
            }
        }

        public axu getBackgroundScreen() {
            return this.backgroundScreen;
        }
    }
}

