/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.settings.elements;

import net.labymod.api.LabyModAddon;
import net.labymod.ingamegui.Module;
import net.labymod.main.LabyMod;
import net.labymod.main.ModSettings;
import net.labymod.settings.elements.ControlElement;
import net.labymod.utils.Consumer;
import net.labymod.utils.DrawUtils;
import net.labymod.utils.ModColor;

public class SliderElement
extends ControlElement {
    public static final jy buttonTextures = new jy("textures/gui/widgets.png");
    private Integer currentValue;
    private Consumer<Integer> changeListener;
    private Consumer<Integer> callback;
    private int minValue = 0;
    private int maxValue = 10;
    private boolean dragging;
    private boolean hover;
    private int dragValue;
    private int steps = 1;

    public SliderElement(String displayName, final String configEntryName, ControlElement.IconData iconData) {
        super(displayName, configEntryName, iconData);
        if (!configEntryName.isEmpty()) {
            try {
                this.currentValue = (Integer)ModSettings.class.getDeclaredField(configEntryName).get(LabyMod.getSettings());
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (this.currentValue == null) {
            this.currentValue = this.minValue;
        }
        this.changeListener = new Consumer<Integer>(){

            @Override
            public void accept(Integer accepted) {
                try {
                    ModSettings.class.getDeclaredField(configEntryName).set(LabyMod.getSettings(), accepted);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (SliderElement.this.callback != null) {
                    SliderElement.this.callback.accept(accepted);
                }
            }
        };
    }

    public SliderElement(String displayName, ControlElement.IconData iconData, int currentValue) {
        super(displayName, null, iconData);
        this.currentValue = currentValue;
        this.changeListener = new Consumer<Integer>(){

            @Override
            public void accept(Integer accepted) {
                if (SliderElement.this.callback != null) {
                    SliderElement.this.callback.accept(accepted);
                }
            }
        };
    }

    public SliderElement(String displayName, final LabyModAddon addon, ControlElement.IconData iconData, final String attribute, int currentValue) {
        super(displayName, iconData);
        this.currentValue = currentValue;
        this.changeListener = new Consumer<Integer>(){

            @Override
            public void accept(Integer accepted) {
                addon.getConfig().addProperty(attribute, (Number)accepted);
                addon.loadConfig();
                if (SliderElement.this.callback != null) {
                    SliderElement.this.callback.accept(accepted);
                }
            }
        };
    }

    public SliderElement(final Module module, ControlElement.IconData iconData, String displayName, final String attribute) {
        super(module, iconData, displayName);
        try {
            String attr = module.getAttributes().get(attribute);
            this.currentValue = attr == null ? this.minValue : Integer.valueOf(attr);
        }
        catch (Exception error) {
            error.printStackTrace();
        }
        if (this.currentValue == null) {
            this.currentValue = this.minValue;
        }
        this.changeListener = new Consumer<Integer>(){

            @Override
            public void accept(Integer accepted) {
                module.getAttributes().put(attribute, String.valueOf(accepted));
                module.loadSettings();
                if (SliderElement.this.callback != null) {
                    SliderElement.this.callback.accept(accepted);
                }
            }
        };
    }

    public SliderElement(String configEntryName, ControlElement.IconData iconData) {
        this(configEntryName, configEntryName, iconData);
    }

    public SliderElement setMinValue(int minValue) {
        this.minValue = minValue;
        if (this.currentValue < this.minValue) {
            this.currentValue = this.minValue;
        }
        return this;
    }

    public SliderElement setMaxValue(int maxValue) {
        this.maxValue = maxValue;
        if (this.currentValue > this.maxValue) {
            this.currentValue = this.maxValue;
        }
        return this;
    }

    public SliderElement setRange(int min, int max) {
        this.setMinValue(min);
        this.setMaxValue(max);
        return this;
    }

    public SliderElement setSteps(int steps) {
        this.steps = steps;
        return this;
    }

    @Override
    public void draw(int x, int y, int maxX, int maxY, int mouseX, int mouseY) {
        super.draw(x, y, maxX, maxY, mouseX, mouseY);
        DrawUtils draw = LabyMod.getInstance().getDrawUtils();
        int width = this.getObjectWidth();
        if (this.displayName != null) {
            draw.drawRectangle(x - 1, y, x, maxY, ModColor.toRGB(120, 120, 120, 120));
        }
        ave.A().P().a(buttonTextures);
        bfl.c((float)1.0f, (float)1.0f, (float)1.0f);
        double maxSliderPos = maxX;
        double sliderWidth = width - 8;
        double sliderWidthBackground = width;
        double minSliderPos = maxSliderPos - (double)width;
        double totalValueDiff = this.maxValue - this.minValue;
        double currentValue = this.currentValue.intValue();
        double pos = minSliderPos + sliderWidth / totalValueDiff * (currentValue - (double)this.minValue);
        draw.drawTexturedModalRect(minSliderPos, y + 1, 0.0, 46.0, sliderWidthBackground / 2.0, 20.0);
        draw.drawTexturedModalRect(minSliderPos + sliderWidthBackground / 2.0, y + 1, 200.0 - sliderWidthBackground / 2.0, 46.0, sliderWidthBackground / 2.0, 20.0);
        this.hover = mouseX > x && mouseX < maxX && mouseY > y + 1 && mouseY < maxY;
        draw.drawTexturedModalRect(pos, y + 1, 0.0, 66.0, 4.0, 20.0);
        draw.drawTexturedModalRect(pos + 4.0, y + 1, 196.0, 66.0, 4.0, 20.0);
        if (!this.isMouseOver()) {
            this.mouseRelease(mouseX, mouseY, 0);
        } else {
            double mouseToMinSlider = (double)mouseX - minSliderPos;
            double finalValue = (double)this.minValue + totalValueDiff / sliderWidth * (mouseToMinSlider - 1.0);
            if (this.dragging) {
                this.dragValue = (int)finalValue;
                this.mouseClickMove(mouseX, mouseY, 0);
            }
        }
        draw.drawCenteredString("" + this.currentValue, minSliderPos + sliderWidthBackground / 2.0, y + 7);
    }

    @Override
    public void unfocus(int mouseX, int mouseY, int mouseButton) {
        super.unfocus(mouseX, mouseY, mouseButton);
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        super.mouseClicked(mouseX, mouseY, mouseButton);
        if (this.hover) {
            this.dragging = true;
        }
    }

    @Override
    public void mouseRelease(int mouseX, int mouseY, int mouseButton) {
        super.mouseRelease(mouseX, mouseY, mouseButton);
        if (this.dragging) {
            this.dragging = false;
            this.currentValue = (int)((double)this.dragValue / (double)this.steps) * this.steps;
            if (this.currentValue > this.maxValue) {
                this.currentValue = this.maxValue;
            }
            if (this.currentValue < this.minValue) {
                this.currentValue = this.minValue;
            }
            this.changeListener.accept(this.currentValue);
        }
    }

    @Override
    public void mouseClickMove(int mouseX, int mouseY, int mouseButton) {
        super.mouseClickMove(mouseX, mouseY, mouseButton);
        if (this.dragging) {
            this.currentValue = (int)Math.round((double)this.dragValue / (double)this.steps * (double)this.steps);
            if (this.currentValue > this.maxValue) {
                this.currentValue = this.maxValue;
            }
            if (this.currentValue < this.minValue) {
                this.currentValue = this.minValue;
            }
            this.changeListener.accept(this.currentValue);
        }
    }

    public SliderElement addCallback(Consumer<Integer> callback) {
        this.callback = callback;
        return this;
    }

    @Override
    public int getObjectWidth() {
        return 50;
    }

    public void setCurrentValue(Integer currentValue) {
        this.currentValue = currentValue;
    }
}

