/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.settings.elements;

import java.util.ArrayList;
import java.util.List;
import net.labymod.api.permissions.Permissions;
import net.labymod.ingamegui.Module;
import net.labymod.main.Source;
import net.labymod.main.lang.LanguageManager;
import net.labymod.settings.Settings;

public abstract class SettingsElement {
    public static final jy buttonTextures = new jy("textures/gui/widgets.png");
    public static final jy BUTTON_PRESS_SOUND = new jy(Source.ABOUT_MC_VERSION.startsWith("1.8") ? "gui.button.press" : "ui.button.click");
    protected ave mc = ave.A();
    protected Settings subSettings = new Settings();
    protected String displayName;
    private String descriptionText;
    protected boolean mouseOver;
    private int sortingId = 0;
    private boolean visible = true;
    private Module moduleCopyVisible = null;
    private String configEntryName;
    protected List<Permissions.Permission> permissions = new ArrayList<Permissions.Permission>();

    public SettingsElement(String displayName, String description, String configEntryName) {
        this.displayName = displayName;
        this.descriptionText = description;
        this.configEntryName = configEntryName;
        this.preInit();
    }

    public SettingsElement(String displayName, String configEntryName) {
        this.displayName = displayName;
        this.configEntryName = configEntryName;
        this.initTranslation(configEntryName);
        this.preInit();
    }

    protected SettingsElement initTranslation(String key) {
        String titleKey;
        String displayName;
        if (key == null) {
            return this;
        }
        String descriptionKey = "description_" + key.toLowerCase();
        this.descriptionText = LanguageManager.translate(descriptionKey);
        if (this.descriptionText.equals(descriptionKey)) {
            this.descriptionText = null;
        }
        if (!(displayName = LanguageManager.translate(titleKey = "setting_" + key.toLowerCase())).equals(titleKey)) {
            this.displayName = displayName;
        }
        return this;
    }

    public SettingsElement bindPermission(Permissions.Permission ... permissions) {
        for (Permissions.Permission permission : permissions) {
            this.permissions.add(permission);
        }
        return this;
    }

    public SettingsElement bindDescription(String customDescription) {
        this.descriptionText = customDescription;
        return this;
    }

    public void draw(int x, int y, int maxX, int maxY, int mouseX, int mouseY) {
        this.mouseOver = mouseX > x && mouseX < maxX && mouseY > y && mouseY < maxY;
    }

    public abstract void drawDescription(int var1, int var2, int var3);

    public abstract void mouseClicked(int var1, int var2, int var3);

    public abstract void mouseRelease(int var1, int var2, int var3);

    public abstract void mouseClickMove(int var1, int var2, int var3);

    public abstract void keyTyped(char var1, int var2);

    public abstract void unfocus(int var1, int var2, int var3);

    public abstract int getEntryHeight();

    public void preInit() {
    }

    public void init() {
    }

    public void updateScreen() {
    }

    public boolean isVisible() {
        return this.moduleCopyVisible == null ? this.visible : this.moduleCopyVisible.getModuleConfigElement().isUsingExtendedSettings();
    }

    public ave getMc() {
        return this.mc;
    }

    public Settings getSubSettings() {
        return this.subSettings;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescriptionText() {
        return this.descriptionText;
    }

    public boolean isMouseOver() {
        return this.mouseOver;
    }

    public int getSortingId() {
        return this.sortingId;
    }

    public Module getModuleCopyVisible() {
        return this.moduleCopyVisible;
    }

    public String getConfigEntryName() {
        return this.configEntryName;
    }

    public List<Permissions.Permission> getPermissions() {
        return this.permissions;
    }

    public void setMc(ave mc) {
        this.mc = mc;
    }

    public void setSubSettings(Settings subSettings) {
        this.subSettings = subSettings;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setDescriptionText(String descriptionText) {
        this.descriptionText = descriptionText;
    }

    public void setMouseOver(boolean mouseOver) {
        this.mouseOver = mouseOver;
    }

    public void setSortingId(int sortingId) {
        this.sortingId = sortingId;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public void setModuleCopyVisible(Module moduleCopyVisible) {
        this.moduleCopyVisible = moduleCopyVisible;
    }

    public void setConfigEntryName(String configEntryName) {
        this.configEntryName = configEntryName;
    }

    public void setPermissions(List<Permissions.Permission> permissions) {
        this.permissions = permissions;
    }
}

