/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.settings.elements;

import java.util.List;
import net.labymod.api.permissions.Permissions;
import net.labymod.core.LabyModCore;
import net.labymod.ingamegui.Module;
import net.labymod.main.LabyMod;
import net.labymod.main.ModTextures;
import net.labymod.main.lang.LanguageManager;
import net.labymod.settings.LabyModModuleEditorGui;
import net.labymod.settings.elements.SettingsElement;
import net.labymod.utils.Consumer;
import net.labymod.utils.DrawUtils;
import net.labymod.utils.Material;
import net.labymod.utils.ModColor;
import net.labymod.utils.manager.TooltipHelper;

public class ControlElement
extends SettingsElement {
    protected IconData iconData;
    private avs buttonAdvanced;
    private Module module;
    private boolean selected;
    private boolean hoverable;
    private boolean hideSubList;
    private boolean settingEnabled;
    private int lastMaxX;
    private Consumer<Boolean> advancedButtonCallback;
    private boolean blocked = false;

    public ControlElement(String elementName, String configEntryName, IconData iconData) {
        super(elementName, configEntryName);
        this.iconData = iconData;
        if (this.iconData != null && this.iconData.isUseConfigName()) {
            this.iconData.apply(configEntryName == null ? elementName : configEntryName);
        }
        this.createButton();
    }

    public ControlElement(Module module, IconData iconData, String displayName) {
        super(displayName, null);
        this.iconData = iconData;
        this.module = module;
        this.createButton();
    }

    public ControlElement(String displayName, IconData iconData) {
        super(displayName, null);
        this.iconData = iconData;
        this.createButton();
    }

    private void createButton() {
        this.buttonAdvanced = new avs(-2, 0, 0, 23, 20, "");
    }

    public avs getButtonAdvanced() {
        return this.buttonAdvanced;
    }

    public void setAdvancedButtonCallback(Consumer<Boolean> callback) {
        this.advancedButtonCallback = callback;
    }

    @Override
    public void draw(int x, int y, int maxX, int maxY, int mouseX, int mouseY) {
        super.draw(x, y, maxX, maxY, mouseX, mouseY);
        this.lastMaxX = maxX;
        if (this.displayName != null) {
            int iconWidth;
            LabyMod.getInstance().getDrawUtils().drawRectangle(x, y, maxX, maxY, ModColor.toRGB(80, 80, 80, this.selected ? 130 : (this.hoverable && this.mouseOver ? 80 : 60)));
            int n = iconWidth = this.iconData != null ? 25 : 2;
            if (this.iconData != null) {
                if (this.iconData.hasTextureIcon()) {
                    ave.A().P().a(this.iconData.getTextureIcon());
                    LabyMod.getInstance().getDrawUtils().drawTexture(x + 3, y + 3, 256.0, 256.0, 16.0, 16.0);
                } else if (this.iconData.hasMaterialIcon()) {
                    LabyMod.getInstance().getDrawUtils().drawItem(this.iconData.getMaterialIcon().createItemStack(), x + 3, y + 2, null);
                }
            }
            List<String> list = LabyMod.getInstance().getDrawUtils().listFormattedStringToWidth(this.getDisplayName().isEmpty() ? ModColor.cl("4") + "Unknown" : this.getDisplayName(), maxX - (x + iconWidth) - this.getObjectWidth() - 5 - (this.hasSubList() ? iconWidth : 0));
            int listY = y + 7 - ((list.size() > 2 ? 2 : list.size()) - 1) * 5;
            int i = 0;
            for (String line : list) {
                LabyMod.getInstance().getDrawUtils().drawString(line, x + iconWidth, listY);
                listY += 10;
                if (++i <= 1) continue;
                break;
            }
            this.renderAdvancedButton(x, y, maxX - this.getObjectWidth(), maxY, this.mouseOver, mouseX, mouseY);
            this.hideSubList = false;
            boolean blocked = this.blocked;
            if (!this.permissions.isEmpty()) {
                boolean defaultDisabled = false;
                boolean isEnabledByServer = true;
                String allowedPermissions = "";
                for (Permissions.Permission permission : this.permissions) {
                    if (!permission.isDefaultEnabled()) {
                        defaultDisabled = true;
                    }
                    if (!allowedPermissions.isEmpty()) {
                        allowedPermissions = allowedPermissions + ModColor.cl("7") + ", ";
                    }
                    allowedPermissions = allowedPermissions + ModColor.cl("e") + permission.getDisplayName();
                    if (Permissions.isAllowed(permission)) continue;
                    isEnabledByServer = false;
                }
                if (defaultDisabled || !isEnabledByServer) {
                    boolean hover = mouseX > x - 13 && mouseX < x - 13 + 7 && mouseY > y + 3 && mouseY < y + 3 + 16;
                    DrawUtils draw = LabyMod.getInstance().getDrawUtils();
                    if (isEnabledByServer) {
                        ave.A().P().a(ModTextures.BUTTON_CHECKBOX);
                        draw.drawTexture(x - 13, y + 7, 0.0, 0.0, 255.0, 255.0, 10.0, 10.0);
                    } else {
                        ave.A().P().a(ModTextures.BUTTON_EXCLAMATION);
                        draw.drawTexture(x - 13, y + 3, hover ? 127.0 : 0.0, 0.0, 127.0, 255.0, 7.0, 16.0);
                        if (!ave.A().F() && LabyMod.getInstance().isInGame()) {
                            blocked = true;
                        }
                    }
                    if (hover) {
                        String text = LanguageManager.translate("permission_information_" + (isEnabledByServer ? "enabled" : "disabled")) + (isEnabledByServer ? "" : allowedPermissions);
                        TooltipHelper.getHelper().pointTooltip(mouseX, mouseY, 0L, (String[])draw.listFormattedStringToWidth(text, draw.getWidth() / 3).toArray());
                    }
                }
            }
            if (blocked) {
                LabyMod.getInstance().getDrawUtils().drawRectangle(x, y, maxX, maxY, ModColor.toRGB(0, 0, 0, 200));
                LabyMod.getInstance().getDrawUtils().drawString((Object)((Object)ModColor.RED) + "\u2716 " + LabyMod.getMessage("not_allowed_here", new Object[0]) + " \u2716", x + 5, y + (maxY - y) / 2 - 4);
            }
        }
    }

    private void renderAdvancedButton(int x, int y, int maxX, int maxY, boolean mouseOver, int mouseX, int mouseY) {
        if (!this.hasSubList()) {
            return;
        }
        if (this.buttonAdvanced == null) {
            return;
        }
        if (this.hideSubList) {
            return;
        }
        boolean enabled = this.isModule() ? this.module.isEnabled(LabyModModuleEditorGui.getSelectedTab()) : this.settingEnabled;
        LabyModCore.getMinecraft().setButtonXPosition(this.buttonAdvanced, maxX - this.getSubListButtonWidth() - 2);
        LabyModCore.getMinecraft().setButtonYPosition(this.buttonAdvanced, y + 1);
        this.buttonAdvanced.l = enabled;
        LabyModCore.getMinecraft().drawButton(this.buttonAdvanced, mouseX, mouseY);
        this.mc.P().a(ModTextures.BUTTON_ADVANCED);
        bfl.l();
        bfl.c((float)1.0f, (float)1.0f, (float)1.0f, (float)(enabled ? 1.0f : 0.2f));
        LabyMod.getInstance().getDrawUtils().drawTexture(LabyModCore.getMinecraft().getXPosition(this.buttonAdvanced) + 4, LabyModCore.getMinecraft().getYPosition(this.buttonAdvanced) + 3, 0.0, 0.0, 256.0, 256.0, 14.0, 14.0, 2.0f);
    }

    public int getObjectWidth() {
        return this.isModule() ? 37 : 50;
    }

    public int getSubListButtonWidth() {
        return this.hasSubList() ? 23 : 0;
    }

    @Override
    public void drawDescription(int x, int y, int screenWidth) {
        String description = this.getDescriptionText();
        if (description == null) {
            return;
        }
        if (this.buttonAdvanced != null && this.buttonAdvanced.a()) {
            return;
        }
        if (x > this.lastMaxX - this.getObjectWidth() - 2) {
            return;
        }
        DrawUtils draw = LabyMod.getInstance().getDrawUtils();
        List<String> list = draw.listFormattedStringToWidth(description, screenWidth / 3);
        TooltipHelper.getHelper().pointTooltip(x, y, 500L, (String[])list.toArray());
    }

    @Override
    public void keyTyped(char typedChar, int keyCode) {
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
    }

    @Override
    public int getEntryHeight() {
        return 23;
    }

    public boolean isModule() {
        return this.module != null;
    }

    public Module getModule() {
        return this.module;
    }

    public boolean hasSubList() {
        return this.advancedButtonCallback != null || !this.subSettings.getElements().isEmpty() && !this.hideSubList;
    }

    public ControlElement setSelected(boolean selected) {
        this.selected = selected;
        return this;
    }

    public ControlElement setHoverable(boolean hoverable) {
        this.hoverable = hoverable;
        return this;
    }

    public ControlElement hideSubListButton() {
        this.hideSubList = true;
        return this;
    }

    @Override
    public void mouseRelease(int mouseX, int mouseY, int mouseButton) {
    }

    @Override
    public void mouseClickMove(int mouseX, int mouseY, int mouseButton) {
    }

    @Override
    public void unfocus(int mouseX, int mouseY, int mouseButton) {
    }

    public IconData getIconData() {
        return this.iconData;
    }

    public void setSettingEnabled(boolean settingEnabled) {
        this.settingEnabled = settingEnabled;
    }

    public Consumer<Boolean> getAdvancedButtonCallback() {
        return this.advancedButtonCallback;
    }

    public void setBlocked(boolean blocked) {
        this.blocked = blocked;
    }

    public boolean isBlocked() {
        return this.blocked;
    }

    public static class IconData {
        private boolean useConfigName = false;
        private Material materialIcon;
        private jy textureIcon;

        public IconData(Material materialIcon) {
            this.materialIcon = materialIcon;
        }

        public IconData(jy textureIcon) {
            this.textureIcon = textureIcon;
        }

        public IconData(String resourceLocationPath) {
            this.textureIcon = new jy(resourceLocationPath);
        }

        public IconData() {
            this.useConfigName = true;
        }

        public Material getMaterialIcon() {
            return this.materialIcon;
        }

        public jy getTextureIcon() {
            return this.textureIcon;
        }

        public boolean hasTextureIcon() {
            return this.textureIcon != null;
        }

        public boolean hasMaterialIcon() {
            return this.materialIcon != null;
        }

        public boolean isUseConfigName() {
            return this.useConfigName;
        }

        public void apply(String configEntryName) {
            this.textureIcon = new jy("labymod/textures/settings/settings/" + configEntryName.toLowerCase() + ".png");
        }
    }
}

