/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.settings;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.labymod.core.LabyModCore;
import net.labymod.gui.elements.ModTextField;
import net.labymod.gui.elements.Scrollbar;
import net.labymod.gui.elements.Tabs;
import net.labymod.main.DefinedSettings;
import net.labymod.main.LabyMod;
import net.labymod.main.ModTextures;
import net.labymod.main.lang.LanguageManager;
import net.labymod.main.update.Updater;
import net.labymod.settings.LabyModAddonsGui;
import net.labymod.settings.LabyModModuleEditorGui;
import net.labymod.settings.SettingsCategory;
import net.labymod.settings.elements.ColorPickerCheckBoxBulkElement;
import net.labymod.settings.elements.ControlElement;
import net.labymod.settings.elements.DropDownElement;
import net.labymod.settings.elements.HeaderElement;
import net.labymod.settings.elements.KeyElement;
import net.labymod.settings.elements.SettingsElement;
import net.labymod.utils.Consumer;
import net.labymod.utils.DrawUtils;
import net.labymod.utils.manager.TooltipHelper;
import org.lwjgl.input.Keyboard;

public class LabyModSettingsGui
extends axu {
    private Scrollbar scrollbar = new Scrollbar(1);
    private ModTextField searchField;
    private axu lastScreen;
    private SettingsElement mouseOverElement;
    private List<SettingsElement> listedElementsStored = new ArrayList<SettingsElement>();
    private List<SettingsElement> tempElementsStored = new ArrayList<SettingsElement>();
    private ArrayList<SettingsElement> path = new ArrayList();
    private avs buttonGoBack;
    private double preScrollPos = 0.0;
    private boolean hoverUpdateButton;
    private boolean closed = false;
    private boolean skipDrawDescription = false;
    private boolean hoverIconButtonAddons;
    private boolean hoverIconButtonGUI;

    public LabyModSettingsGui() {
        this(null);
    }

    public LabyModSettingsGui(axu lastScreen) {
        this.lastScreen = lastScreen;
    }

    public void b() {
        super.b();
        this.doQuery(null);
        this.n.clear();
        this.searchField = new ModTextField(0, LabyModCore.getMinecraft().getFontRenderer(), this.l / 2 - 150, 35, 300, 16);
        this.searchField.setPlaceHolder(LanguageManager.translate("search_textbox_placeholder"));
        this.searchField.setBlackBox(false);
        this.scrollbar.setPosition(this.l / 2 + 152, 60, this.l / 2 + 152 + 4, this.m - 30);
        this.scrollbar.setSpeed(20);
        this.scrollbar.update(this.listedElementsStored.size());
        this.scrollbar.init();
        if (this.lastScreen != null) {
            this.n.add(new avs(5, this.l / 2 - 100, this.m - 22, LanguageManager.translate("button_done")));
        }
        this.buttonGoBack = new avs(6, this.l / 2 - 152, 32, 20, 20, "<");
        this.n.add(this.buttonGoBack);
        this.buttonGoBack.m = !this.path.isEmpty();
        Keyboard.enableRepeatEvents((boolean)true);
        Tabs.initGui(this);
    }

    public void m() {
        super.m();
        Keyboard.enableRepeatEvents((boolean)false);
        LabyMod.getMainConfig().save();
    }

    private void doQuery(String query) {
        this.tempElementsStored.clear();
        if (this.path.isEmpty()) {
            for (SettingsCategory settingsCategory : DefinedSettings.getCategories()) {
                this.queryCategory(settingsCategory, query);
            }
        } else {
            SettingsElement currentOpenElement = this.path.get(this.path.size() - 1);
            this.tempElementsStored.addAll(currentOpenElement.getSubSettings().getElements());
        }
        this.listedElementsStored = this.tempElementsStored;
    }

    private void queryCategory(SettingsCategory settingsCategory, String query) {
        ArrayList<SettingsElement> elementsToAdd = new ArrayList<SettingsElement>();
        for (SettingsElement element : settingsCategory.getSettings().getElements()) {
            if (query == null || settingsCategory.getTitle().toLowerCase().contains(query) || this.isSettingElement(query, element)) {
                elementsToAdd.add(element);
            }
            if (query == null || query.isEmpty() || element.getSubSettings() == null || element.getSubSettings().getElements().isEmpty()) continue;
            for (SettingsElement subElement : element.getSubSettings().getElements()) {
                if (!this.isSettingElement(query, subElement)) continue;
                elementsToAdd.add(subElement);
            }
        }
        if (!elementsToAdd.isEmpty()) {
            this.tempElementsStored.add(new HeaderElement(settingsCategory.getTitle()));
        }
        for (SettingsElement element : elementsToAdd) {
            this.tempElementsStored.add(element);
        }
        for (SettingsCategory subCategory : settingsCategory.getSubList()) {
            this.queryCategory(subCategory, query);
        }
    }

    private boolean isSettingElement(String query, SettingsElement settingsElement) {
        return settingsElement.getDisplayName().toLowerCase().contains(query) || settingsElement.getDescriptionText() != null && settingsElement.getDescriptionText().toLowerCase().contains(query);
    }

    public void a(int mouseX, int mouseY, float partialTicks) {
        DrawUtils draw = LabyMod.getInstance().getDrawUtils();
        draw.drawAutoDimmedBackground(this.scrollbar.getScrollY());
        this.drawSettingsList(mouseX, mouseY, this.m - 30);
        draw.drawOverlayBackground(0, 55);
        draw.drawGradientShadowTop(55.0, 0.0, this.l);
        int bottomBarheight = this.lastScreen == null && !LabyMod.getInstance().getUpdater().isUpdateAvailable() ? 10 : 25;
        draw.drawOverlayBackground(this.m - bottomBarheight, this.m);
        draw.drawGradientShadowBottom(this.m - bottomBarheight, 0.0, this.l);
        this.scrollbar.draw(mouseX, mouseY);
        if (!this.path.isEmpty()) {
            SettingsElement currentOpenElement = this.path.get(this.path.size() - 1);
            draw.drawString(currentOpenElement.getDisplayName(), this.l / 2 - 125, 39.0);
            if (currentOpenElement instanceof ControlElement) {
                ControlElement control = (ControlElement)currentOpenElement;
                ControlElement.IconData iconData = control.getIconData();
                if (iconData.hasTextureIcon()) {
                    ave.A().P().a(iconData.getTextureIcon());
                    LabyMod.getInstance().getDrawUtils().drawTexture(this.l / 2 + 130, 35.0, 256.0, 256.0, 16.0, 16.0);
                } else if (iconData.hasMaterialIcon()) {
                    LabyMod.getInstance().getDrawUtils().drawItem(iconData.getMaterialIcon().createItemStack(), this.l / 2 + 130, 35.0, null);
                }
            }
        } else {
            this.searchField.drawTextBox();
        }
        if (!this.skipDrawDescription) {
            this.drawDescriptions(mouseX, mouseY, 55, this.m - 30);
        }
        this.drawUpdateNotification(mouseX, mouseY);
        if (!LabyMod.getSettings().labymodSettingsInTabs) {
            this.hoverIconButtonGUI = this.drawIconButton("GUI", ModTextures.CHAT_TAB_GUI_EDITOR, this.l / 2 + 170, 42, mouseX, mouseY);
            this.hoverIconButtonAddons = this.drawIconButton("Addons", ModTextures.TAB_ADDONS, this.l / 2 + 170 + 20, 42, mouseX, mouseY);
        }
        super.a(mouseX, mouseY, partialTicks);
        Tabs.drawScreen(this, mouseX, mouseY);
    }

    private boolean drawIconButton(String title, jy resourceLocation, int x, int y, int mouseX, int mouseY) {
        boolean mouseOver;
        DrawUtils draw = LabyMod.getInstance().getDrawUtils();
        double size = 15.0;
        boolean bl = mouseOver = (double)mouseX > (double)x - size / 2.0 && (double)mouseX < (double)x + size / 2.0 && (double)mouseY > (double)y - size / 2.0 && (double)mouseY < (double)y + size / 2.0;
        if (mouseOver) {
            size += 2.0;
        }
        ave.A().P().a(resourceLocation);
        draw.drawTexture((double)x - size / 2.0, (double)y - size / 2.0, 255.0, 255.0, size, size);
        if (mouseOver) {
            TooltipHelper.getHelper().pointTooltip(mouseX, mouseY, 0L, title);
        }
        return mouseOver;
    }

    private void drawUpdateNotification(int mouseX, int mouseY) {
        if (this.l < 350) {
            return;
        }
        int offsetY = this.lastScreen == null && !LabyMod.getInstance().getUpdater().isUpdateAvailable() ? -8 : 0;
        ave.A().P().a(ModTextures.BUTTON_UPDATE);
        DrawUtils draw = LabyMod.getInstance().getDrawUtils();
        this.hoverUpdateButton = mouseX > 5 && mouseX < 20 && mouseY > this.m - 20 + offsetY && mouseY < this.m - 20 + 15 + offsetY;
        int add = this.hoverUpdateButton ? 1 : 0;
        draw.drawTexture(5 - add, this.m - 20 - add + offsetY, 255.0, 255.0, 15 + add * 2, 15 + add * 2);
        boolean updateAvailable = LabyMod.getInstance().getUpdater().isUpdateAvailable();
        if (updateAvailable) {
            boolean coreUpdate = LabyMod.getInstance().getUpdater().getCoreUpdate().isUpdateAvailable();
            String infoText = coreUpdate ? LanguageManager.translate("update_available") : LanguageManager.translate("addon_update_available", LabyMod.getInstance().getUpdater().getAddonUpdateCount());
            draw.drawString(infoText, 25.0, this.m - 20 + 4);
            if (this.hoverUpdateButton) {
                TooltipHelper.getHelper().pointTooltip(mouseX, mouseY, 0L, LanguageManager.translate("reinstall_version", LabyMod.getInstance().getUpdater().getCoreUpdate().getLatestVersion()));
            }
        } else if (this.hoverUpdateButton) {
            TooltipHelper.getHelper().pointTooltip(mouseX, mouseY, 0L, LanguageManager.translate("reinstall"));
        }
    }

    private void drawSettingsList(int mouseX, int mouseY, int maxY) {
        this.mouseOverElement = null;
        this.skipDrawDescription = false;
        double totalEntryHeight = 0.0;
        for (int zLevel = 0; zLevel < 2; ++zLevel) {
            double posY = 60.0 + this.scrollbar.getScrollY();
            int midX = this.l / 2;
            int elementLength = 150;
            totalEntryHeight = 0.0;
            for (SettingsElement element : this.listedElementsStored) {
                if ((!(element instanceof DropDownElement) || element instanceof ColorPickerCheckBoxBulkElement) && zLevel == 0 || (element instanceof DropDownElement || element instanceof ColorPickerCheckBoxBulkElement) && zLevel == 1) {
                    if (element instanceof DropDownElement) {
                        ((DropDownElement)element).getDropDownMenu().setMaxY(maxY);
                        if (((DropDownElement)element).getDropDownMenu().isOpen()) {
                            this.skipDrawDescription = true;
                        }
                    }
                    element.draw(midX - elementLength, (int)posY, midX + elementLength, (int)posY + element.getEntryHeight(), mouseX, mouseY);
                    if (element.isMouseOver()) {
                        this.mouseOverElement = element;
                    }
                }
                posY += (double)(element.getEntryHeight() + 1);
                totalEntryHeight += (double)(element.getEntryHeight() + 1);
            }
        }
        this.scrollbar.setEntryHeight(totalEntryHeight / (double)this.listedElementsStored.size());
        this.scrollbar.update(this.listedElementsStored.size());
    }

    private void drawDescriptions(int mouseX, int mouseY, int minY, int maxY) {
        for (SettingsElement element : this.listedElementsStored) {
            if (!element.isMouseOver() || mouseY <= minY || mouseY >= maxY) continue;
            element.drawDescription(mouseX, mouseY, this.l);
        }
    }

    protected void a(avs button) throws IOException {
        super.a(button);
        if (button.k == 5) {
            this.closed = true;
            ave.A().a(this.lastScreen);
        }
        if (button.k == 6 && !this.path.isEmpty()) {
            this.path.remove(this.path.size() - 1);
            this.b();
            this.scrollbar.setScrollY(this.preScrollPos);
            this.preScrollPos = 0.0;
        }
    }

    protected void a(int mouseX, int mouseY, int mouseButton) throws IOException {
        ControlElement element;
        super.a(mouseX, mouseY, mouseButton);
        if (Tabs.mouseClicked(this)) {
            return;
        }
        if (this.closed) {
            return;
        }
        if (this.hoverUpdateButton) {
            try {
                Updater updater = LabyMod.getInstance().getUpdater();
                updater.setForceUpdate(true);
                updater.ensureUpdaterAvailable(new Consumer<Boolean>(){

                    @Override
                    public void accept(Boolean accepted) {
                        ave.A().m();
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return;
        }
        for (SettingsElement element2 : this.listedElementsStored) {
            if (!(element2 instanceof DropDownElement) || !((DropDownElement)element2).onClickDropDown(mouseX, mouseY, mouseButton)) continue;
            return;
        }
        for (SettingsElement element2 : this.listedElementsStored) {
            element2.unfocus(mouseX, mouseY, mouseButton);
            if (!element2.isMouseOver()) continue;
            element2.mouseClicked(mouseX, mouseY, mouseButton);
        }
        if (this.mouseOverElement != null && this.mouseOverElement instanceof ControlElement && (element = (ControlElement)this.mouseOverElement).hasSubList() && element.getButtonAdvanced().a() && element.getButtonAdvanced().l) {
            element.getButtonAdvanced().a(this.j.W());
            if (element.getAdvancedButtonCallback() == null) {
                this.path.add(element);
                this.preScrollPos = this.scrollbar.getScrollY();
                this.scrollbar.setScrollY(0.0);
                this.b();
            } else {
                element.getAdvancedButtonCallback().accept(true);
            }
        }
        this.scrollbar.mouseAction(mouseX, mouseY, Scrollbar.EnumMouseAction.CLICKED);
        this.searchField.mouseClicked(mouseX, mouseY, mouseButton);
        if (this.hoverIconButtonGUI) {
            ave.A().a((axu)new LabyModModuleEditorGui(this));
        }
        if (this.hoverIconButtonAddons) {
            ave.A().a((axu)new LabyModAddonsGui(this));
        }
    }

    protected void b(int mouseX, int mouseY, int state) {
        super.b(mouseX, mouseY, state);
        for (SettingsElement element : this.listedElementsStored) {
            element.mouseRelease(mouseX, mouseY, state);
        }
        this.scrollbar.mouseAction(mouseX, mouseY, Scrollbar.EnumMouseAction.RELEASED);
    }

    protected void a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        super.a(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
        for (SettingsElement element : this.listedElementsStored) {
            element.mouseClickMove(mouseX, mouseY, clickedMouseButton);
        }
        this.scrollbar.mouseAction(mouseX, mouseY, Scrollbar.EnumMouseAction.DRAGGING);
    }

    protected void a(char typedChar, int keyCode) throws IOException {
        for (SettingsElement element : this.listedElementsStored) {
            boolean cancel = element instanceof KeyElement && ((KeyElement)element).getTextField().isFocused();
            element.keyTyped(typedChar, keyCode);
            if (!cancel) continue;
            return;
        }
        if (keyCode == 1) {
            this.j.a(this.lastScreen);
            return;
        }
        super.a(typedChar, keyCode);
        if (this.path.isEmpty() && this.searchField.textboxKeyTyped(typedChar, keyCode)) {
            this.doQuery(this.searchField.getText().toLowerCase());
        }
    }

    public void k() throws IOException {
        super.k();
        this.scrollbar.mouseInput();
    }

    public void e() {
        super.e();
        this.searchField.updateCursorCounter();
    }
}

