/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.settings;

import java.awt.Color;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.labymod.gui.elements.CheckBox;
import net.labymod.gui.elements.ColorPicker;
import net.labymod.gui.elements.DropDownMenu;
import net.labymod.ingamegui.Module;
import net.labymod.ingamegui.ModuleConfig;
import net.labymod.ingamegui.enums.EnumModuleAlignment;
import net.labymod.ingamegui.enums.EnumModuleFormatting;
import net.labymod.ingamegui.moduletypes.ColoredTextModule;
import net.labymod.ingamegui.moduletypes.ItemModule;
import net.labymod.ingamegui.moduletypes.SimpleModule;
import net.labymod.ingamegui.moduletypes.TextModule;
import net.labymod.main.LabyMod;
import net.labymod.main.ModTextures;
import net.labymod.main.lang.LanguageManager;
import net.labymod.settings.elements.BooleanElement;
import net.labymod.settings.elements.ColorPickerCheckBoxBulkElement;
import net.labymod.settings.elements.ControlElement;
import net.labymod.settings.elements.DropDownElement;
import net.labymod.settings.elements.SettingsElement;
import net.labymod.settings.elements.SliderElement;
import net.labymod.settings.elements.StringElement;
import net.labymod.utils.Consumer;
import net.labymod.utils.Material;
import net.labymod.utils.ModColor;

public class DefaultElementsCreator {
    public static void createAlignment(final Module module, final boolean isDefaultSetting, List<SettingsElement> settingsElements) {
        String displayNameAlignment = LanguageManager.translate((isDefaultSetting ? "default" : "custom") + "_alignment");
        DropDownMenu<EnumModuleAlignment> alignmentDropDownMenu = new DropDownMenu<EnumModuleAlignment>(displayNameAlignment, 0, 0, 0, 0).fill(EnumModuleAlignment.values());
        if (isDefaultSetting) {
            alignmentDropDownMenu.remove(EnumModuleAlignment.DEFAULT);
        }
        DropDownElement<EnumModuleAlignment> alignmentDropDown = new DropDownElement<EnumModuleAlignment>(displayNameAlignment, alignmentDropDownMenu);
        alignmentDropDownMenu.setSelected(isDefaultSetting ? ModuleConfig.getConfig().getDefaultAlignment() : module.getModuleConfigElement().getAlignment(Module.getLastDrawnDisplayType().ordinal()));
        if (!isDefaultSetting) {
            alignmentDropDown.setModuleCopyVisible(module);
        }
        alignmentDropDown.setChangeListener(new Consumer<EnumModuleAlignment>(){

            @Override
            public void accept(EnumModuleAlignment alignment) {
                if (alignment != null) {
                    if (isDefaultSetting) {
                        ModuleConfig.getConfig().setDefaultAlignment(alignment);
                    } else {
                        module.getModuleConfigElement().setAlignment(Module.getLastDrawnDisplayType().ordinal(), alignment);
                    }
                }
                if (module != null) {
                    module.init();
                }
            }
        });
        alignmentDropDownMenu.setEntryDrawer(new DropDownMenu.DropDownEntryDrawer(){

            @Override
            public void draw(Object object, int x, int y, String trimmedEntry) {
                String entry = object.toString().toLowerCase();
                LabyMod.getInstance().getDrawUtils().drawString(LanguageManager.translate(entry), x, y);
            }
        });
        settingsElements.add(alignmentDropDown);
    }

    public static void createFormatting(final TextModule module, final boolean isDefaultSetting, List<SettingsElement> settingsElements) {
        String displayNameFormatting = LanguageManager.translate((isDefaultSetting ? "default" : "custom") + "_formatting");
        final DropDownMenu<EnumModuleFormatting> formattingDropDownMenu = new DropDownMenu<EnumModuleFormatting>(displayNameFormatting, 0, 0, 0, 0).fill(EnumModuleFormatting.values());
        if (isDefaultSetting) {
            formattingDropDownMenu.remove(EnumModuleFormatting.DEFAULT);
        }
        DropDownElement<EnumModuleFormatting> formattingDropDown = new DropDownElement<EnumModuleFormatting>(displayNameFormatting, formattingDropDownMenu);
        String formattingString = isDefaultSetting ? "" : module.getAttributes().get("formatting");
        try {
            formattingDropDownMenu.setSelected(isDefaultSetting ? ModuleConfig.getConfig().getDefaultFormatting() : (formattingString == null ? EnumModuleFormatting.DEFAULT : EnumModuleFormatting.values()[Integer.parseInt(formattingString)]));
        }
        catch (NumberFormatException ex) {
            ex.printStackTrace();
        }
        if (!isDefaultSetting) {
            formattingDropDown.setModuleCopyVisible(module);
        }
        formattingDropDown.setChangeListener(new Consumer<EnumModuleFormatting>(){

            @Override
            public void accept(EnumModuleFormatting formatting) {
                if (formatting != null) {
                    if (isDefaultSetting) {
                        ModuleConfig.getConfig().setDefaultFormatting((EnumModuleFormatting)((Object)formattingDropDownMenu.getSelected()));
                    } else {
                        module.getAttributes().put("formatting", String.valueOf(formatting.ordinal()));
                    }
                }
                if (module != null) {
                    module.init();
                }
            }
        });
        formattingDropDownMenu.setEntryDrawer(new DropDownMenu.DropDownEntryDrawer(){

            @Override
            public void draw(Object object, int x, int y, String trimmedEntry) {
                EnumModuleFormatting enumModuleFormatting = (EnumModuleFormatting)((Object)object);
                if (enumModuleFormatting == EnumModuleFormatting.DEFAULT) {
                    LabyMod.getInstance().getDrawUtils().drawString(LanguageManager.translate("default"), x, y);
                    return;
                }
                if (!isDefaultSetting) {
                    module.setColors();
                    module.setFormattings();
                    module.drawLine(enumModuleFormatting, x, y, "K", Arrays.asList(new ColoredTextModule.Text("V", -1)));
                }
                ModuleConfig config = ModuleConfig.getConfig();
                TextModule.drawTextLine(enumModuleFormatting, x, y, "K", Collections.singletonList(new ColoredTextModule.Text("V", -1)), config.getBracketsColor(), config.getPrefixColor(), config.getValuesColor(), config.getFormattingBold() == 1, config.getFormattingItalic() == 1, config.getFormattingUnderline() == 1);
            }
        });
        settingsElements.add(formattingDropDown);
    }

    public static void createColorPicker(final TextModule module, final boolean isDefaultSetting, List<SettingsElement> settingsElements) {
        String underlineAttr;
        String italicAttr;
        String boldAttr;
        ColorPickerCheckBoxBulkElement colorPickerBulkElement = new ColorPickerCheckBoxBulkElement("Colors");
        colorPickerBulkElement.setCheckBoxRightBound(true);
        if (!isDefaultSetting) {
            colorPickerBulkElement.setModuleCopyVisible(module);
        }
        Color colorDefaultPrefix = new Color(ModuleConfig.getConfig().getPrefixColor());
        Color colorPrefix = isDefaultSetting ? colorDefaultPrefix : ModColor.getColorByString(module.getAttributes().get("prefixColor"));
        final ColorPicker colorPickerPrefix = new ColorPicker("Prefix", colorPrefix, new ColorPicker.DefaultColorCallback(){

            @Override
            public Color getDefaultColor() {
                return new Color(ModuleConfig.getConfig().getPrefixColor());
            }
        }, 0, 0, 0, 0);
        colorPickerPrefix.setHasAdvanced(true);
        colorPickerPrefix.setHasDefault(!isDefaultSetting);
        colorPickerPrefix.setUpdateListener(new Consumer<Color>(){

            @Override
            public void accept(Color color) {
                if (color != null && color.getRGB() == -1) {
                    color = new Color(254, 254, 254);
                }
                colorPickerPrefix.setDefault(color == null);
                if (isDefaultSetting) {
                    ModuleConfig.getConfig().setPrefixColor(color.getRGB());
                } else {
                    module.getAttributes().put("prefixColor", String.valueOf(color == null ? -1 : color.getRGB()));
                    module.getModuleConfigElement().setAttributes(module.getAttributes());
                }
                if (module != null) {
                    module.init();
                }
            }
        });
        colorPickerBulkElement.addColorPicker(colorPickerPrefix);
        Color colorDefaultBrackets = new Color(ModuleConfig.getConfig().getBracketsColor());
        Color colorBrackets = isDefaultSetting ? colorDefaultBrackets : ModColor.getColorByString(module.getAttributes().get("bracketsColor"));
        final ColorPicker colorPickerBrackets = new ColorPicker("Brackets", colorBrackets, new ColorPicker.DefaultColorCallback(){

            @Override
            public Color getDefaultColor() {
                return new Color(ModuleConfig.getConfig().getBracketsColor());
            }
        }, 0, 0, 0, 0);
        colorPickerBrackets.setHasAdvanced(true);
        colorPickerBrackets.setHasDefault(!isDefaultSetting);
        colorPickerBrackets.setUpdateListener(new Consumer<Color>(){

            @Override
            public void accept(Color color) {
                if (color != null && color.getRGB() == -1) {
                    color = new Color(254, 254, 254);
                }
                colorPickerBrackets.setDefault(color == null);
                if (isDefaultSetting) {
                    ModuleConfig.getConfig().setBracketsColor(color.getRGB());
                } else {
                    module.getAttributes().put("bracketsColor", String.valueOf(color == null ? -1 : color.getRGB()));
                    module.getModuleConfigElement().setAttributes(module.getAttributes());
                }
                if (module != null) {
                    module.init();
                }
            }
        });
        colorPickerBulkElement.addColorPicker(colorPickerBrackets);
        Color colorDefaultValue = new Color(ModuleConfig.getConfig().getValuesColor());
        Color colorValue = isDefaultSetting ? colorDefaultValue : ModColor.getColorByString(module.getAttributes().get("valueColor"));
        final ColorPicker colorPickerValue = new ColorPicker("Value", colorValue, new ColorPicker.DefaultColorCallback(){

            @Override
            public Color getDefaultColor() {
                return new Color(ModuleConfig.getConfig().getValuesColor());
            }
        }, 0, 0, 0, 0);
        colorPickerValue.setHasAdvanced(true);
        colorPickerValue.setHasDefault(!isDefaultSetting);
        colorPickerValue.setUpdateListener(new Consumer<Color>(){

            @Override
            public void accept(Color color) {
                if (color != null && color.getRGB() == -1) {
                    color = new Color(254, 254, 254);
                }
                colorPickerValue.setDefault(color == null);
                if (isDefaultSetting) {
                    ModuleConfig.getConfig().setValuesColor(color.getRGB());
                } else {
                    module.getAttributes().put("valueColor", String.valueOf(color == null ? -1 : color.getRGB()));
                    module.getModuleConfigElement().setAttributes(module.getAttributes());
                }
                if (module != null) {
                    module.init();
                }
            }
        });
        colorPickerBulkElement.addColorPicker(colorPickerValue);
        CheckBox.EnumCheckBoxValue checkedDefaultBold = ModuleConfig.getConfig().getFormattingBold() == 1 ? CheckBox.EnumCheckBoxValue.ENABLED : (ModuleConfig.getConfig().getFormattingBold() == -1 ? CheckBox.EnumCheckBoxValue.DEFAULT : CheckBox.EnumCheckBoxValue.DISABLED);
        String string = boldAttr = isDefaultSetting ? null : module.getAttributes().get("boldFormatting");
        CheckBox.EnumCheckBoxValue checkedBold = isDefaultSetting ? checkedDefaultBold : (boldAttr == null ? CheckBox.EnumCheckBoxValue.DEFAULT : (Integer.parseInt(boldAttr) == 1 ? CheckBox.EnumCheckBoxValue.ENABLED : CheckBox.EnumCheckBoxValue.DISABLED));
        CheckBox checkBoxBold = new CheckBox("Bold", checkedBold, new CheckBox.DefaultCheckBoxValueCallback(){

            @Override
            public CheckBox.EnumCheckBoxValue getDefaultValue() {
                return ModuleConfig.getConfig().getFormattingBold() == 1 ? CheckBox.EnumCheckBoxValue.ENABLED : (ModuleConfig.getConfig().getFormattingBold() == -1 ? CheckBox.EnumCheckBoxValue.DEFAULT : CheckBox.EnumCheckBoxValue.DISABLED);
            }
        }, 0, 0, 0, 0);
        checkBoxBold.setHasDefault(!isDefaultSetting);
        checkBoxBold.setUpdateListener(new Consumer<CheckBox.EnumCheckBoxValue>(){

            @Override
            public void accept(CheckBox.EnumCheckBoxValue accepted) {
                int mode;
                int n = accepted == null || accepted == CheckBox.EnumCheckBoxValue.DEFAULT ? -1 : (mode = accepted == CheckBox.EnumCheckBoxValue.ENABLED ? 1 : 0);
                if (isDefaultSetting) {
                    ModuleConfig.getConfig().setFormattingBold(mode);
                } else {
                    module.getAttributes().put("boldFormatting", String.valueOf(mode));
                    module.getModuleConfigElement().setAttributes(module.getAttributes());
                }
                if (module != null) {
                    module.init();
                }
            }
        });
        colorPickerBulkElement.addCheckbox(checkBoxBold);
        CheckBox.EnumCheckBoxValue checkedDefaultItalic = ModuleConfig.getConfig().getFormattingItalic() == 1 ? CheckBox.EnumCheckBoxValue.ENABLED : (ModuleConfig.getConfig().getFormattingItalic() == -1 ? CheckBox.EnumCheckBoxValue.DEFAULT : CheckBox.EnumCheckBoxValue.DISABLED);
        String string2 = italicAttr = isDefaultSetting ? null : module.getAttributes().get("italicFormatting");
        CheckBox.EnumCheckBoxValue checkedItalic = isDefaultSetting ? checkedDefaultItalic : (italicAttr == null ? CheckBox.EnumCheckBoxValue.DEFAULT : (Integer.parseInt(italicAttr) == 1 ? CheckBox.EnumCheckBoxValue.ENABLED : CheckBox.EnumCheckBoxValue.DISABLED));
        CheckBox checkBoxItalic = new CheckBox("Italic", checkedItalic, new CheckBox.DefaultCheckBoxValueCallback(){

            @Override
            public CheckBox.EnumCheckBoxValue getDefaultValue() {
                return ModuleConfig.getConfig().getFormattingItalic() == 1 ? CheckBox.EnumCheckBoxValue.ENABLED : (ModuleConfig.getConfig().getFormattingItalic() == -1 ? CheckBox.EnumCheckBoxValue.DEFAULT : CheckBox.EnumCheckBoxValue.DISABLED);
            }
        }, 0, 0, 0, 0);
        checkBoxItalic.setHasDefault(!isDefaultSetting);
        checkBoxItalic.setUpdateListener(new Consumer<CheckBox.EnumCheckBoxValue>(){

            @Override
            public void accept(CheckBox.EnumCheckBoxValue accepted) {
                int mode;
                int n = accepted == null || accepted == CheckBox.EnumCheckBoxValue.DEFAULT ? -1 : (mode = accepted == CheckBox.EnumCheckBoxValue.ENABLED ? 1 : 0);
                if (isDefaultSetting) {
                    ModuleConfig.getConfig().setFormattingItalic(mode);
                } else {
                    module.getAttributes().put("italicFormatting", String.valueOf(mode));
                    module.getModuleConfigElement().setAttributes(module.getAttributes());
                }
                if (module != null) {
                    module.init();
                }
            }
        });
        colorPickerBulkElement.addCheckbox(checkBoxItalic);
        CheckBox.EnumCheckBoxValue checkedDefaultUnderline = ModuleConfig.getConfig().getFormattingUnderline() == 1 ? CheckBox.EnumCheckBoxValue.ENABLED : (ModuleConfig.getConfig().getFormattingUnderline() == -1 ? CheckBox.EnumCheckBoxValue.DEFAULT : CheckBox.EnumCheckBoxValue.DISABLED);
        String string3 = underlineAttr = isDefaultSetting ? null : module.getAttributes().get("underlineFormatting");
        CheckBox.EnumCheckBoxValue checkedUnderline = isDefaultSetting ? checkedDefaultUnderline : (underlineAttr == null ? CheckBox.EnumCheckBoxValue.DEFAULT : (Integer.parseInt(underlineAttr) == 1 ? CheckBox.EnumCheckBoxValue.ENABLED : CheckBox.EnumCheckBoxValue.DISABLED));
        CheckBox checkBoxUnderline = new CheckBox("Underline", checkedUnderline, new CheckBox.DefaultCheckBoxValueCallback(){

            @Override
            public CheckBox.EnumCheckBoxValue getDefaultValue() {
                return ModuleConfig.getConfig().getFormattingUnderline() == 1 ? CheckBox.EnumCheckBoxValue.ENABLED : (ModuleConfig.getConfig().getFormattingUnderline() == -1 ? CheckBox.EnumCheckBoxValue.DEFAULT : CheckBox.EnumCheckBoxValue.DISABLED);
            }
        }, 0, 0, 0, 0);
        checkBoxUnderline.setHasDefault(!isDefaultSetting);
        checkBoxUnderline.setUpdateListener(new Consumer<CheckBox.EnumCheckBoxValue>(){

            @Override
            public void accept(CheckBox.EnumCheckBoxValue accepted) {
                int mode;
                int n = accepted == null || accepted == CheckBox.EnumCheckBoxValue.DEFAULT ? -1 : (mode = accepted == CheckBox.EnumCheckBoxValue.ENABLED ? 1 : 0);
                if (isDefaultSetting) {
                    ModuleConfig.getConfig().setFormattingUnderline(mode);
                } else {
                    module.getAttributes().put("underlineFormatting", String.valueOf(mode));
                    module.getModuleConfigElement().setAttributes(module.getAttributes());
                }
                if (module != null) {
                    module.init();
                }
            }
        });
        colorPickerBulkElement.addCheckbox(checkBoxUnderline);
        settingsElements.add(colorPickerBulkElement);
    }

    public static void createDurability(final ItemModule module, final boolean isDefaultSetting, List<SettingsElement> settingsElements) {
        String displayNameItemDurability = LanguageManager.translate("item_durability_option");
        DropDownMenu<ItemModule.DurabilityVisibility> itemDurabilityDropDownMenu = new DropDownMenu<ItemModule.DurabilityVisibility>(displayNameItemDurability, 0, 0, 0, 0).fill(ItemModule.DurabilityVisibility.values());
        if (isDefaultSetting) {
            itemDurabilityDropDownMenu.remove(ItemModule.DurabilityVisibility.DEFAULT);
        }
        DropDownElement<ItemModule.DurabilityVisibility> itemDurabilityDropDown = new DropDownElement<ItemModule.DurabilityVisibility>(displayNameItemDurability, itemDurabilityDropDownMenu);
        if (!isDefaultSetting) {
            itemDurabilityDropDown.setModuleCopyVisible(module);
        }
        itemDurabilityDropDownMenu.setSelected(isDefaultSetting ? ModuleConfig.getConfig().getDefaultDurabilityVisibility() : module.visibility);
        itemDurabilityDropDown.setChangeListener(new Consumer<ItemModule.DurabilityVisibility>(){

            @Override
            public void accept(ItemModule.DurabilityVisibility durabilityVisibility) {
                if (isDefaultSetting) {
                    ModuleConfig.getConfig().setDefaultDurabilityVisibility(durabilityVisibility);
                } else {
                    module.visibility = durabilityVisibility;
                    module.setAttribute("visibility", module.visibility.name());
                }
                if (module != null) {
                    module.init();
                }
            }
        });
        itemDurabilityDropDownMenu.setEntryDrawer(new DropDownMenu.DropDownEntryDrawer(){

            @Override
            public void draw(Object object, int x, int y, String trimmedEntry) {
                ItemModule.DurabilityVisibility durabilityVisibility = (ItemModule.DurabilityVisibility)((Object)object);
                zx item = isDefaultSetting ? new zx(zw.b((int)1), 1) : module.getItem();
                LabyMod.getInstance().getDrawUtils().drawString(durabilityVisibility.getDurabilityBuilder() == null ? durabilityVisibility.getDisplayName() : durabilityVisibility.getDurabilityBuilder().build(item), x, y);
            }
        });
        settingsElements.add(itemDurabilityDropDown);
    }

    public static void createKeyVisible(final TextModule module, final boolean isDefaultSetting, List<SettingsElement> settingsElements) {
        BooleanElement booleanElement = new BooleanElement(LanguageManager.translate("key_visible_switch"), new ControlElement.IconData(ModTextures.SETTINGS_DEFAULT_DISPLAY_KEY), new Consumer<Boolean>(){

            @Override
            public void accept(Boolean accepted) {
                if (isDefaultSetting) {
                    ModuleConfig.getConfig().setKeyVisible(accepted);
                } else {
                    module.setKeyVisible(accepted);
                    module.setAttribute("keyVisible", String.valueOf(accepted));
                }
                if (module != null) {
                    module.init();
                }
            }
        }, isDefaultSetting ? ModuleConfig.getConfig().isKeyVisible() : module.isKeyVisible());
        if (!isDefaultSetting) {
            booleanElement.setModuleCopyVisible(module);
        }
        settingsElements.add(booleanElement);
    }

    public static void createPadding(final Module module, final boolean isDefaultSetting, List<SettingsElement> settingsElements) {
        SliderElement element = new SliderElement(LanguageManager.translate("padding"), new ControlElement.IconData(ModTextures.SETTINGS_DEFAULT_PADDING), isDefaultSetting || !module.getAttributes().containsKey("padding") ? ModuleConfig.getConfig().getPadding() : Integer.parseInt(module.getAttributes().get("padding")));
        element.addCallback(new Consumer<Integer>(){

            @Override
            public void accept(Integer accepted) {
                if (isDefaultSetting) {
                    ModuleConfig.getConfig().setPadding(accepted);
                } else {
                    module.setAttribute("padding", String.valueOf(accepted));
                }
                if (module != null) {
                    module.init();
                }
            }
        });
        element.setRange(0, 5);
        if (!isDefaultSetting) {
            element.setModuleCopyVisible(module);
        }
        settingsElements.add(element);
    }

    public static void createBackgroundVisible(final Module module, final boolean isDefaultSetting, List<SettingsElement> settingsElements) {
        final BooleanElement booleanElement = new BooleanElement(LanguageManager.translate("background_visible_switch"), new ControlElement.IconData(ModTextures.SETTINGS_DEFAULT_BACKGROUND), null, isDefaultSetting ? ModuleConfig.getConfig().isBackgroundVisible() : (module.getAttributes().containsKey("backgroundVisible") ? Boolean.parseBoolean(module.getAttributes().get("backgroundVisible")) : false));
        booleanElement.addCallback(new Consumer<Boolean>(){

            @Override
            public void accept(Boolean accepted) {
                if (isDefaultSetting) {
                    ModuleConfig.getConfig().setBackgroundVisible(accepted);
                } else {
                    module.setAttribute("backgroundVisible", String.valueOf(accepted));
                }
                booleanElement.setSettingEnabled(accepted);
                if (module != null) {
                    module.init();
                }
            }
        });
        SliderElement transparencyElement = new SliderElement(LanguageManager.translate("transparency_slider"), new ControlElement.IconData(Material.THIN_GLASS), isDefaultSetting ? ModuleConfig.getConfig().getBackgroundTransparency() : (module.getAttributes().containsKey("backgroundTransparency") ? Integer.parseInt(module.getAttributes().get("backgroundTransparency")) : 50));
        transparencyElement.setRange(0, 255);
        transparencyElement.addCallback(new Consumer<Integer>(){

            @Override
            public void accept(Integer accepted) {
                if (isDefaultSetting) {
                    ModuleConfig.getConfig().setBackgroundTransparency(accepted);
                } else {
                    module.setAttribute("backgroundTransparency", String.valueOf(accepted));
                }
                if (module != null) {
                    module.init();
                }
            }
        });
        booleanElement.getSubSettings().add(transparencyElement);
        ColorPickerCheckBoxBulkElement checkBoxBulkElement = new ColorPickerCheckBoxBulkElement("Background color");
        Color color = new Color(isDefaultSetting ? ModuleConfig.getConfig().getBackgroundColor() : (module.getAttributes().containsKey("backgroundColor") ? Integer.parseInt(module.getAttributes().get("backgroundColor")) : Integer.MIN_VALUE));
        final ColorPicker colorPicker = new ColorPicker(LanguageManager.translate("color"), color, new ColorPicker.DefaultColorCallback(){

            @Override
            public Color getDefaultColor() {
                return new Color(ModuleConfig.getConfig().getBackgroundColor());
            }
        }, 0, 0, 0, 0);
        colorPicker.setHasAdvanced(true);
        colorPicker.setHasDefault(!isDefaultSetting);
        colorPicker.setUpdateListener(new Consumer<Color>(){

            @Override
            public void accept(Color color) {
                colorPicker.setDefault(color == null);
                if (isDefaultSetting) {
                    ModuleConfig.getConfig().setBackgroundColor(color == null ? Integer.MIN_VALUE : color.getRGB());
                } else {
                    module.setAttribute("backgroundColor", String.valueOf(color == null ? Integer.MIN_VALUE : color.getRGB()));
                }
                if (module != null) {
                    module.init();
                }
            }
        });
        checkBoxBulkElement.addColorPicker(colorPicker);
        booleanElement.getSubSettings().add(checkBoxBulkElement);
        booleanElement.setSettingEnabled(booleanElement.getCurrentValue());
        if (!isDefaultSetting) {
            booleanElement.setModuleCopyVisible(module);
        }
        settingsElements.add(booleanElement);
    }

    public static void createKeyCustom(final SimpleModule module, List<SettingsElement> settingsElements) {
        StringElement stringElement = new StringElement("Custom Key", new ControlElement.IconData(Material.SIGN), module.getDisplayName(), new Consumer<String>(){

            @Override
            public void accept(String accepted) {
                module.setAttribute("customKey", String.valueOf(accepted));
                if (module != null) {
                    module.init();
                }
            }
        });
        settingsElements.add(stringElement);
    }
}

