/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.servermanager;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.netty.buffer.Unpooled;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.labymod.api.LabyModAddon;
import net.labymod.api.events.PluginMessageEvent;
import net.labymod.api.events.TabListEvent;
import net.labymod.api.permissions.Permissions;
import net.labymod.core.LabyModCore;
import net.labymod.ingamegui.Module;
import net.labymod.ingamegui.modules.ServerSupportModule;
import net.labymod.ingamegui.moduletypes.ColoredTextModule;
import net.labymod.main.LabyMod;
import net.labymod.servermanager.ChatDisplayAction;
import net.labymod.settings.elements.SettingsElement;
import net.labymod.utils.Consumer;

public abstract class Server {
    protected JsonParser jsonParser = new JsonParser();
    private String name;
    private String[] addressNames;
    protected int kills;
    private JsonObject config;
    private LabyModAddon bindedAddon;

    public Server(String name, String ... addressNames) {
        this.name = name;
        this.addressNames = addressNames;
        LabyMod.getInstance().getEventManager().register(new TabListEvent(){

            @Override
            public void onUpdate(TabListEvent.Type type, String formattedText, String unformattedText) {
                if (!LabyMod.getInstance().getServerManager().isServer(Server.this.getClass())) {
                    return;
                }
                try {
                    Server.this.handleTabInfoMessage(type, formattedText, unformattedText);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        });
        LabyMod.getInstance().getEventManager().register(new PluginMessageEvent(){

            @Override
            public void receiveMessage(String channelName, em packetBuffer) {
                try {
                    Server.this.handlePluginMessage(channelName, packetBuffer);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        });
        Map<String, JsonObject> list = LabyMod.getInstance().getServerManager().getServerConfigManager().getSettings().getServerConfigs();
        if (list.keySet().contains(name)) {
            this.config = list.get(name);
        } else {
            this.config = new JsonObject();
            LabyMod.getInstance().getServerManager().getConfig().getServerConfigs().put(name, this.config);
            LabyMod.getInstance().getServerManager().getServerConfigManager().save();
        }
        this.initConfig(this.config);
        this.loadConfig();
    }

    public abstract void onJoin(bde var1);

    public abstract ChatDisplayAction handleChatMessage(String var1, String var2) throws Exception;

    public abstract void handlePluginMessage(String var1, em var2) throws Exception;

    public abstract void handleTabInfoMessage(TabListEvent.Type var1, String var2, String var3) throws Exception;

    public void reset() {
        this.kills = 0;
    }

    public void draw() {
    }

    public void addModuleLines(List<DisplayLine> lines) {
        ServerSupportModule serverSupportModule;
        if (this.kills != 0 && (serverSupportModule = (ServerSupportModule)Module.getModuleByClass(ServerSupportModule.class)) != null && serverSupportModule.isShowKills()) {
            lines.add(new DisplayLine("Kills", Collections.singletonList(ColoredTextModule.Text.getText(String.valueOf(this.kills)))));
        }
    }

    public void loopSecond() {
    }

    public boolean isAllowed(Permissions.Permission permission) {
        return permission.isDefaultEnabled();
    }

    @Deprecated
    protected void initConfig(JsonObject config) {
    }

    public void loadConfig() {
    }

    public void saveConfig() {
        LabyMod.getInstance().getServerManager().getConfig().getServerConfigs().put(this.name, this.config);
        LabyMod.getInstance().getServerManager().getServerConfigManager().save();
    }

    public abstract void fillSubSettings(List<SettingsElement> var1);

    public void bindAddon(LabyModAddon labyModAddon) {
        this.bindedAddon = labyModAddon;
        if (this.bindedAddon != null) {
            this.fillSubSettings(this.bindedAddon.getSubSettings());
        }
    }

    public boolean getBooleanAttribute(String attribute, boolean defaultValue) {
        if (!this.config.has(attribute)) {
            this.config.addProperty(attribute, Boolean.valueOf(defaultValue));
        }
        return this.config.get(attribute).getAsBoolean();
    }

    public void setBooleanAttribute(String attribute, boolean value) {
        this.config.addProperty(attribute, Boolean.valueOf(value));
    }

    public void sendPluginMessage(String channelName, Consumer<em> packetBufferConsumer) {
        em packetBuffer = new em(Unpooled.buffer());
        packetBufferConsumer.accept(packetBuffer);
        LabyModCore.getMinecraft().sendPluginMessage(channelName, packetBuffer);
    }

    public String getName() {
        return this.name;
    }

    public String[] getAddressNames() {
        return this.addressNames;
    }

    public JsonObject getConfig() {
        return this.config;
    }

    public LabyModAddon getBindedAddon() {
        return this.bindedAddon;
    }

    public static class DisplayLine {
        private String key;
        private List<ColoredTextModule.Text> values;

        @ConstructorProperties(value={"key", "values"})
        public DisplayLine(String key, List<ColoredTextModule.Text> values) {
            this.key = key;
            this.values = values;
        }

        public String getKey() {
            return this.key;
        }

        public List<ColoredTextModule.Text> getValues() {
            return this.values;
        }
    }
}

