/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.main.listeners;

import com.google.common.base.Charsets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.DecoderException;
import net.labymod.addon.AddonLoader;
import net.labymod.addon.ForgeModsScanner;
import net.labymod.api.LabyModAddon;
import net.labymod.api.events.PluginMessageEvent;
import net.labymod.api.permissions.OldPluginMessage;
import net.labymod.api.permissions.Permissions;
import net.labymod.api.protocol.liquid.FixedLiquidBucketProtocol;
import net.labymod.core.asm.LabyModCoreMod;
import net.labymod.gui.GuiShaderSelection;
import net.labymod.ingamegui.ModuleConfig;
import net.labymod.main.LabyMod;
import net.labymod.mojang.afec.EntityCulling;
import net.labymod.settings.LabyModModuleEditorGui;
import net.labymod.support.util.Debug;
import net.labymod.utils.manager.SignManager;

public class PluginMessageListener
implements PluginMessageEvent {
    private static final JsonParser jsonParser = new JsonParser();

    @Override
    public void receiveMessage(String channelName, em packetBuffer) {
        if (!(channelName.equals("labymod3:ccp") || channelName.equals("labymod3:main") || channelName.equals("LMC"))) {
            Debug.log(Debug.EnumDebugMode.PLUGINMESSAGE, "[IN] " + channelName);
        }
        try {
            boolean brandMessage;
            OldPluginMessage.handlePluginMessage(channelName, packetBuffer);
            boolean updatedPermissions = false;
            if (channelName.equals("labymod3:main") || channelName.equals("LMC")) {
                String messageKey = "unknown";
                String messageContent = "couldn't read the content";
                try {
                    if (packetBuffer.readableBytes() <= 0) {
                        throw new Exception("There is no message key in channel " + channelName);
                    }
                    messageKey = this.readStringFromBuffer(Short.MAX_VALUE, packetBuffer);
                    if (packetBuffer.readableBytes() <= 0) {
                        throw new Exception("There is no message content in channel " + channelName);
                    }
                    messageContent = this.readStringFromBuffer(Short.MAX_VALUE, packetBuffer);
                    if (messageKey.equals("PERMISSIONS")) {
                        updatedPermissions = true;
                    }
                    JsonElement parsedServerMessage = jsonParser.parse(messageContent);
                    LabyMod.getInstance().getEventManager().callServerMessage(messageKey, parsedServerMessage);
                    Debug.log(Debug.EnumDebugMode.PLUGINMESSAGE, "[IN] [" + channelName + "] " + messageKey + ": " + messageContent + "");
                    if (messageKey.equals("tablist_cache")) {
                        LabyMod.getInstance().setPlayerListCacheEnabled(parsedServerMessage.getAsJsonObject().get("enabled").getAsBoolean());
                        LabyMod.getInstance().getPlayerListDataCache().clear();
                    }
                }
                catch (Exception ex) {
                    Debug.log(Debug.EnumDebugMode.PLUGINMESSAGE, "Failed parsing JSON message \"" + messageContent + "\" (key: " + messageKey + ")");
                    ex.printStackTrace();
                }
            }
            if (channelName.equals("LABYMOD") || updatedPermissions) {
                Permissions.getPermissionNotifyRenderer().checkChangedPermissions();
            }
            if ((brandMessage = channelName.equals("MC|Brand")) && LabyMod.getSettings().improvedLavaFixedGhostBlocks && LabyMod.getInstance().getCurrentServerData() != null && Permissions.isAllowed(Permissions.Permission.IMPROVED_LAVA)) {
                FixedLiquidBucketProtocol.handleBucketAction(FixedLiquidBucketProtocol.Action.ENABLE, 0, 0, 0);
            }
            if (brandMessage) {
                LabyMod.getInstance().getChunkCachingProtocol().disable(null, true);
                JsonArray addons = new JsonArray();
                for (LabyModAddon addonInfo : AddonLoader.getAddons()) {
                    if (addonInfo.about == null || addonInfo.about.uuid == null) continue;
                    JsonObject entry = new JsonObject();
                    entry.addProperty("uuid", addonInfo.about.uuid.toString());
                    entry.addProperty("name", addonInfo.about.name);
                    addons.add((JsonElement)entry);
                }
                JsonObject ccp = new JsonObject();
                ccp.addProperty("enabled", Boolean.valueOf(LabyMod.getSettings().chunkCaching));
                ccp.addProperty("version", (Number)2);
                JsonObject shadow = new JsonObject();
                shadow.addProperty("enabled", Boolean.valueOf(true));
                shadow.addProperty("version", (Number)1);
                JsonObject obj = new JsonObject();
                obj.addProperty("version", "3.9.62");
                obj.add("ccp", (JsonElement)ccp);
                obj.add("shadow", (JsonElement)shadow);
                obj.add("addons", (JsonElement)addons);
                if (LabyModCoreMod.isForge()) {
                    obj.add("mods", (JsonElement)ForgeModsScanner.getInstance().getJsonArray());
                }
                LabyMod.getInstance().getLabyModAPI().sendJsonMessageToServer("INFO", (JsonElement)obj);
                if (LabyMod.getSettings().loadedShader != null && LabyMod.getSettings().betterShaderSelection) {
                    try {
                        GuiShaderSelection.loadShader(new jy(LabyMod.getSettings().loadedShader));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                SignManager.reset();
                LabyMod.getInstance().getPlayerListDataCache().clear();
                LabyMod.getInstance().getPriorityOverlayRenderer().reset();
                LabyMod.getInstance().getCinematicProtocol().reset(false);
                EntityCulling.updateShadersModValue();
            }
            if (brandMessage && ave.A().F()) {
                ModuleConfig.switchProfile(LabyModModuleEditorGui.SINGLEPLAYER_PROFILE, false);
            }
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    public String readStringFromBuffer(int maxLength, em packetBuffer) {
        int i = this.readVarIntFromBuffer(packetBuffer);
        if (i > maxLength * 4) {
            throw new DecoderException("The received encoded string buffer length is longer than maximum allowed (" + i + " > " + maxLength * 4 + ")");
        }
        if (i < 0) {
            throw new DecoderException("The received encoded string buffer length is less than zero! Weird string!");
        }
        ByteBuf byteBuf = packetBuffer.readBytes(i);
        byte[] bytes = null;
        if (byteBuf.hasArray()) {
            bytes = byteBuf.array();
        } else {
            bytes = new byte[byteBuf.readableBytes()];
            byteBuf.getBytes(byteBuf.readerIndex(), bytes);
        }
        String s = new String(bytes, Charsets.UTF_8);
        if (s.length() > maxLength) {
            throw new DecoderException("The received string length is longer than maximum allowed (" + i + " > " + maxLength + ")");
        }
        return s;
    }

    public int readVarIntFromBuffer(em packetBuffer) {
        byte b0;
        int i = 0;
        int j = 0;
        do {
            b0 = packetBuffer.readByte();
            i |= (b0 & 0x7F) << j++ * 7;
            if (j <= 5) continue;
            throw new RuntimeException("VarInt too big");
        } while ((b0 & 0x80) == 128);
        return i;
    }
}

