/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.main.lang;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import net.labymod.main.lang.Language;
import net.labymod.support.util.Debug;
import net.labymod.utils.ModColor;

public class LanguageManager {
    private static Map<String, Language> lang = new ConcurrentHashMap<String, Language>();
    private static Language language;
    private static Language defaultLanguage;
    public static String lastLocaleCode;

    public static void updateLang() {
        String defaultLanguageCode;
        String mcLanguage = defaultLanguageCode = "en_US";
        if (ave.A() != null && ave.A().S() != null && ave.A().S().c() != null && ave.A().S().c().a() != null) {
            mcLanguage = ave.A().S().c().a();
        }
        Language targetLanguage = null;
        for (Language lang : LanguageManager.lang.values()) {
            if (!mcLanguage.equals(lang.getName())) continue;
            targetLanguage = lang;
        }
        if (targetLanguage == null) {
            Debug.log(Debug.EnumDebugMode.LANGUAGE, mcLanguage + " is not loaded! Trying to load it..");
            targetLanguage = LanguageManager.load(mcLanguage);
        } else {
            Debug.log(Debug.EnumDebugMode.LANGUAGE, "Detected Minecraft language: " + mcLanguage);
        }
        if (defaultLanguage == null) {
            defaultLanguage = LanguageManager.load(defaultLanguageCode);
        }
        if (targetLanguage == null) {
            Debug.log(Debug.EnumDebugMode.LANGUAGE, mcLanguage + " doesn't exists, using default language instead.");
            targetLanguage = defaultLanguage;
        }
        if (targetLanguage == null) {
            Debug.log(Debug.EnumDebugMode.LANGUAGE, "Using no language!");
        } else {
            Debug.log(Debug.EnumDebugMode.LANGUAGE, "Using language " + targetLanguage.getName() + " now.");
        }
        language = targetLanguage;
        lastLocaleCode = mcLanguage;
    }

    public static Language load(String name) {
        try {
            Properties prop = new Properties();
            if (name.contains("_")) {
                String[] sp = name.split("_");
                String[] files = new String[]{sp[1], name, sp[0]};
                boolean found = false;
                for (String fileName : files) {
                    InputStream stream = LanguageManager.class.getResourceAsStream("/assets/minecraft/labymod/lang/" + fileName.toUpperCase() + ".properties");
                    if (stream == null) continue;
                    InputStreamReader reader = new InputStreamReader(stream, Charset.forName("UTF-8"));
                    prop.load(reader);
                    reader.close();
                    found = true;
                    break;
                }
                if (!found) {
                    Debug.log(Debug.EnumDebugMode.LANGUAGE, "Cannot find following language: " + name + " (" + sp[0] + ", " + sp[1] + ")");
                    return null;
                }
            }
            Language lang = new Language(name);
            for (Map.Entry<Object, Object> s : prop.entrySet()) {
                lang.translations.put(s.getKey().toString(), ModColor.createColors(s.getValue().toString()));
            }
            LanguageManager.lang.put(name, lang);
            return lang;
        }
        catch (Exception error) {
            error.printStackTrace();
            Debug.log(Debug.EnumDebugMode.LANGUAGE, "Couldn't load language file " + name + " " + error.getMessage());
            return null;
        }
    }

    public static String translateString(String key, boolean format, Object ... args) {
        if (ave.A() != null && ave.A().S() != null && ave.A().S().c() != null && ave.A().S().c().a() != null && !lastLocaleCode.equals(ave.A().S().c().a())) {
            LanguageManager.updateLang();
        }
        if (key == null || language == null) {
            return key;
        }
        String trans = language.get(key);
        if (trans == null && (defaultLanguage == null || (trans = defaultLanguage.get(key)) == null)) {
            return key;
        }
        if (format && args != null) {
            try {
                trans = String.format(trans, args);
            }
            catch (Exception error) {
                error.printStackTrace();
            }
        }
        return trans;
    }

    public static String translateOrReturnKey(String key, Object ... args) {
        String returned = LanguageManager.translate(key, args);
        return returned.contains("N/A") ? key : returned;
    }

    public static String translate(String key) {
        return LanguageManager.translateString(key, false, new Object[0]);
    }

    public static String translate(String key, Object ... args) {
        return LanguageManager.translateString(key, true, args);
    }

    public static Language getLanguage() {
        return language;
    }

    static {
        lastLocaleCode = "";
    }
}

