/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.labyconnect.packets;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.util.Base64;
import java.util.Collection;
import java.util.Iterator;
import java.util.UUID;
import net.labymod.labyconnect.handling.PacketHandler;
import net.labymod.labyconnect.packets.Packet;
import net.labymod.labyconnect.packets.PacketBuf;

public class PacketUserTracker
extends Packet {
    private static final Base64.Decoder BASE64_DECODER = Base64.getDecoder();
    private EnumTrackingChannel channel;
    private EnumTrackingAction action;
    private PlayerEntityMeta[] users;

    public PacketUserTracker() {
    }

    public PacketUserTracker(EnumTrackingChannel channel, EnumTrackingAction action) {
        this(channel, action, new PlayerEntityMeta[0]);
    }

    public PacketUserTracker(EnumTrackingChannel channel, EnumTrackingAction action, PlayerEntityMeta[] users) {
        this.channel = channel;
        this.action = action;
        this.users = users;
    }

    @Override
    public void read(PacketBuf buf) {
        buf.readByte();
        this.channel = EnumTrackingChannel.values()[buf.readByte()];
        this.action = EnumTrackingAction.values()[buf.readByte()];
        if (this.action != EnumTrackingAction.CLEAR) {
            this.users = new PlayerEntityMeta[buf.readInt()];
            for (int i = 0; i < this.users.length; ++i) {
                this.users[i] = new PlayerEntityMeta(buf.readLong(), buf.readLong());
                if (this.channel != EnumTrackingChannel.LIST || this.action != EnumTrackingAction.ADD) continue;
                this.users[i].setCape(buf.readByte());
            }
        }
        if (this.action == EnumTrackingAction.UPDATE) {
            buf.readByte();
        }
    }

    @Override
    public void write(PacketBuf buf) {
        buf.writeByte(5);
        buf.writeByte(this.channel.ordinal());
        buf.writeByte(this.action.ordinal());
        if (this.action != EnumTrackingAction.CLEAR) {
            buf.writeInt(this.users.length);
            for (PlayerEntityMeta user : this.users) {
                buf.writeLong(user.getMostSignificantBits());
                buf.writeLong(user.getLeastSignificantBits());
                if (this.channel != EnumTrackingChannel.LIST || this.action != EnumTrackingAction.ADD) continue;
                buf.writeByte(user.getCape());
            }
        }
        if (this.action == EnumTrackingAction.UPDATE) {
            buf.writeByte(0);
        }
    }

    @Override
    public void handle(PacketHandler packetHandler) {
    }

    public EnumTrackingChannel getChannel() {
        return this.channel;
    }

    public EnumTrackingAction getAction() {
        return this.action;
    }

    public PlayerEntityMeta[] getUsers() {
        return this.users;
    }

    public static enum CapeType {
        UNKNOWN(1, null),
        VANILLA(2, "f9a76537647989f9a0b6d001e320dac591c359e9e61a31f4ce11c88f207f0ad4"),
        MIGRATOR(3, "2340c0e03dd24a11b15a8b33c2a7e9e32abb2051b2481d0ba7defd635ca7a933");

        private final int type;
        private final String hash;

        private CapeType(int type, String hash) {
            this.type = type;
            this.hash = hash;
        }

        public int getType() {
            return this.type;
        }

        public String getHash() {
            return this.hash;
        }

        public static CapeType getByType(int type) {
            for (CapeType capeType : CapeType.values()) {
                if (capeType.getType() != type) continue;
                return capeType;
            }
            return UNKNOWN;
        }

        public static CapeType getByHash(String hash) {
            for (CapeType capeType : CapeType.values()) {
                if (!capeType.getHash().equals(hash)) continue;
                return capeType;
            }
            return UNKNOWN;
        }

        public static CapeType find(String json) {
            if (json.contains("\"CAPE\" :")) {
                for (CapeType type : CapeType.values()) {
                    if (type.getHash() == null || !json.contains(type.getHash())) continue;
                    return type;
                }
                return UNKNOWN;
            }
            return null;
        }
    }

    public static class PlayerEntityMeta {
        private final UUID uuid;
        private byte cape = 0;

        public PlayerEntityMeta(UUID uuid) {
            this.uuid = uuid;
        }

        public PlayerEntityMeta(long mostSignificantBits, long leastSignificantBits) {
            this.uuid = new UUID(mostSignificantBits, leastSignificantBits);
        }

        public PlayerEntityMeta(UUID uuid, byte cape) {
            this.uuid = uuid;
            this.cape = cape;
        }

        public PlayerEntityMeta(GameProfile profile) {
            this.uuid = profile.getId();
            try {
                Collection textures = profile.getProperties().get((Object)"textures");
                Iterator iterator = textures.iterator();
                if (iterator.hasNext()) {
                    Property texture = (Property)iterator.next();
                    String json = new String(BASE64_DECODER.decode(texture.getValue()));
                    CapeType type = CapeType.find(json);
                    if (type != null) {
                        this.cape = (byte)type.getType();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void setCape(byte cape) {
            this.cape = cape;
        }

        public int hashCode() {
            return this.uuid.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof PlayerEntityMeta) {
                return this.uuid.equals(((PlayerEntityMeta)obj).uuid);
            }
            return false;
        }

        public long getMostSignificantBits() {
            return this.uuid.getMostSignificantBits();
        }

        public long getLeastSignificantBits() {
            return this.uuid.getLeastSignificantBits();
        }

        public byte getCape() {
            return this.cape;
        }

        public UUID getUuid() {
            return this.uuid;
        }
    }

    public static enum EnumTrackingAction {
        ADD,
        REMOVE,
        UPDATE,
        CLEAR,
        SYNC;

    }

    public static enum EnumTrackingChannel {
        ENTITIES,
        LIST;

    }
}

