/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.ingamegui.moduletypes;

import net.labymod.core.LabyModCore;
import net.labymod.ingamegui.Module;
import net.labymod.ingamegui.ModuleConfig;
import net.labymod.ingamegui.ModuleGui;
import net.labymod.ingamegui.enums.EnumDisplayType;
import net.labymod.ingamegui.enums.EnumModuleRegion;

public abstract class ResizeableModule
extends Module {
    private double defaultWidth;
    private double defaultHeight;
    public double minWidth;
    public double minHeight;
    public double maxWidth;
    public double maxHeight;
    public double[] width;
    public double[] height;
    private boolean moving;
    protected boolean mouseOverVertical;
    protected boolean mouseOverHorizontal;
    private boolean mouseOverFirst;
    private double clickX = -1.0;
    private double clickY = -1.0;
    private boolean widthIsEqualToHeight;
    private ModuleGui.CoordinatesConsumer mouseClickListener = new ModuleGui.CoordinatesConsumer(){

        @Override
        public void accept(int mouseX, int mouseY, int mouseButton, EnumDisplayType displayType) {
            if (mouseButton != 0) {
                return;
            }
            if (!ResizeableModule.this.isEnabled(displayType) || ResizeableModule.this.moving) {
                return;
            }
            if (!ResizeableModule.this.mouseOverHorizontal && !ResizeableModule.this.mouseOverVertical) {
                return;
            }
            ResizeableModule.this.clickX = (double)mouseX + ResizeableModule.this.width[Module.getLastDrawnDisplayType().ordinal()];
            ResizeableModule.this.clickY = (double)mouseY + ResizeableModule.this.height[Module.getLastDrawnDisplayType().ordinal()];
            ResizeableModule.this.moving = true;
        }
    };
    private ModuleGui.CoordinatesConsumer mouseMoveListener = new ModuleGui.CoordinatesConsumer(){

        @Override
        public void accept(int mouseX, int mouseY, int mouseButton, EnumDisplayType displayType) {
            ResizeableModule.this.onMouseMove(mouseX, mouseY, mouseButton, displayType);
        }
    };
    private ModuleGui.CoordinatesConsumer mouseReleaseListener = new ModuleGui.CoordinatesConsumer(){

        @Override
        public void accept(int x, int y, int mouseButton, EnumDisplayType displayType) {
            if (mouseButton != 0) {
                return;
            }
            if (!ResizeableModule.this.moving) {
                return;
            }
            ResizeableModule.this.setAttribute("width", ResizeableModule.this.getStringByArray(ResizeableModule.this.width));
            ResizeableModule.this.setAttribute("height", ResizeableModule.this.getStringByArray(ResizeableModule.this.height));
            ResizeableModule.this.getModuleConfigElement().setX(displayType.ordinal(), ResizeableModule.this.getX(displayType.ordinal()));
            ResizeableModule.this.getModuleConfigElement().setY(displayType.ordinal(), ResizeableModule.this.getY(displayType.ordinal()));
            ResizeableModule.this.getModuleConfigElement().setRegion(displayType.ordinal(), ResizeableModule.this.getRegion(displayType.ordinal()));
            ResizeableModule.this.getModuleConfigElement().setAttributes(ResizeableModule.this.getAttributes());
            ResizeableModule.this.moving = false;
        }
    };

    private void onMouseMove(int mouseX, int mouseY, int mouseButton, EnumDisplayType displayType) {
        if (mouseButton != 0) {
            return;
        }
        if (!this.moving) {
            return;
        }
        if (this.mouseOverHorizontal) {
            short x = (short)mouseX;
            if (this.mouseOverFirst) {
                short newWidth = (short)(this.clickX - (double)x);
                if ((double)newWidth >= this.minWidth && (double)newWidth <= this.maxWidth) {
                    this.width[Module.getLastDrawnDisplayType().ordinal()] = newWidth;
                    if (!this.isRightBound(displayType)) {
                        this.updateCoordinate(true, this.mouseOverFirst, x, displayType, true);
                    }
                    if (this.widthIsEqualToHeight) {
                        this.height = this.width;
                    }
                }
            } else {
                short newWidth = (short)((double)x - this.getLastX());
                if ((double)newWidth >= this.minWidth && (double)newWidth <= this.maxWidth) {
                    this.width[Module.getLastDrawnDisplayType().ordinal()] = newWidth;
                    if (this.isRightBound(displayType)) {
                        this.updateCoordinate(true, this.mouseOverFirst, x, displayType, true);
                    }
                    if (this.widthIsEqualToHeight) {
                        this.height = this.width;
                    }
                }
            }
        } else {
            short y = (short)mouseY;
            if (this.mouseOverFirst) {
                short newHeight = (short)(this.clickY - (double)y);
                if ((double)newHeight >= this.minHeight && (double)newHeight <= this.maxHeight) {
                    this.height[Module.getLastDrawnDisplayType().ordinal()] = newHeight;
                    this.updateCoordinate(false, this.mouseOverFirst, y, displayType, false);
                    if (this.widthIsEqualToHeight) {
                        this.width = this.height;
                    }
                }
            } else {
                short newHeight = (short)((double)y - this.getLastY());
                if ((double)newHeight >= this.minHeight && (double)newHeight <= this.maxHeight) {
                    this.height[Module.getLastDrawnDisplayType().ordinal()] = newHeight;
                    if (this.widthIsEqualToHeight) {
                        this.width = this.height;
                    }
                }
            }
        }
    }

    @Deprecated
    private void updateCoordinate(boolean horizontal, boolean mouseOverFirst, short value, EnumDisplayType displayType) {
        this.updateCoordinate(horizontal, mouseOverFirst, value, displayType, true);
    }

    private void updateCoordinate(boolean horizontal, boolean mouseOverFirst, short value, EnumDisplayType displayType, boolean updateRegion) {
        double newValue;
        EnumModuleRegion newRegion = this.getRegion(displayType.ordinal());
        for (EnumModuleRegion regions : EnumModuleRegion.values()) {
            if (!regions.isInArea(horizontal ? (double)value : this.getLastX(), !horizontal ? (double)value : this.getLastY(), Module.getLastLeft(), Module.getLastRight(), Module.getLastTop(), Module.getLastBottom())) continue;
            newRegion = regions;
            break;
        }
        if (updateRegion && newRegion != this.getRegion(displayType.ordinal())) {
            this.setRegion(displayType.ordinal(), newRegion);
        }
        double d = newValue = horizontal ? this.getRegion(displayType.ordinal()).getOffsetX(value, Module.getLastLeft(), Module.getLastRight()) : this.getRegion(displayType.ordinal()).getOffsetY(value, Module.getLastTop(), Module.getLastBottom());
        if (horizontal) {
            this.setX(displayType.ordinal(), newValue);
            if (mouseOverFirst && this.isRightBound(displayType)) {
                this.setX(displayType.ordinal(), this.getRegion(displayType.ordinal()).getOffsetX((double)value + this.getWidth(), Module.getLastLeft(), Module.getLastRight()));
            }
            if (!mouseOverFirst && !this.isRightBound(displayType)) {
                this.setX(displayType.ordinal(), this.getRegion(displayType.ordinal()).getOffsetX((double)value - this.getWidth(), Module.getLastLeft(), Module.getLastRight()));
            }
        } else {
            this.setY(displayType.ordinal(), newValue);
        }
    }

    public ResizeableModule(short defaultWidth, short defaultHeight, short minWidth, short minHeight, short maxWidth, short maxHeight) {
        this(defaultWidth, defaultHeight, minWidth, minHeight, maxWidth, maxHeight, false);
    }

    public ResizeableModule(short defaultWidth, short defaultHeight, short minWidth, short minHeight, short maxWidth, short maxHeight, boolean widthIsEqualToHeight) {
        this.defaultWidth = defaultWidth;
        this.defaultHeight = defaultHeight;
        this.minWidth = minWidth;
        this.minHeight = minHeight;
        this.maxWidth = maxWidth;
        this.maxHeight = maxHeight;
        this.widthIsEqualToHeight = widthIsEqualToHeight;
    }

    @Override
    public void init() {
        double[] width = new double[EnumDisplayType.values().length];
        double[] height = new double[EnumDisplayType.values().length];
        String defaultWidthValue = "";
        String defaultHeightValue = "";
        for (int i = 0; i < EnumDisplayType.values().length; ++i) {
            defaultWidthValue = defaultWidthValue + (defaultWidthValue.equals("") ? "" : ",") + this.defaultWidth;
            defaultHeightValue = defaultHeightValue + (defaultHeightValue.equals("") ? "" : ",") + this.defaultHeight;
        }
        String widthAttribute = this.getAttribute("width", defaultWidthValue);
        String heightAttribute = this.getAttribute("height", defaultHeightValue);
        int i = 0;
        for (String widthSplit : widthAttribute.split(",")) {
            width[i] = Math.min(this.maxWidth, Math.max(this.minWidth, Double.parseDouble(widthSplit)));
            ++i;
        }
        i = 0;
        for (String heightSplit : heightAttribute.split(",")) {
            height[i] = Math.min(this.maxHeight, Math.max(this.minHeight, Double.parseDouble(heightSplit)));
            ++i;
        }
        this.width = width;
        this.height = height;
        super.init();
    }

    @Override
    public boolean isMovable(int mouseX, int mouseY) {
        return !this.mouseOverHorizontal && !this.mouseOverVertical;
    }

    @Override
    @Deprecated
    public void draw(int x, int y, int rightX) {
        this.draw((double)x, (double)y, (double)rightX);
    }

    @Override
    public void draw(double x, double y, double rightX) {
        boolean isMovable;
        boolean hasOverlistedModule = this.getListedAfter() != null && Module.getLastDrawnDisplayType() != EnumDisplayType.ESCAPE;
        boolean hasUnderlistedModule = Module.getModulesByOverlistedModules().containsKey(this.getName()) && Module.getLastDrawnDisplayType() != EnumDisplayType.ESCAPE;
        double firstOffset = 0.0;
        double secondOffset = hasUnderlistedModule ? 4.0 : 0.0;
        double moduleWidth = this.getWidth();
        double moduleHeight = this.getHeight();
        double mouseX = Module.getCurrentModuleGui() == null ? 0.0 : Module.getCurrentModuleGui().getMouseX();
        double mouseY = Module.getCurrentModuleGui() == null ? 0.0 : Module.getCurrentModuleGui().getMouseY();
        double mouseXRelative = mouseX - x;
        double mouseYRelative = mouseY - y;
        this.drawModule(x, y + firstOffset, rightX, moduleWidth, moduleHeight - secondOffset, mouseXRelative, mouseYRelative);
        ModuleGui moduleGui = Module.getCurrentModuleGui();
        if (moduleGui == null) {
            return;
        }
        mouseX = moduleGui.getMouseX();
        mouseY = moduleGui.getMouseY();
        boolean bl = isMovable = !hasOverlistedModule && !hasUnderlistedModule;
        if (Module.getCurrentModuleGui() != null && Module.getCurrentModuleGui().isMovableModules() && mouseY > y && mouseY < y + this.getHeight() && (!this.moving && mouseX > x - 5.0 && mouseX < x || !this.moving && mouseX > x + this.getWidth() && mouseX < x + this.getWidth() + 5.0 || this.moving && this.mouseOverHorizontal)) {
            if ((this.minWidth != this.maxWidth || this.minWidth != this.defaultWidth) && Module.getCurrentModuleGui().isMovableModules()) {
                LabyModCore.getMinecraft().getFontRenderer().a("|||", (int)(mouseX - 2.0), (int)(mouseY - 2.0), 0xFFFFFF);
                this.mouseOverHorizontal = true;
                this.mouseOverVertical = false;
            }
            if (!this.moving) {
                this.mouseOverFirst = mouseX < x && !hasOverlistedModule;
            }
            return;
        }
        if (isMovable && mouseX > x && mouseX < x + this.getWidth() && (!this.moving && mouseY > y - 5.0 && mouseY < y || !this.moving && mouseY > y + this.getHeight() && mouseY < y + this.getHeight() + 5.0 || this.moving && !this.mouseOverHorizontal)) {
            if ((this.minHeight != this.maxHeight || this.minHeight != this.defaultHeight) && Module.getCurrentModuleGui().isMovableModules()) {
                LabyModCore.getMinecraft().getFontRenderer().a("==", (int)(mouseX - 5.0), (int)(mouseY - 3.0), 0xFFFFFF);
                this.mouseOverHorizontal = false;
                this.mouseOverVertical = true;
            }
            if (!this.moving) {
                this.mouseOverFirst = mouseY < y && !hasOverlistedModule;
            }
            return;
        }
        if (!this.moving) {
            this.mouseOverHorizontal = false;
            this.mouseOverVertical = false;
            this.mouseOverFirst = false;
        }
    }

    @Deprecated
    public void drawModule(int x, int y, int rightX, int width, int height, int mouseX, int mouseY) {
    }

    public void drawModule(double x, double y, double rightX, double width, double height, double mouseX, double mouseY) {
        this.drawModule((int)Math.round(x), (int)Math.round(y), (int)Math.round(rightX), (int)Math.round(width), (int)Math.round(height), (int)Math.round(mouseX), (int)Math.round(mouseY));
    }

    @Override
    public void initModuleGui(ModuleGui moduleGui) {
        if (!moduleGui.isMovableModules()) {
            return;
        }
        if (!moduleGui.getMouseClickListeners().contains(this.mouseClickListener)) {
            moduleGui.getMouseClickListeners().add(this.mouseClickListener);
            moduleGui.getMouseMoveListeners().add(this.mouseMoveListener);
            moduleGui.getMouseReleaseListeners().add(this.mouseReleaseListener);
        }
    }

    @Override
    public double getHeight() {
        boolean hasUnderlistedModule = Module.getModulesByOverlistedModules().containsKey(this.getName()) && Module.getLastDrawnDisplayType() != EnumDisplayType.ESCAPE;
        return (short)this.height[Module.getLastDrawnDisplayType().ordinal()] + (hasUnderlistedModule ? 4 : 0);
    }

    @Override
    protected int getSpacing() {
        return 0;
    }

    @Override
    public double getWidth() {
        return (short)this.width[Module.getLastDrawnDisplayType().ordinal()];
    }

    @Override
    public void onResize(double width, double height, double prevWidth, double prevHeight) {
        double newRightX;
        double newX;
        double marginRight;
        double marginLeft;
        boolean updateHeight;
        if (!this.isEnabled(EnumDisplayType.ESCAPE)) {
            return;
        }
        boolean changedConfig = false;
        EnumModuleRegion region = this.getRegion(EnumDisplayType.ESCAPE.ordinal());
        double x = region.getMinecraftX(this.getX(EnumDisplayType.ESCAPE.ordinal()), 0.0, prevWidth);
        double y = region.getMinecraftY(this.getY(EnumDisplayType.ESCAPE.ordinal()), 0.0, prevHeight);
        x = this.isRightBound(EnumDisplayType.ESCAPE) ? x - this.width[EnumDisplayType.ESCAPE.ordinal()] : x;
        double rightX = x + this.width[EnumDisplayType.ESCAPE.ordinal()];
        double prevMaxY = y + this.height[EnumDisplayType.ESCAPE.ordinal()];
        double leftButton = prevWidth / 2.0 - 100.0;
        double rightButton = prevWidth / 2.0 + 100.0;
        if (x >= leftButton && x <= rightButton) {
            return;
        }
        double newPart = (width / 2.0 - 100.0) / 100.0;
        boolean bl = updateHeight = prevWidth != width && (x < leftButton && rightX < leftButton || x > rightButton);
        if (prevWidth != width && x < leftButton && rightX < leftButton) {
            marginLeft = 100.0 / leftButton * x;
            marginRight = 100.0 / leftButton * (leftButton - rightX);
            newX = newPart * marginLeft;
            this.setX(EnumDisplayType.ESCAPE.ordinal(), region.getOffsetX(newX, 0.0, width));
            newRightX = width / 2.0 - 100.0 - newPart * marginRight;
            this.width[EnumDisplayType.ESCAPE.ordinal()] = Math.max(this.minWidth, newRightX - newX);
            this.setAttribute("width", this.getStringByArray(this.width));
            this.getModuleConfigElement().setAttributes(this.getAttributes());
            this.getModuleConfigElement().setX(EnumDisplayType.ESCAPE.ordinal(), newX);
            changedConfig = true;
        } else if (prevWidth != width && x > rightButton) {
            marginLeft = 100.0 / leftButton * (x - rightButton);
            marginRight = 100.0 / leftButton * (prevWidth - rightX);
            newX = width / 2.0 + 100.0 + newPart * marginLeft;
            newRightX = width - newPart * marginRight;
            double newWidth = Math.max(this.minWidth, newRightX - newX);
            this.setX(EnumDisplayType.ESCAPE.ordinal(), region.getOffsetX(this.isRightBound(EnumDisplayType.ESCAPE) ? newRightX : newX, 0.0, width));
            this.width[EnumDisplayType.ESCAPE.ordinal()] = newWidth;
            this.setAttribute("width", this.getStringByArray(this.width));
            this.getModuleConfigElement().setAttributes(this.getAttributes());
            this.getModuleConfigElement().setX(EnumDisplayType.ESCAPE.ordinal(), this.getX(EnumDisplayType.ESCAPE.ordinal()));
            changedConfig = true;
        }
        if (prevHeight != height && updateHeight) {
            newPart = height / 100.0;
            double marginTop = 100.0 / prevHeight * y;
            double marginBottom = 100.0 / prevHeight * (prevHeight - prevMaxY);
            double newY = newPart * marginTop;
            double maxY = height - newPart * marginBottom;
            this.setY(EnumDisplayType.ESCAPE.ordinal(), region.getOffsetY(newY, 0.0, height));
            this.height[EnumDisplayType.ESCAPE.ordinal()] = Math.min(this.maxHeight, Math.max(this.minWidth, maxY - newY));
            this.setAttribute("height", this.getStringByArray(this.height));
            this.getModuleConfigElement().setAttributes(this.getAttributes());
            this.getModuleConfigElement().setY(EnumDisplayType.ESCAPE.ordinal(), this.getY(EnumDisplayType.ESCAPE.ordinal()));
            changedConfig = true;
        }
        if (changedConfig) {
            ModuleConfig.getConfigManager().save();
        }
    }

    public void debugModuleSize() {
        System.out.println("[Module Debug] " + this.width + " " + this.height);
    }

    public String getStringByArray(double[] array) {
        String returned = "";
        for (double element : array) {
            returned = returned + (returned.equals("") ? "" : ",") + element;
        }
        return returned;
    }

    public boolean isMoving() {
        return this.moving;
    }
}

