/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.ingamegui.moduletypes;

import java.util.List;
import net.labymod.core.LabyModCore;
import net.labymod.ingamegui.Module;
import net.labymod.ingamegui.ModuleConfig;
import net.labymod.ingamegui.enums.EnumItemSlot;
import net.labymod.main.LabyMod;
import net.labymod.main.lang.LanguageManager;
import net.labymod.settings.DefaultElementsCreator;
import net.labymod.settings.elements.SettingsElement;

public abstract class ItemModule
extends Module {
    public DurabilityVisibility visibility = DurabilityVisibility.DEFAULT;
    private EnumItemSlot itemSlot;
    private jy placeHolderTexture = null;

    @Override
    public void init() {
        super.init();
        this.visibility = DurabilityVisibility.valueOf(this.getAttribute("visibility", this.visibility.name()));
        try {
            this.itemSlot = EnumItemSlot.values()[Integer.parseInt(this.getAttribute("itemSlot", "0"))];
        }
        catch (Exception ex) {
            this.itemSlot = EnumItemSlot.NONE;
        }
        if (this.getModuleConfigElement().isUsingExtendedSettings()) {
            this.padding = this.getAttributes().containsKey("padding") ? Integer.parseInt(this.getAttributes().get("padding")) : 0;
            this.backgroundVisible = this.getAttributes().containsKey("backgroundVisible") ? Boolean.parseBoolean(this.getAttributes().get("backgroundVisible")) : false;
            this.backgroundTransparency = this.getAttributes().containsKey("backgroundTransparency") ? Integer.parseInt(this.getAttributes().get("backgroundTransparency")) : 50;
            this.backgroundColor = this.getAttributes().containsKey("backgroundColor") ? Integer.parseInt(this.getAttributes().get("backgroundColor")) : Integer.MIN_VALUE;
        }
    }

    @Override
    public void draw(double x, double y, double rightX) {
        this.draw(x, y, rightX, null);
    }

    public void draw(double x, double y, double rightX, EnumItemSlot itemSlot) {
        DurabilityVisibility.DurabilityBuilder durabilityBuilder;
        boolean extended;
        double padding = this.itemSlot == EnumItemSlot.NONE ? (double)this.padding : 0.0;
        double width = this.getRawWidth() + this.scaleModuleSize(padding * 2.0, true);
        double height = this.getRawHeight() + this.scaleModuleSize(padding * 2.0, true);
        if (this.itemSlot != EnumItemSlot.NONE) {
            this.applyScale(false);
            x = this.scaleModuleSize(x, false);
            y = this.scaleModuleSize(y, false);
            bfl.b((double)(width / 2.0), (double)(height / 2.0), (double)0.0);
            this.applyScale(true);
            x = this.scaleModuleSize(x, true);
            y = this.scaleModuleSize(y, true);
            x -= width / 2.0;
            y -= height / 2.0;
        }
        if (!(extended = this.getModuleConfigElement().isUsingExtendedSettings())) {
            this.padding = ModuleConfig.getConfig().getPadding();
            this.backgroundVisible = ModuleConfig.getConfig().isBackgroundVisible();
            this.backgroundTransparency = ModuleConfig.getConfig().getBackgroundTransparency();
        }
        if (this.backgroundVisible) {
            int color = extended ? this.backgroundColor : ModuleConfig.getConfig().getBackgroundColor();
            int red = 0xFF & color >> 16;
            int blue = 0xFF & color >> 0;
            int green = 0xFF & color >> 8;
            LabyMod.getInstance().getDrawUtils().drawRect(x, y, x + width, y + height, this.backgroundTransparency << 24 | red << 16 | green << 8 | blue);
        }
        double paddingSize = this.scaleModuleSize(padding, true);
        zx item = this.getItem();
        if (item == null) {
            jy textureLocation = this.placeHolderTexture == null ? (this.placeHolderTexture = this.getPlaceholderTexture()) : this.placeHolderTexture;
            ave.A().P().a(textureLocation);
            LabyMod.getInstance().getDrawUtils().drawTexture(x + paddingSize, y + paddingSize, 256.0, 256.0, 16.0, 16.0, 0.7f);
        } else {
            bfl.j();
            LabyMod.getInstance().getDrawUtils().drawItem(item, x + paddingSize, y + paddingSize, null);
            bfl.i();
        }
        DurabilityVisibility visibility = this.visibility;
        if (visibility == DurabilityVisibility.DEFAULT || !this.getModuleConfigElement().isUsingExtendedSettings()) {
            visibility = ModuleConfig.getConfig().getDefaultDurabilityVisibility();
        }
        if (!this.drawDurability()) {
            visibility = DurabilityVisibility.OFF;
        }
        if ((item == null || item.j() != 0) && visibility != DurabilityVisibility.OFF && visibility != DurabilityVisibility.DEFAULT && (durabilityBuilder = visibility.getDurabilityBuilder()) != null) {
            if ((itemSlot == null || itemSlot == EnumItemSlot.NONE) && rightX != -1.0 || itemSlot != null && itemSlot != EnumItemSlot.NONE && itemSlot.isRightbound()) {
                LabyMod.getInstance().getDrawUtils().drawRightString(durabilityBuilder.build(item), x - 5.0, y + height / 2.0 - 2.0);
            } else {
                String text = durabilityBuilder.build(item);
                LabyMod.getInstance().getDrawUtils().drawString(text, x + width + 5.0, y + height / 2.0 - padding);
            }
        }
    }

    protected zx getItemInArmorSlot(int slot) {
        zx itemStack = LabyModCore.getMinecraft().getPlayer().bi.e(slot);
        if (itemStack == null) {
            return null;
        }
        if (zw.b((zw)itemStack.b()) == 0) {
            return null;
        }
        return itemStack;
    }

    @Override
    public String getDescription() {
        return "";
    }

    public abstract jy getPlaceholderTexture();

    public abstract zx getItem();

    @Override
    public void settingUpdated(boolean enabled) {
        super.settingUpdated(enabled);
        if (!enabled) {
            this.setItemSlot(EnumItemSlot.NONE);
        }
    }

    @Override
    public void fillSubSettings(List<SettingsElement> settingsElements) {
        super.fillSubSettings(settingsElements);
        DefaultElementsCreator.createDurability(this, false, settingsElements);
        DefaultElementsCreator.createBackgroundVisible(this, false, settingsElements);
        DefaultElementsCreator.createPadding(this, false, settingsElements);
    }

    @Override
    public double getWidth() {
        if (this.itemSlot != EnumItemSlot.NONE) {
            return this.getRawWidth();
        }
        return this.scaleModuleSize(this.getRawWidth(), false) + (double)(this.padding * 2);
    }

    @Override
    public double getHeight() {
        if (this.itemSlot != EnumItemSlot.NONE) {
            return this.getRawHeight();
        }
        return this.scaleModuleSize(this.getRawHeight(), false) + (double)(this.padding * 2);
    }

    public double getRawWidth() {
        return 16.0;
    }

    public double getRawHeight() {
        return 16.0;
    }

    @Override
    public boolean supportsRescale() {
        return true;
    }

    @Override
    protected int getSpacing() {
        return 0;
    }

    public abstract boolean drawDurability();

    public EnumItemSlot getItemSlot() {
        return this.itemSlot;
    }

    public void setItemSlot(EnumItemSlot itemSlot) {
        this.itemSlot = itemSlot;
    }

    public static enum DurabilityVisibility {
        DEFAULT(true, "durability_default", null),
        OFF(true, "durability_off", null),
        DURABILITY_ONLY(true, "durability_only", new DurabilityBuilder(){

            @Override
            public String build(zx itemStack) {
                return itemStack == null ? "0" : String.valueOf(itemStack.j() - itemStack.h());
            }
        }),
        DURABILITY_MAX(true, "durability_max", new DurabilityBuilder(){

            @Override
            public String build(zx itemStack) {
                return itemStack == null ? "0/0" : itemStack.j() - itemStack.h() + "/" + itemStack.j();
            }
        }),
        PERCENT(true, "durability_percent", new DurabilityBuilder(){

            @Override
            public String build(zx itemStack) {
                return itemStack == null ? "0%" : Math.round(100.0 / (double)itemStack.j() * (double)(itemStack.j() - itemStack.h())) + "%";
            }
        });

        private boolean translate;
        private String name;
        private DurabilityBuilder durabilityBuilder;

        private DurabilityVisibility(boolean translate, String name, DurabilityBuilder durabilityBuilder) {
            this.translate = translate;
            this.name = name;
            this.durabilityBuilder = durabilityBuilder;
        }

        public String getDisplayName() {
            if (this.translate) {
                return LanguageManager.translate(this.name);
            }
            return this.name;
        }

        public DurabilityBuilder getDurabilityBuilder() {
            return this.durabilityBuilder;
        }

        public static interface DurabilityBuilder {
            public String build(zx var1);
        }
    }
}

