/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.ingamegui.moduletypes;

import java.util.Collections;
import java.util.List;
import net.labymod.core.LabyModCore;
import net.labymod.ingamegui.Module;
import net.labymod.ingamegui.ModuleConfig;
import net.labymod.main.LabyMod;
import net.labymod.utils.ModColor;

public abstract class ColoredTextModule
extends Module {
    private static final byte TEXT_HEIGHT = 10;

    public abstract List<List<Text>> getTexts();

    public abstract int getLines();

    @Override
    public void init() {
        super.init();
        if (this.getModuleConfigElement().isUsingExtendedSettings()) {
            this.padding = this.getAttributes().containsKey("padding") ? Integer.parseInt(this.getAttributes().get("padding")) : 0;
            this.backgroundVisible = this.getAttributes().containsKey("backgroundVisible") ? Boolean.parseBoolean(this.getAttributes().get("backgroundVisible")) : false;
            this.backgroundTransparency = this.getAttributes().containsKey("backgroundTransparency") ? Integer.parseInt(this.getAttributes().get("backgroundTransparency")) : 50;
            this.backgroundColor = this.getAttributes().containsKey("backgroundColor") ? Integer.parseInt(this.getAttributes().get("backgroundColor")) : Integer.MIN_VALUE;
        }
    }

    @Override
    public void draw(double x, double y, double rightX) {
        List<List<Text>> allLines = this.getTexts();
        if (allLines == null) {
            return;
        }
        if (!this.getModuleConfigElement().isUsingExtendedSettings()) {
            this.padding = ModuleConfig.getConfig().getPadding();
            this.backgroundVisible = ModuleConfig.getConfig().isBackgroundVisible();
            if (this.backgroundVisible) {
                this.backgroundTransparency = ModuleConfig.getConfig().getBackgroundTransparency();
            }
        }
        if (this.backgroundVisible) {
            int color = this.backgroundColor;
            if (!this.getModuleConfigElement().isUsingExtendedSettings()) {
                color = ModuleConfig.getConfig().getBackgroundColor();
            }
            int red = 0xFF & color >> 16;
            int blue = 0xFF & color >> 0;
            int green = 0xFF & color >> 8;
            color = this.backgroundTransparency << 24 | red << 16 | green << 8 | blue;
            double width = this.getRawWidth() + this.scaleModuleSize((float)this.padding * 2.0f, true);
            double height = this.getRawHeight() + this.scaleModuleSize((float)this.padding * 2.0f, true);
            LabyMod.getInstance().getDrawUtils().drawRect(x - 1.0, y - 1.0, x + width + 1.0, y + height - 1.0, color);
        }
        double paddingSize = this.scaleModuleSize(this.padding, true);
        ColoredTextModule.drawTexts(allLines, x + paddingSize, y + paddingSize, rightX);
    }

    @Override
    public double getHeight() {
        return this.scaleModuleSize(this.getRawHeight(), false) + (double)((float)this.padding * 2.0f);
    }

    public double getRawHeight() {
        return this.getLines() * 10;
    }

    @Override
    protected int getSpacing() {
        return 0;
    }

    @Override
    public double getWidth() {
        return this.scaleModuleSize(this.getRawWidth(), false) + (double)((float)this.padding * 2.0f);
    }

    public double getRawWidth() {
        double highestWidth = 0.0;
        List<List<Text>> allLines = this.getTexts();
        if (allLines == null) {
            return 0.0;
        }
        for (List<Text> texts : allLines) {
            double lineWidth = 0.0;
            for (Text text : texts) {
                double stringWidth = LabyModCore.getMinecraft().getFontRenderer().a(text.getText());
                lineWidth += stringWidth;
            }
            if (!(lineWidth > highestWidth)) continue;
            highestWidth = lineWidth;
        }
        return highestWidth;
    }

    @Override
    public boolean supportsRescale() {
        return true;
    }

    public static void drawTexts(List<List<Text>> allLines, double x, double y, double rightX) {
        boolean rightBound = rightX != -1.0;
        double finalX = x;
        avn fontRenderer = LabyModCore.getMinecraft().getFontRenderer();
        for (List<Text> texts : allLines) {
            x = rightBound ? rightX : finalX;
            if (rightBound) {
                Collections.reverse(texts);
            }
            for (Text text : texts) {
                int stringWidth = fontRenderer.a(text.getText());
                if (rightBound) {
                    x -= (double)stringWidth;
                }
                LabyMod.getInstance().getDrawUtils().drawStringWithShadow(text.getText(), x, y, text.getColor());
                if (rightBound) continue;
                x += (double)stringWidth;
            }
            y += 10.0;
        }
    }

    public static class Text {
        private String text;
        private int color;

        public Text(String text, int color) {
            this.text = text;
            this.color = color;
        }

        public Text(String text, int color, boolean bold, boolean italic, boolean underline) {
            if (bold) {
                text = ModColor.cl('l') + text;
            }
            if (italic) {
                text = ModColor.cl('o') + text;
            }
            if (underline) {
                text = ModColor.cl('n') + text;
            }
            this.text = text;
            this.color = color;
        }

        public static Text getText(String text) {
            return new Text(text, 0xFFFFFF);
        }

        public static Text getText(String text, int color) {
            return new Text(text, color);
        }

        public static Text getText(String text, int r, int g2, int b2) {
            return Text.getText(text, ModColor.toRGB(r, g2, b2, 255));
        }

        public static Text getText(String text, int r, int g2, int b2, int a2) {
            return Text.getText(text, ModColor.toRGB(r, g2, b2, a2));
        }

        public boolean isDefaultColor() {
            return this.color == 0xFFFFFF;
        }

        public String getText() {
            return this.text;
        }

        public int getColor() {
            return this.color;
        }

        public void setText(String text) {
            this.text = text;
        }

        public void setColor(int color) {
            this.color = color;
        }
    }
}

