/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.ingamegui.modules;

import java.text.DecimalFormat;
import java.util.List;
import net.labymod.core.LabyModCore;
import net.labymod.ingamegui.ModuleCategory;
import net.labymod.ingamegui.ModuleCategoryRegistry;
import net.labymod.ingamegui.enums.EnumDisplayType;
import net.labymod.ingamegui.moduletypes.SimpleModule;
import net.labymod.settings.elements.BooleanElement;
import net.labymod.settings.elements.ControlElement;
import net.labymod.settings.elements.SettingsElement;
import net.labymod.utils.Material;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class SpeedModule
extends SimpleModule {
    private DecimalFormat df = new DecimalFormat("#.##");
    private long lastPositionUpdate;
    private double lastPositionX;
    private double lastPositionY;
    private double lastPositionZ;
    private double speed;
    private boolean displayAtZeroSpeed;

    @Override
    public String getDisplayName() {
        return "Speed";
    }

    @Override
    public String getDisplayValue() {
        return String.valueOf(this.df.format(this.speed) + " blocks/s");
    }

    @Override
    public boolean isShown() {
        return this.displayAtZeroSpeed || this.speed != 0.0;
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (LabyModCore.getMinecraft().getPlayer() == null) {
            return;
        }
        if (!this.isEnabled(EnumDisplayType.INGAME)) {
            return;
        }
        if (this.lastPositionUpdate + 1000L < System.currentTimeMillis()) {
            this.lastPositionUpdate = System.currentTimeMillis();
            bew entity = LabyModCore.getMinecraft().getPlayer();
            double d0 = this.lastPositionX - entity.s;
            double d1 = this.lastPositionY - entity.t;
            double d2 = this.lastPositionZ - entity.u;
            this.speed = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
            this.lastPositionX = entity.s;
            this.lastPositionY = entity.t;
            this.lastPositionZ = entity.u;
        }
    }

    @Override
    public void loadSettings() {
        this.displayAtZeroSpeed = Boolean.valueOf(this.getAttribute("displayAtZeroSpeed", "false"));
    }

    @Override
    public void fillSubSettings(List<SettingsElement> settingsElements) {
        super.fillSubSettings(settingsElements);
        settingsElements.add(new BooleanElement(this, new ControlElement.IconData(Material.EYE_OF_ENDER), "Visible at zero speed", "displayAtZeroSpeed"));
    }

    @Override
    public String getDefaultValue() {
        return "?";
    }

    @Override
    public ControlElement.IconData getIconData() {
        return this.getModuleIcon(this.getSettingName());
    }

    @Override
    public String getSettingName() {
        return "speed";
    }

    @Override
    public String getDescription() {
        return "Shows your current walking speed in the following unit: blocks per second";
    }

    @Override
    public int getSortingId() {
        return 12;
    }

    @Override
    public ModuleCategory getCategory() {
        return ModuleCategoryRegistry.CATEGORY_INFO;
    }
}

