/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.ingamegui.modules;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.labymod.ingamegui.ModuleCategory;
import net.labymod.ingamegui.ModuleCategoryRegistry;
import net.labymod.ingamegui.moduletypes.ColoredTextModule;
import net.labymod.ingamegui.moduletypes.TextModule;
import net.labymod.main.LabyMod;
import net.labymod.servermanager.Server;
import net.labymod.settings.elements.BooleanElement;
import net.labymod.settings.elements.ControlElement;
import net.labymod.settings.elements.SettingsElement;
import net.labymod.utils.Material;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class ServerSupportModule
extends TextModule {
    private List<Server.DisplayLine> lines = new ArrayList<Server.DisplayLine>();
    private boolean showKills;

    @Override
    public String[] getKeys() {
        ArrayList<String> list = new ArrayList<String>();
        for (Server.DisplayLine line : this.lines) {
            list.add(line.getKey());
        }
        String[] array = new String[list.size()];
        list.toArray(array);
        return array;
    }

    @Override
    public List<List<ColoredTextModule.Text>> getTextValues() {
        ArrayList<List<ColoredTextModule.Text>> list = new ArrayList<List<ColoredTextModule.Text>>();
        for (Server.DisplayLine line : this.lines) {
            for (ColoredTextModule.Text word : line.getValues()) {
                if (!word.isDefaultColor()) continue;
                word.setColor(this.valueColor);
            }
            list.add(line.getValues());
        }
        return list;
    }

    @Override
    public String[] getDefaultKeys() {
        return new String[]{"Server Support"};
    }

    @Override
    public List<List<ColoredTextModule.Text>> getDefaultTextValues() {
        return Collections.singletonList(Collections.singletonList(ColoredTextModule.Text.getText("No server found", -1)));
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Server currentServer = LabyMod.getInstance().getServerManager().getCurrentServer();
        if (currentServer == null && !this.lines.isEmpty()) {
            this.lines.clear();
        } else if (currentServer != null) {
            ArrayList<Server.DisplayLine> lines = new ArrayList<Server.DisplayLine>();
            currentServer.addModuleLines(lines);
            this.lines = lines;
        }
    }

    @Override
    public boolean isShown() {
        return !this.lines.isEmpty();
    }

    @Override
    public void loadSettings() {
        this.showKills = Boolean.valueOf(this.getAttribute("kills", "true"));
    }

    @Override
    public void fillSubSettings(List<SettingsElement> settingsElements) {
        super.fillSubSettings(settingsElements);
        settingsElements.add(new BooleanElement(this, new ControlElement.IconData(Material.IRON_SWORD), "Show Kills", "kills"));
    }

    @Override
    public ControlElement.IconData getIconData() {
        return this.getModuleIcon(this.getSettingName());
    }

    @Override
    public String getSettingName() {
        return "server_support";
    }

    @Override
    public String getDescription() {
        return "";
    }

    @Override
    public int getSortingId() {
        return 10;
    }

    @Override
    public ModuleCategory getCategory() {
        return ModuleCategoryRegistry.CATEGORY_INFO;
    }

    public boolean isShowKills() {
        return this.showKills;
    }
}

