/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.ingamegui.modules;

import java.util.List;
import net.labymod.core.LabyModCore;
import net.labymod.ingamegui.moduletypes.SimpleModule;
import net.labymod.settings.elements.ControlElement;
import net.labymod.settings.elements.NumberElement;
import net.labymod.settings.elements.SettingsElement;
import net.labymod.utils.Material;
import net.labymod.utils.ModColor;
import net.labymod.utils.ModUtils;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class LavaTimerModule
extends SimpleModule {
    private long lavaTimerStarted = 0L;
    private long lavaTimerFadeOut = 0L;
    private int lastTimerSeconds = 0;
    private int fadeOutSeconds;

    @Override
    public String getDisplayName() {
        return "Burning Timer";
    }

    @Override
    public String getDisplayValue() {
        int seconds = (int)(System.currentTimeMillis() - this.lavaTimerStarted) / 1000;
        if (this.lastTimerSeconds != 0) {
            seconds = this.lastTimerSeconds;
        }
        return (this.lastTimerSeconds == 0 ? "" : ModColor.cl("c")) + ModUtils.parseTimer(seconds);
    }

    @Override
    public String getDefaultValue() {
        return "00:00";
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (LabyModCore.getMinecraft().getWorld() == null || LabyModCore.getMinecraft().getPlayer() == null) {
            return;
        }
        boolean inLava = LabyModCore.getMinecraft().getPlayer().at();
        if (inLava && this.lavaTimerStarted == 0L) {
            this.lastTimerSeconds = 0;
            this.lavaTimerStarted = System.currentTimeMillis();
        } else if (this.lavaTimerStarted != 0L && !inLava) {
            this.lastTimerSeconds = (int)(System.currentTimeMillis() - this.lavaTimerStarted) / 1000;
            this.lavaTimerStarted = 0L;
            this.lavaTimerFadeOut = System.currentTimeMillis() + (long)(1000 * this.fadeOutSeconds);
        }
    }

    @Override
    public void loadSettings() {
        this.fadeOutSeconds = Integer.valueOf(this.getAttribute("fadeout", "3"));
    }

    @Override
    public void fillSubSettings(List<SettingsElement> settingsElements) {
        super.fillSubSettings(settingsElements);
        settingsElements.add(new NumberElement(this, new ControlElement.IconData(Material.LAVA_BUCKET), "Fadeout time in seconds", "fadeout").setMaxValue(10));
    }

    @Override
    public ControlElement.IconData getIconData() {
        return this.getModuleIcon(this.getSettingName());
    }

    @Override
    public String getSettingName() {
        return "lava_challenge_timer";
    }

    @Override
    public String getDescription() {
        return "";
    }

    @Override
    public int getSortingId() {
        return 0;
    }

    @Override
    public boolean isShown() {
        return LabyModCore.getMinecraft().getWorld() != null && LabyModCore.getMinecraft().getPlayer() != null && (this.lavaTimerStarted != 0L || this.lavaTimerFadeOut > System.currentTimeMillis());
    }
}

