/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.ingamegui.modules;

import java.util.List;
import net.labymod.ingamegui.ModuleCategory;
import net.labymod.ingamegui.ModuleCategoryRegistry;
import net.labymod.ingamegui.moduletypes.SimpleModule;
import net.labymod.settings.elements.BooleanElement;
import net.labymod.settings.elements.ControlElement;
import net.labymod.settings.elements.SettingsElement;
import net.labymod.utils.Consumer;
import net.labymod.utils.Material;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class FPSModule
extends SimpleModule {
    private int smoothFPS = 0;
    private boolean displaySmoothFPS = true;

    @Override
    public String getDisplayName() {
        return "FPS";
    }

    @Override
    public String getDisplayValue() {
        return String.valueOf(this.displaySmoothFPS && this.smoothFPS != 0 ? this.smoothFPS : ave.ai());
    }

    @Override
    public String getDefaultValue() {
        return "?";
    }

    @SubscribeEvent
    public void onRenderGameOverlay(RenderGameOverlayEvent event) {
        if (!this.displaySmoothFPS) {
            return;
        }
        int fps = ave.ai();
        if (this.smoothFPS == fps) {
            return;
        }
        if (this.smoothFPS == 0) {
            this.smoothFPS = fps;
        } else {
            int factor = Math.abs(fps - this.smoothFPS) > 50 ? 50 : 1;
            this.smoothFPS = fps > this.smoothFPS ? this.smoothFPS + factor : this.smoothFPS - factor;
        }
    }

    @Override
    public void loadSettings() {
    }

    @Override
    public void init() {
        super.init();
        this.displaySmoothFPS = Boolean.valueOf(this.getAttribute("smoothFPS", "true"));
    }

    @Override
    public void fillSubSettings(List<SettingsElement> settingsElements) {
        super.fillSubSettings(settingsElements);
        settingsElements.add(new BooleanElement(this, new ControlElement.IconData(Material.SLIME_BALL), "Smooth FPS", "smoothFPS").addCallback(new Consumer<Boolean>(){

            @Override
            public void accept(Boolean accepted) {
                FPSModule.this.setAttribute("smoothFPS", String.valueOf(accepted));
                FPSModule.this.init();
            }
        }));
    }

    @Override
    public ControlElement.IconData getIconData() {
        return this.getModuleIcon(this.getSettingName());
    }

    @Override
    public String getSettingName() {
        return "fps";
    }

    @Override
    public String getDescription() {
        return "";
    }

    @Override
    public ModuleCategory getCategory() {
        return ModuleCategoryRegistry.CATEGORY_INFO;
    }

    @Override
    public int getSortingId() {
        return 0;
    }
}

