/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.ingamegui.enums;

import net.labymod.ingamegui.Module;

public enum EnumModuleRegion {
    BOTTOM_LEFT(3, 1),
    BOTTOM_CENTER(3, 2),
    BOTTOM_RIGHT(3, 3),
    TOP_LEFT(1, 1),
    TOP_CENTER(1, 2),
    TOP_RIGHT(1, 3),
    CENTER_LEFT(2, 1),
    CENTER(2, 2),
    CENTER_RIGHT(2, 3);

    public static final double DISPLAY_PART = 100.0;
    private byte horizontalPosition;
    private byte verticalPosition;

    private EnumModuleRegion(int verticalPosition, int horizontalPosition) {
        this.horizontalPosition = (byte)horizontalPosition;
        this.verticalPosition = (byte)verticalPosition;
    }

    public byte getHorizontalPosition() {
        return this.horizontalPosition;
    }

    public byte getVerticalPosition() {
        return this.verticalPosition;
    }

    public boolean isInArea(double x, double y, double left, double right, double top, double bottom) {
        double minX = this.getMinX(left, right);
        double maxX = this.getMaxX(left, right);
        double minY = this.getMinY(top, bottom);
        double maxY = this.getMaxY(top, bottom);
        boolean returned = x >= minX && x <= maxX && y >= minY && y <= maxY;
        return returned;
    }

    public double getPointX(double left, double right) {
        if (Module.getLastDrawnDisplayType().isEscapeRegions()) {
            double pos = -1.0;
            if (this.horizontalPosition == 1) {
                pos = (right - left) / 2.0 - 150.0 + left;
            }
            if (this.horizontalPosition == 3) {
                pos = (right - left) / 2.0 + 150.0 + left;
            }
            if (pos != -1.0) {
                return pos;
            }
        }
        double width = right - left;
        int pos = this.horizontalPosition == 1 ? 1 : (this.horizontalPosition == 2 ? 3 : 5);
        return (int)(left + width / 6.0 * (double)pos);
    }

    public double getPointY(double top, double bottom) {
        if (Module.getLastDrawnDisplayType().isEscapeRegions()) {
            return (bottom - top) / 4.0 + 48.0 + top;
        }
        double height = bottom - top;
        double pos = this.verticalPosition == 1 ? 1.0 : (this.verticalPosition == 2 ? 3.0 : 5.0);
        return top + height / 6.0 * pos;
    }

    public double getMinecraftX(double offsetX, double left, double right) {
        return this.getBoundingPoint(true, left, right) + offsetX;
    }

    public double getMinecraftY(double offsetY, double top, double bottom) {
        return this.getBoundingPoint(false, top, bottom) + offsetY;
    }

    public double getOffsetX(double x, double left, double right) {
        return x - this.getBoundingPoint(true, left, right);
    }

    public double getOffsetY(double y, double top, double bottom) {
        return y - this.getBoundingPoint(false, top, bottom);
    }

    private double getBoundingPoint(boolean horizontal, double first, double second) {
        byte pos;
        double point = 0.0;
        byte by = pos = horizontal ? this.horizontalPosition : this.verticalPosition;
        if (pos == 1) {
            point = first;
        }
        if (pos == 2) {
            double d = point = horizontal ? this.getPointX(first, second) : this.getPointY(first, second);
        }
        if (pos == 3) {
            point = second;
        }
        if (!horizontal && Module.getLastDrawnDisplayType().isEscapeRegions()) {
            point = CENTER.getPointY(first, second);
        }
        return point;
    }

    public double getMinX(double left, double right) {
        boolean flag;
        if (Module.getLastDrawnDisplayType().isEscapeRegions()) {
            if (this.horizontalPosition == 2) {
                return (right - left) / 2.0 - 150.0 + left;
            }
            if (this.horizontalPosition == 3) {
                return (right - left) / 2.0 + 150.0 + left;
            }
            return left;
        }
        double middle = left + (right - left) / 2.0;
        double middleSize = 150.0;
        double protection = 10.0;
        boolean bl = flag = middle - middleSize < protection + Module.getLastLeft();
        if (this.horizontalPosition == 2) {
            return flag ? left + protection : middle - middleSize;
        }
        if (this.horizontalPosition == 3) {
            return flag ? right - protection : middle + middleSize;
        }
        return left;
    }

    public double getMinY(double top, double bottom) {
        if (Module.getLastDrawnDisplayType().isEscapeRegions()) {
            return 0.0;
        }
        return top + (bottom - top) / 3.0 * ((double)this.verticalPosition - 1.0);
    }

    public double getMaxX(double left, double right) {
        boolean flag;
        if (Module.getLastDrawnDisplayType().isEscapeRegions()) {
            if (this.horizontalPosition == 1) {
                return (right - left) / 2.0 - 150.0 + left;
            }
            if (this.horizontalPosition == 2) {
                return (right - left) / 2.0 + 150.0 + left;
            }
            return right;
        }
        double middle = left + (right - left) / 2.0;
        double middleSize = 150.0;
        double protection = 10.0;
        boolean bl = flag = middle - middleSize < protection + Module.getLastLeft();
        if (this.horizontalPosition == 2) {
            return flag ? right - protection : middle + middleSize;
        }
        if (this.horizontalPosition == 3) {
            return right;
        }
        return flag ? left + protection : middle - middleSize;
    }

    public double getMaxY(double top, double bottom) {
        if (Module.getLastDrawnDisplayType().isEscapeRegions()) {
            return bottom;
        }
        double height = (bottom - top) / 3.0;
        return top + height * (double)this.verticalPosition;
    }
}

