/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.ingamegui.enums;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.labymod.ingamegui.ModuleConfig;
import net.labymod.ingamegui.moduletypes.ColoredTextModule;

public enum EnumModuleFormatting {
    DEFAULT("DEFAULT", "", "", "", ""),
    COLON("K: V", "", ": ", " :", ""),
    BRACKETS("K> V", "", "> ", "<", ""),
    SQUARE_BRACKETS("[K] V", "[", "] ", " [", "]"),
    HYPHEN("K - V", "", " - ", " - ", "");

    private String format;
    private String beforeKey;
    private String afterKey;
    private String rightBeforeKey;
    private String rightAfterKey;

    private EnumModuleFormatting(String format, String beforeKey, String afterKey, String rightBeforeKey, String rightAfterKey) {
        this.format = format;
        this.beforeKey = beforeKey;
        this.afterKey = afterKey;
        this.rightBeforeKey = rightBeforeKey;
        this.rightAfterKey = rightAfterKey;
    }

    public String toString() {
        return this.format;
    }

    public void draw(int x, int y, String key, List<ColoredTextModule.Text> value, int bracketsColor, int prefixColor, int valueColor, boolean bold, boolean italic, boolean underline) {
        if (this == DEFAULT) {
            return;
        }
        ColoredTextModule.drawTexts(Arrays.asList(this.getTexts(key, value, bracketsColor, prefixColor, valueColor, true, bold, italic, underline)), x, y, -1.0);
    }

    public List<ColoredTextModule.Text> getTexts(String key, List<ColoredTextModule.Text> value, int bracketsColor, int prefixColor, int valueColor, boolean showKey, boolean bold, boolean italic, boolean underline) {
        ArrayList<ColoredTextModule.Text> texts = new ArrayList<ColoredTextModule.Text>();
        if (bracketsColor == -1) {
            bracketsColor = ModuleConfig.getConfig().getBracketsColor();
        }
        if (prefixColor == -1) {
            prefixColor = ModuleConfig.getConfig().getPrefixColor();
        }
        if (valueColor == -1) {
            valueColor = ModuleConfig.getConfig().getValuesColor();
        }
        if (!this.beforeKey.isEmpty() && showKey) {
            texts.add(new ColoredTextModule.Text(this.beforeKey, bracketsColor, bold, italic, underline));
        }
        if (showKey) {
            texts.add(new ColoredTextModule.Text(key, prefixColor, bold, italic, underline));
        }
        if (!this.afterKey.isEmpty() && showKey) {
            texts.add(new ColoredTextModule.Text(this.afterKey, bracketsColor, bold, italic, underline));
        }
        for (ColoredTextModule.Text valueElement : value) {
            texts.add(new ColoredTextModule.Text(valueElement.getText(), valueElement.getColor() == -1 ? valueColor : valueElement.getColor(), bold, italic, underline));
        }
        return texts;
    }

    public String getRawText(String key, String value) {
        return this.beforeKey + key + this.afterKey + value;
    }
}

