/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.ingamegui;

import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.labymod.ingamegui.Module;
import net.labymod.ingamegui.ModuleConfig;
import net.labymod.ingamegui.ModuleConfigElement;
import net.labymod.ingamegui.enums.EnumDisplayType;
import net.labymod.ingamegui.enums.EnumItemSlot;
import net.labymod.ingamegui.enums.EnumModuleAlignment;
import net.labymod.ingamegui.enums.EnumModuleRegion;
import net.labymod.ingamegui.modules.ScoreboardModule;
import net.labymod.ingamegui.moduletypes.ItemModule;
import net.labymod.ingamegui.moduletypes.ResizeableModule;
import net.labymod.main.LabyMod;
import net.labymod.utils.Consumer;
import net.labymod.utils.DrawUtils;
import net.labymod.utils.ModColor;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class ModuleGui
extends axu {
    public static final List<ModuleGui> INSTANCES = new ArrayList<ModuleGui>();
    private static final int ALIGNMENT_COLOR = new Color(246, 255, 0).getRGB();
    private Module draggingModule;
    private Module selectedModule;
    private boolean hoveringCenterX = false;
    private boolean hoveringCenterY = false;
    private boolean canDrag = false;
    private double mouseMoveX = 0.0;
    private double mouseMoveY = 0.0;
    private boolean placeOver;
    private double mouseX;
    private double mouseY;
    private List<CoordinatesConsumer> mouseClickListeners = new ArrayList<CoordinatesConsumer>();
    private List<CoordinatesConsumer> mouseMoveListeners = new ArrayList<CoordinatesConsumer>();
    private List<CoordinatesConsumer> mouseScrollListeners = new ArrayList<CoordinatesConsumer>();
    private List<CoordinatesConsumer> mouseReleaseListeners = new ArrayList<CoordinatesConsumer>();
    private List<KeyConsumer> keyTypeListeners = new ArrayList<KeyConsumer>();
    private List<Consumer<Module>> doubleClickModuleListeners = new ArrayList<Consumer<Module>>();
    private List<Consumer<Module>> clickModuleListeners = new ArrayList<Consumer<Module>>();
    private boolean movableModules;
    private boolean showAllModules;
    private Set<EnumItemSlot> usedItemSlots = new HashSet<EnumItemSlot>();
    private EnumItemSlot nearestItemSlot = null;
    private int nearestScoreboardSlot = -1;
    private Module focusedModule;
    private Module lastClickedModule;
    private long lastClicked;
    private EnumDisplayType displayType;
    private boolean clicking = false;

    public ModuleGui(boolean movableModules, boolean showAllModules, EnumDisplayType displayType) {
        this.movableModules = movableModules;
        this.showAllModules = showAllModules;
        this.displayType = displayType;
        for (Module module : Module.getModules()) {
            module.initModuleGui(this);
        }
        INSTANCES.add(this);
    }

    public void setDisplayType(EnumDisplayType displayType) {
        this.displayType = displayType;
    }

    public void b() {
        super.b();
        this.j = ave.A();
        this.draggingModule = null;
    }

    public void a(int mouseXInt, int mouseYInt, float partialTicks) {
        Module focusedModule;
        double scale;
        if (!ModuleConfig.getConfig().isModulesEnabled()) {
            return;
        }
        double mouseX = mouseXInt;
        double mouseY = mouseYInt;
        double d = scale = this.displayType.isScaling() ? 2.0 - (double)ModuleConfig.getConfig().getGuiScale() / 100.0 : 1.0;
        if (this.displayType.isScaling() && scale != 1.0) {
            mouseX *= scale;
            mouseY *= scale;
        }
        boolean mouseIsMoving = this.mouseX != mouseX || this.mouseY != mouseY;
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        double lastLeft = Module.getLastLeft() / scale;
        double lastTop = Module.getLastTop() / scale;
        double lastRight = Module.getLastRight() / scale;
        double lastBottom = Module.getLastBottom() / scale;
        boolean isCtrlDown = Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157);
        this.nearestScoreboardSlot = -1;
        if (this.draggingModule != null && this.canDrag && !isCtrlDown) {
            double height;
            double width;
            EnumModuleRegion region = this.draggingModule.getRegion(this.displayType.ordinal());
            double minX = region.getMinX(Module.getLastLeft(), Module.getLastRight()) / scale;
            double maxX = region.getMaxX(Module.getLastLeft(), Module.getLastRight()) / scale;
            double minY = region.getMinY(Module.getLastTop(), Module.getLastBottom()) / scale;
            double maxY = region.getMaxY(Module.getLastTop(), Module.getLastBottom()) / scale;
            avp.a((int)((int)(minX + 1.0)), (int)((int)(minY + 1.0)), (int)((int)(maxX - 1.0)), (int)((int)(maxY - 1.0)), (int)ModColor.toRGB(255, 255, 255, 26));
            if (this.draggingModule instanceof ItemModule && !Module.getModulesByOverlistedModules().containsKey(this.draggingModule.getName())) {
                width = lastRight - lastLeft;
                height = lastBottom - lastTop;
                EnumItemSlot nearestSlot = null;
                double nearestDistance = 2.147483647E9;
                for (EnumItemSlot itemSlot : EnumItemSlot.values()) {
                    if (itemSlot == EnumItemSlot.NONE || this.usedItemSlots.contains((Object)itemSlot)) continue;
                    double x = itemSlot.getX(width) + lastLeft;
                    double y = itemSlot.getY(height) + lastTop;
                    double distance = Math.min(Math.abs((double)mouseXInt - x) + Math.abs((double)mouseYInt - y), Math.abs((double)mouseXInt - (x + 15.0)) + Math.abs((double)mouseYInt - (y + 15.0)));
                    if (nearestSlot == null || distance < nearestDistance) {
                        nearestSlot = itemSlot;
                        nearestDistance = distance;
                    }
                    avp.a((int)((int)x), (int)((int)y), (int)((int)(x + 15.0)), (int)((int)(y + 15.0)), (int)ModColor.toRGB(255, 255, 255, 100));
                }
                if (nearestDistance < 20.0 && nearestSlot != null) {
                    double x = nearestSlot.getX(width) + lastLeft;
                    double y = nearestSlot.getY(height) + lastTop;
                    avp.a((int)((int)x), (int)((int)y), (int)((int)(x + 15.0)), (int)((int)(y + 15.0)), (int)ModColor.toRGB(255, 255, 0, 50));
                    this.nearestItemSlot = nearestSlot;
                } else {
                    this.nearestItemSlot = null;
                }
            } else {
                this.nearestItemSlot = null;
            }
            if (this.draggingModule instanceof ScoreboardModule && !Module.getModulesByOverlistedModules().containsKey(this.draggingModule.getName())) {
                width = lastRight - lastLeft;
                height = lastBottom - lastTop;
                double slotX = lastLeft + (width - this.draggingModule.getWidth() / scale - 1.0);
                double slotY = lastTop + (height / 2.0 - this.draggingModule.getHeight() / scale / 2.0);
                LabyMod.getInstance().getDrawUtils().drawRect(slotX, slotY, slotX + this.draggingModule.getWidth() / scale, slotY + this.draggingModule.getHeight() / scale, ModColor.toRGB(255, 255, 255, 100));
                if (mouseX / scale > slotX && mouseX / scale < slotX + this.draggingModule.getWidth() / scale && mouseY / scale > slotY && mouseY / scale < slotY + this.draggingModule.getHeight() / scale) {
                    this.nearestScoreboardSlot = 0;
                }
                slotX = lastLeft + 1.0;
                LabyMod.getInstance().getDrawUtils().drawRect(slotX, slotY, slotX + this.draggingModule.getWidth() / scale, slotY + this.draggingModule.getHeight() / scale, ModColor.toRGB(255, 255, 255, 100));
                if (mouseX / scale > slotX && mouseX / scale < slotX + this.draggingModule.getWidth() / scale && mouseY / scale > slotY && mouseY / scale < slotY + this.draggingModule.getHeight() / scale) {
                    this.nearestScoreboardSlot = 1;
                }
            }
        } else {
            this.nearestItemSlot = null;
        }
        boolean skipDistanceLine = false;
        if (!isCtrlDown) {
            if (this.draggingModule != null && this.selectedModule != null) {
                double y = this.selectedModule.getLastY() + this.selectedModule.getHeight();
                if (this.draggingModule.getLastY() < this.selectedModule.getLastY()) {
                    y = this.selectedModule.getLastY();
                    this.placeOver = true;
                } else {
                    this.placeOver = false;
                }
                LabyMod.getInstance().getDrawUtils().drawRect(this.selectedModule.getLastX() / scale - 5.0, y / scale - 0.8, this.selectedModule.getLastX() / scale + this.selectedModule.getWidth() / scale + 5.0, y / scale, ALIGNMENT_COLOR);
                skipDistanceLine = true;
            } else {
                double center;
                if (this.hoveringCenterX && this.draggingModule != null) {
                    center = lastLeft + (lastRight - lastLeft) / 2.0;
                    LabyMod.getInstance().getDrawUtils().drawRect(center - 0.4, Module.getLastTop() / scale, center + 0.4, Module.getLastBottom() / scale, ALIGNMENT_COLOR);
                    skipDistanceLine = true;
                }
                if (this.hoveringCenterY && this.draggingModule != null) {
                    center = lastTop + (lastBottom - lastTop) / 2.0;
                    LabyMod.getInstance().getDrawUtils().drawRect(Module.getLastLeft() / scale, center - 0.4, Module.getLastRight() / scale, center + 0.4, ALIGNMENT_COLOR);
                    skipDistanceLine = true;
                }
            }
        } else {
            this.selectedModule = null;
        }
        if (this.draggingModule != null && !isCtrlDown) {
            double tX = this.draggingModule.getX(this.displayType.ordinal());
            double tY = this.draggingModule.getY(this.displayType.ordinal());
            EnumModuleRegion region = this.draggingModule.getRegion(this.displayType.ordinal());
            if ((region == EnumModuleRegion.BOTTOM_LEFT || region == EnumModuleRegion.CENTER_LEFT || region == EnumModuleRegion.TOP_LEFT) && tX < 2.0) {
                LabyMod.getInstance().getDrawUtils().drawRect(Module.getLastLeft() / scale + 2.0, Module.getLastTop() / scale + 2.0, Module.getLastLeft() / scale + 2.0 + 1.0, Module.getLastBottom() / scale - 2.0, ALIGNMENT_COLOR);
            }
            if ((region == EnumModuleRegion.TOP_LEFT || region == EnumModuleRegion.TOP_CENTER || region == EnumModuleRegion.TOP_RIGHT) && tY < 2.0) {
                LabyMod.getInstance().getDrawUtils().drawRect(Module.getLastLeft() / scale + 2.0, Module.getLastTop() / scale + 2.0, Module.getLastRight() / scale - 2.0, Module.getLastTop() / scale + 2.0 + 1.0, ALIGNMENT_COLOR);
            }
            if ((region == EnumModuleRegion.BOTTOM_RIGHT || region == EnumModuleRegion.CENTER_RIGHT || region == EnumModuleRegion.TOP_RIGHT) && tX > -2.0) {
                LabyMod.getInstance().getDrawUtils().drawRect(Module.getLastRight() / scale - 2.0 - 1.0, Module.getLastTop() / scale + 2.0, Module.getLastRight() / scale - 2.0, Module.getLastBottom() / scale - 2.0, ALIGNMENT_COLOR);
            }
        }
        if (this.focusedModule != null && this.focusedModule.isEnabled(this.displayType)) {
            boolean isInScoreboardSlot;
            DrawUtils draw = LabyMod.getInstance().getDrawUtils();
            focusedModule = this.focusedModule;
            boolean hasUnderlistedModule = focusedModule instanceof ResizeableModule && Module.getModulesByOverlistedModules().containsKey(focusedModule.getName()) && Module.getLastDrawnDisplayType() != EnumDisplayType.ESCAPE;
            double firstOffset = 0.0;
            double secondOffset = hasUnderlistedModule ? 4.0 : 0.0;
            double mX = focusedModule.getLastX() / scale - 1.0;
            double mY = focusedModule.getLastY() / scale - 1.0 + firstOffset;
            double mWidth = focusedModule.getWidth() / scale + 2.0;
            double mHeight = focusedModule.getHeight() / scale + 2.0 - secondOffset;
            boolean isInItemSlot = focusedModule instanceof ItemModule && ((ItemModule)focusedModule).getItemSlot() != null && ((ItemModule)focusedModule).getItemSlot() != EnumItemSlot.NONE;
            boolean bl = isInScoreboardSlot = focusedModule instanceof ScoreboardModule && ((ScoreboardModule)focusedModule).getSlot() != -1;
            if (!isInItemSlot && !isInScoreboardSlot) {
                draw.drawRectBorder(mX, mY, mX + mWidth, mY + mHeight, ModColor.toRGB(255, 255, 255, 56), 1.0);
            }
        }
        if (this.focusedModule != null && this.focusedModule.isEnabled(this.displayType)) {
            DrawUtils draw = LabyMod.getInstance().getDrawUtils();
            focusedModule = this.focusedModule;
            if (this.displayType == EnumDisplayType.ESCAPE && this.draggingModule == focusedModule) {
                double middleX = (Module.getLastRight() - Module.getLastLeft()) / 2.0 + Module.getLastLeft();
                double middleY = (Module.getLastBottom() - Module.getLastTop()) / 2.0 + Module.getLastTop();
                double moduleMiddleX = focusedModule.getLastX() + focusedModule.getWidth() / 2.0;
                double moduleMiddleY = focusedModule.getLastY() + focusedModule.getHeight() / 2.0;
                if (!skipDistanceLine) {
                    bfl.l();
                    bfl.x();
                    GL11.glLineWidth((float)1.5f);
                    GL11.glColor3f((float)1.0f, (float)1.0f, (float)0.0f);
                    GL11.glBegin((int)1);
                    GL11.glVertex3d((double)middleX, (double)middleY, (double)0.0);
                    GL11.glVertex3d((double)moduleMiddleX, (double)moduleMiddleY, (double)0.0);
                    GL11.glEnd();
                    bfl.k();
                    bfl.w();
                }
                double distance = Math.sqrt(Math.pow(moduleMiddleX - middleX, 2.0) + Math.pow(moduleMiddleY - middleY, 2.0));
                draw.drawString(ModColor.cl('e') + (int)distance + " px", middleX + (moduleMiddleX - middleX) / 2.0 + 4.0, middleY + (moduleMiddleY - middleY) / 2.0);
            }
        }
        if (this.clicking && mouseIsMoving) {
            this.a(mouseXInt, mouseYInt, 0, 0L);
        }
    }

    public void a(int mouseXInt, int mouseYInt, int mouseButton) throws IOException {
        super.a(mouseXInt, mouseYInt, mouseButton);
        this.clicking = true;
        if (!ModuleConfig.getConfig().isModulesEnabled()) {
            return;
        }
        if (this.draggingModule != null) {
            return;
        }
        if (this.movableModules) {
            this.usedItemSlots.clear();
            for (Module module : Module.getModules()) {
                if (!module.isEnabled(this.displayType) || !(module instanceof ItemModule) || ((ItemModule)module).getItemSlot() == null || ((ItemModule)module).getItemSlot() == EnumItemSlot.NONE) continue;
                this.usedItemSlots.add(((ItemModule)module).getItemSlot());
            }
        }
        for (Module module : Module.getModules()) {
            double scale;
            boolean isShown;
            boolean bl = isShown = (module.isShown() || Module.getCurrentModuleGui() != null && Module.getCurrentModuleGui().isShowAllModules()) && module.getCategory().isEnabled();
            if (!module.isEnabled(this.displayType) || !isShown) continue;
            double mouseX = mouseXInt;
            double mouseY = mouseYInt;
            boolean isItemSlot = module instanceof ItemModule && ((ItemModule)module).getItemSlot() != EnumItemSlot.NONE;
            boolean isScoreboardSlot = module instanceof ScoreboardModule && ((ScoreboardModule)module).getSlot() != -1;
            double x = module.getLastX();
            double y = module.getLastY();
            double d = scale = this.displayType.isScaling() ? 2.0 - (double)ModuleConfig.getConfig().getGuiScale() / 100.0 : 1.0;
            if (isItemSlot) {
                ItemModule itemModule = (ItemModule)module;
                EnumItemSlot itemSlot = itemModule.getItemSlot();
                x = Module.getLastLeft() / scale + itemSlot.getX(Module.getLastRight() / scale - Module.getLastLeft() / scale);
                y = Module.getLastTop() / scale + itemSlot.getY(Module.getLastBottom() / scale - Module.getLastTop() / scale);
                if (mouseX < x || mouseX > x + module.getWidth() || mouseY < y || mouseY > y + module.getHeight()) continue;
                if (!module.isMovable((int)mouseX, (int)mouseY)) {
                    module.onMouseClick((int)mouseX, (int)mouseY, mouseButton);
                    continue;
                }
            } else if (isScoreboardSlot) {
                ScoreboardModule scoreboardModule = (ScoreboardModule)module;
                int slot = scoreboardModule.getSlot();
                switch (slot) {
                    case 0: {
                        x = Module.getLastRight() / scale - module.getWidth() - 1.0;
                        y = Module.getLastTop() / scale + (Module.getLastBottom() / scale - Module.getLastTop() / scale) / 2.0 - module.getHeight() / 2.0;
                        break;
                    }
                    case 1: {
                        x = Module.getLastLeft() / scale + 1.0;
                        y = Module.getLastTop() / scale + (Module.getLastBottom() / scale - Module.getLastTop() / scale) / 2.0 - module.getHeight() / 2.0;
                    }
                }
                if (mouseX < x || mouseX > x + module.getWidth() || mouseY < y || mouseY > y + module.getHeight()) continue;
                if (!module.isMovable((int)mouseX, (int)mouseY)) {
                    module.onMouseClick((int)mouseX, (int)mouseY, mouseButton);
                    continue;
                }
            } else {
                if ((mouseX *= scale) < x || mouseX > x + module.getWidth() || (mouseY *= scale) < y || mouseY > y + module.getHeight()) continue;
                if (!module.isMovable((int)mouseX, (int)mouseY)) {
                    module.onMouseClick((int)mouseX, (int)mouseY, mouseButton);
                    continue;
                }
            }
            if (this.movableModules) {
                long curr = System.currentTimeMillis();
                if (this.lastClickedModule != null && this.lastClickedModule.equals(module) && curr - this.lastClicked < 200L) {
                    for (Consumer<Module> doubleClickListener : this.doubleClickModuleListeners) {
                        doubleClickListener.accept(this.lastClickedModule);
                    }
                    this.lastClickedModule = null;
                    this.lastClicked = curr;
                } else {
                    this.lastClickedModule = module;
                    this.lastClicked = curr;
                }
                this.draggingModule = module;
                this.canDrag = false;
                this.mouseMoveX = !module.isRightBound(this.displayType) ? mouseX - x : mouseX - (x + module.getWidth());
                this.mouseMoveY = mouseY - y;
                for (Consumer<Module> listener : this.clickModuleListeners) {
                    listener.accept(module);
                }
            }
            return;
        }
        for (CoordinatesConsumer listener : this.mouseClickListeners) {
            listener.accept((int)this.mouseX, (int)this.mouseY, mouseButton, this.displayType);
        }
    }

    public void k() throws IOException {
        double scale;
        if (this.displayType.isScaling() && (scale = 2.0 - (double)ModuleConfig.getConfig().getGuiScale() / 100.0) != 1.0) {
            this.mouseX *= scale;
            this.mouseY *= scale;
        }
        for (CoordinatesConsumer listener : this.mouseScrollListeners) {
            listener.accept((int)this.mouseX, (int)this.mouseY, 0, this.displayType);
        }
        for (Module module : Module.getModules()) {
            module.onMouseScroll((int)this.mouseX, (int)this.mouseY);
        }
    }

    public void a(char typedChar, int keyCode) throws IOException {
        super.a(typedChar, keyCode);
        for (KeyConsumer listener : this.keyTypeListeners) {
            listener.accept(typedChar, keyCode);
        }
        for (Module module : Module.getModules()) {
            boolean isShown;
            boolean bl = isShown = (module.isShown() || Module.getCurrentModuleGui() != null && Module.getCurrentModuleGui().isShowAllModules()) && module.getCategory().isEnabled();
            if (!module.isEnabled(this.displayType) || !isShown) continue;
            module.onKeyType(typedChar, keyCode);
        }
    }

    public void a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        EnumModuleRegion newRegion;
        boolean isRightBound;
        double newX;
        boolean crtlDown;
        double scale;
        super.a(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
        if (this.displayType.isScaling() && (scale = 2.0 - (double)ModuleConfig.getConfig().getGuiScale() / 100.0) != 1.0) {
            mouseX = (int)((double)mouseX * scale);
            mouseY = (int)((double)mouseY * scale);
        }
        if (!ModuleConfig.getConfig().isModulesEnabled()) {
            return;
        }
        if (this.draggingModule == null) {
            for (CoordinatesConsumer listener : this.mouseMoveListeners) {
                listener.accept(mouseX, mouseY, clickedMouseButton, this.displayType);
            }
            for (Module module : Module.getModules()) {
                boolean isShown;
                boolean bl = isShown = (module.isShown() || Module.getCurrentModuleGui() != null && Module.getCurrentModuleGui().isShowAllModules()) && module.getCategory().isEnabled();
                if (!module.isEnabled(this.displayType) || !isShown) continue;
                double x = module.getLastX();
                double y = module.getLastY();
                if ((double)mouseX < x || (double)mouseX > x + module.getWidth() || (double)mouseY < y || (double)mouseY > y + module.getHeight() || module.isMovable(mouseX, mouseY)) continue;
                module.onMouseMove(mouseX, mouseY, clickedMouseButton);
            }
            return;
        }
        if (!this.canDrag) {
            int slot;
            EnumItemSlot itemSlot;
            this.canDrag = true;
            if (this.draggingModule instanceof ItemModule && (itemSlot = ((ItemModule)this.draggingModule).getItemSlot()) != null && itemSlot != EnumItemSlot.NONE) {
                this.usedItemSlots.remove((Object)itemSlot);
                ((ItemModule)this.draggingModule).setItemSlot(EnumItemSlot.NONE);
                this.draggingModule.setAttribute("itemSlot", String.valueOf("0"));
            }
            if (this.draggingModule instanceof ScoreboardModule && (slot = ((ScoreboardModule)this.draggingModule).getSlot()) != -1) {
                ((ScoreboardModule)this.draggingModule).setSlot(-1);
                this.draggingModule.setAttribute("slot", String.valueOf("-1"));
            }
        }
        boolean gridEnabled = ModuleConfig.getConfig().isGridEnabled();
        boolean shiftDown = Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
        boolean altDown = Keyboard.isKeyDown((int)56) || Keyboard.isKeyDown((int)184);
        boolean bl = crtlDown = Keyboard.isKeyDown((int)29) && !Keyboard.isKeyDown((int)157);
        if (shiftDown && altDown) {
            shiftDown = false;
            altDown = false;
        }
        double d = !gridEnabled && !altDown ? (double)mouseX - this.mouseMoveX : (newX = gridEnabled ? (double)(Math.round(((double)mouseX - this.mouseMoveX) / 5.0) * 5L) : this.draggingModule.getX(this.displayType.ordinal()));
        double newY = !gridEnabled && !shiftDown ? (double)mouseY - this.mouseMoveY : (gridEnabled ? (double)(Math.round(((double)mouseY - this.mouseMoveY) / 5.0) * 5L) : this.draggingModule.getY(this.displayType.ordinal()));
        Module bottomModule = this.draggingModule;
        double currentY = newY + bottomModule.getHeight();
        double stackHeight = currentY - newY;
        double maxWidth = bottomModule.getWidth();
        if (this.displayType == EnumDisplayType.INGAME) {
            while (Module.getModulesByOverlistedModules().containsKey(bottomModule.getName())) {
                bottomModule = Module.getModulesByOverlistedModules().get(bottomModule.getName());
                double width = bottomModule.getWidth();
                if (width > maxWidth) {
                    maxWidth = width;
                }
                double height = bottomModule.getHeight();
                currentY += height;
                stackHeight += height;
            }
        }
        if (newY < Module.getLastTop()) {
            newY = Module.getLastTop();
        }
        if (currentY > Module.getLastBottom()) {
            currentY = Module.getLastBottom();
            newY = Module.getLastBottom() - stackHeight;
        }
        if (newX < Module.getLastLeft()) {
            newX = Module.getLastLeft();
        }
        double d2 = (isRightBound = this.draggingModule.isRightBound(this.displayType)) ? 0.0 : maxWidth;
        if (newX + d2 > Module.getLastRight()) {
            newX = Module.getLastRight() - (!isRightBound ? maxWidth : 0.0);
        }
        if (isRightBound && newX - maxWidth < Module.getLastLeft()) {
            newX = Module.getLastLeft() + maxWidth;
        }
        if ((newRegion = this.getRegion(mouseX, mouseY)) != null && newRegion != this.draggingModule.getRegion(this.displayType.ordinal())) {
            this.draggingModule.setRegion(this.displayType.ordinal(), newRegion);
        }
        double x = this.draggingModule.getRegion(this.displayType.ordinal()).getOffsetX(newX, Module.getLastLeft(), Module.getLastRight());
        double y = this.draggingModule.getRegion(this.displayType.ordinal()).getOffsetY(newY, Module.getLastTop(), Module.getLastBottom());
        if (this.draggingModule != null) {
            if (Module.getLastDrawnDisplayType() != EnumDisplayType.ESCAPE && this.draggingModule.getListedAfter() != null && this.draggingModule.getModuleConfigElement() != null) {
                EnumModuleAlignment enumModuleAlignment;
                ModuleConfigElement moduleConfigElement;
                Module module = Module.getModuleByName(this.draggingModule.getListedAfter());
                if (module != null && (moduleConfigElement = module.getModuleConfigElement()) != null && (enumModuleAlignment = moduleConfigElement.getAlignment(this.displayType.ordinal())) != null) {
                    this.draggingModule.getModuleConfigElement().setAlignment(this.displayType.ordinal(), enumModuleAlignment);
                }
                Module.getModulesByOverlistedModules().remove(this.draggingModule.getListedAfter());
                this.draggingModule.setListedAfter(null);
            } else if (this.displayType.isAttachableModules()) {
                ArrayList<Module> possibleModules = new ArrayList<Module>();
                HashSet<Module> impossibleModules = new HashSet<Module>();
                Module theModule = this.draggingModule;
                while ((theModule = Module.getModulesByOverlistedModules().get(theModule.getName())) != null) {
                    impossibleModules.add(theModule);
                }
                for (Module module : Module.getModules()) {
                    boolean possible;
                    boolean isShown;
                    if (module == this.draggingModule || impossibleModules.contains(module) || module instanceof ItemModule && ((ItemModule)module).getItemSlot() != null && ((ItemModule)module).getItemSlot() != EnumItemSlot.NONE) continue;
                    boolean bl2 = isShown = (module.isShown() || Module.getCurrentModuleGui() != null && Module.getCurrentModuleGui().isShowAllModules()) && module.getCategory() != null;
                    if (!module.isEnabled(this.displayType) || !isShown || module.getListedAfter() != null && module.getListedAfter().equals(this.draggingModule.getName())) continue;
                    if (module.getListedAfter() == null && newY > module.getLastY() - 15.0 && newY < module.getLastY() && newX > module.getLastX() - 10.0 && newX < module.getLastX() + module.getWidth() + 10.0) {
                        possibleModules.add(module);
                        continue;
                    }
                    boolean bl3 = possible = newY > module.getLastY() && newY < module.getLastY() + module.getHeight() + 10.0 && (double)mouseX > module.getLastX() && (double)mouseX - module.getWidth() / 2.0 < module.getLastX() + module.getWidth() / 2.0;
                    if (!possible) continue;
                    possibleModules.add(module);
                }
                final double finalNewY = newY;
                Collections.sort(possibleModules, new Comparator<Module>(){

                    @Override
                    public int compare(Module o1, Module o2) {
                        return Integer.valueOf((int)Math.abs(o2.getLastY() - finalNewY)).compareTo((int)Math.abs(o1.getLastY() - finalNewY));
                    }
                });
                if (possibleModules.size() == 0) {
                    this.selectedModule = null;
                } else if (!crtlDown) {
                    this.selectedModule = (Module)possibleModules.get(0);
                }
            }
        }
        this.hoveringCenterX = this.draggingModule != null && this.selectedModule == null && this.displayType.isAttachableCenter() && Math.abs(this.draggingModule.getLastX() + this.draggingModule.getWidth() / 2.0 - (Module.getLastLeft() + (Module.getLastRight() - Module.getLastLeft()) / 2.0)) < 5.0;
        boolean bl4 = this.hoveringCenterY = this.draggingModule != null && this.selectedModule == null && this.displayType.isAttachableCenter() && Math.abs(this.draggingModule.getLastY() + this.draggingModule.getHeight() / 2.0 - (Module.getLastTop() + (Module.getLastBottom() - Module.getLastTop()) / 2.0)) < 5.0;
        if (!altDown) {
            this.draggingModule.setX(this.displayType.ordinal(), x);
        } else {
            double d3 = this.mouseMoveX = !this.draggingModule.isRightBound(this.displayType) ? (double)mouseX - this.draggingModule.getLastX() : (double)mouseX - (this.draggingModule.getLastX() + this.draggingModule.getWidth());
        }
        if (!shiftDown) {
            this.draggingModule.setY(this.displayType.ordinal(), y);
        } else {
            this.mouseMoveY = (double)mouseY - this.draggingModule.getLastY();
        }
        boolean newRightBoundState = this.draggingModule.isRightBound(this.displayType);
        if (isRightBound && !newRightBoundState) {
            this.mouseMoveX = (double)mouseX - newX + this.draggingModule.getWidth();
            this.draggingModule.setX(this.displayType.ordinal(), this.draggingModule.getRegion(this.displayType.ordinal()).getOffsetX((double)mouseX - this.mouseMoveX, Module.getLastLeft(), Module.getLastRight()));
        }
        if (!isRightBound && newRightBoundState) {
            this.mouseMoveX = (double)mouseX - newX - this.draggingModule.getWidth();
            this.draggingModule.setX(this.displayType.ordinal(), this.draggingModule.getRegion(this.displayType.ordinal()).getOffsetX((double)mouseX - this.mouseMoveX, Module.getLastLeft(), Module.getLastRight()));
        }
    }

    public void b(int mouseX, int mouseY, int state) {
        boolean isCtrlDown;
        super.b(mouseX, mouseY, state);
        this.clicking = false;
        if (!ModuleConfig.getConfig().isModulesEnabled()) {
            return;
        }
        if (this.draggingModule == null) {
            for (CoordinatesConsumer listener : this.mouseReleaseListeners) {
                listener.accept(mouseX, mouseY, state, this.displayType);
            }
            for (Module module : Module.getModules()) {
                module.onMouseRelease(mouseX, mouseY, state);
            }
            return;
        }
        if (!this.canDrag) {
            this.selectedModule = null;
            this.draggingModule = null;
            return;
        }
        boolean itemAttached = false;
        if (this.draggingModule instanceof ItemModule && this.nearestItemSlot != null && !this.usedItemSlots.contains((Object)this.nearestItemSlot)) {
            this.draggingModule.setAttribute("itemSlot", String.valueOf(this.nearestItemSlot.ordinal()));
            ((ItemModule)this.draggingModule).setItemSlot(this.nearestItemSlot);
            itemAttached = true;
        }
        if (this.draggingModule instanceof ScoreboardModule && this.nearestScoreboardSlot != -1) {
            this.draggingModule.setAttribute("slot", String.valueOf(this.nearestScoreboardSlot));
            ((ScoreboardModule)this.draggingModule).setSlot(this.nearestScoreboardSlot);
            itemAttached = true;
        }
        if (!itemAttached) {
            if (this.selectedModule != null) {
                if (!this.placeOver) {
                    this.draggingModule.setListedAfter(this.selectedModule.getName());
                    this.draggingModule.getModuleConfigElement().setAlignment(this.displayType.ordinal(), this.selectedModule.getModuleConfigElement().getAlignment(this.displayType.ordinal()));
                    if (Module.getModulesByOverlistedModules().containsKey(this.selectedModule.getName())) {
                        Module currentModule = this.draggingModule;
                        while (Module.getModulesByOverlistedModules().containsKey(currentModule.getName())) {
                            currentModule = Module.getModulesByOverlistedModules().get(currentModule.getName());
                        }
                        Module.getModulesByOverlistedModules().put(currentModule.getName(), Module.getModulesByOverlistedModules().get(this.selectedModule.getName()));
                        Module module = Module.getModulesByOverlistedModules().get(this.selectedModule.getName());
                        module.setListedAfter(currentModule.getName());
                        module.getModuleConfigElement().setListedAfter(module.getListedAfter());
                    }
                    Module.getModulesByOverlistedModules().put(this.selectedModule.getName(), this.draggingModule);
                    this.getNewCoordinates(this.selectedModule);
                } else {
                    Module currentModule = this.draggingModule;
                    while (Module.getModulesByOverlistedModules().containsKey(currentModule.getName())) {
                        currentModule = Module.getModulesByOverlistedModules().get(currentModule.getName());
                    }
                    this.selectedModule.getModuleConfigElement().setAlignment(this.displayType.ordinal(), this.draggingModule.getModuleConfigElement().getAlignment(this.displayType.ordinal()));
                    this.draggingModule.setX(this.displayType.ordinal(), this.selectedModule.getX(this.displayType.ordinal()));
                    this.draggingModule.setRegion(this.displayType.ordinal(), this.selectedModule.getRegion(this.displayType.ordinal()));
                    this.draggingModule.setY(this.displayType.ordinal(), this.selectedModule.getRegion(this.displayType.ordinal()).getOffsetY(this.draggingModule.getLastY(), Module.getLastTop(), Module.getLastBottom()));
                    this.draggingModule.setListedAfter(null);
                    this.selectedModule.setListedAfter(currentModule.getName());
                    this.selectedModule.getModuleConfigElement().setListedAfter(currentModule.getListedAfter());
                    Module.getModulesByOverlistedModules().put(currentModule.getName(), this.selectedModule);
                    this.getNewCoordinates(this.draggingModule);
                }
            } else {
                double center;
                if (this.hoveringCenterX) {
                    center = Module.getLastLeft() + (Module.getLastRight() - Module.getLastLeft()) / 2.0;
                    this.draggingModule.setRegion(this.displayType.ordinal(), Module.getLastDrawnDisplayType() == EnumDisplayType.ESCAPE ? EnumModuleRegion.CENTER : this.draggingModule.getRegion(Module.getLastDrawnDisplayType().ordinal()));
                    this.draggingModule.setX(this.displayType.ordinal(), this.draggingModule.getRegion(this.displayType.ordinal()).getOffsetX(center - this.draggingModule.getWidth() / 2.0, Module.getLastLeft(), Module.getLastRight()));
                }
                if (this.hoveringCenterY) {
                    center = Module.getLastTop() + (Module.getLastBottom() - Module.getLastTop()) / 2.0;
                    this.draggingModule.setRegion(this.displayType.ordinal(), this.draggingModule.getRegion(Module.getLastDrawnDisplayType().ordinal()));
                    this.draggingModule.setY(this.displayType.ordinal(), this.draggingModule.getRegion(this.displayType.ordinal()).getOffsetY(center - this.draggingModule.getHeight() / 2.0, Module.getLastTop(), Module.getLastBottom()));
                }
            }
        }
        double tX = this.draggingModule.getX(this.displayType.ordinal());
        double tY = this.draggingModule.getY(this.displayType.ordinal());
        boolean bl = isCtrlDown = Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157);
        if (!isCtrlDown) {
            EnumModuleRegion region = this.draggingModule.getRegion(this.displayType.ordinal());
            if ((region == EnumModuleRegion.BOTTOM_LEFT || region == EnumModuleRegion.CENTER_LEFT || region == EnumModuleRegion.TOP_LEFT) && tX < 2.0) {
                tX = 2.0;
            }
            if ((region == EnumModuleRegion.TOP_LEFT || region == EnumModuleRegion.TOP_CENTER || region == EnumModuleRegion.TOP_RIGHT) && tY < 2.0) {
                tY = 2.0;
            }
            if ((region == EnumModuleRegion.BOTTOM_RIGHT || region == EnumModuleRegion.CENTER_RIGHT || region == EnumModuleRegion.TOP_RIGHT) && tX > -2.0) {
                tX = -2.0;
            }
        }
        this.draggingModule.getModuleConfigElement().setX(this.displayType.ordinal(), tX);
        this.draggingModule.getModuleConfigElement().setY(this.displayType.ordinal(), tY);
        this.draggingModule.getModuleConfigElement().setRegion(this.displayType.ordinal(), this.draggingModule.getRegion(this.displayType.ordinal()));
        this.draggingModule.getModuleConfigElement().setListedAfter(this.draggingModule.getListedAfter());
        ModuleConfig.getConfigManager().save();
        this.selectedModule = null;
        this.draggingModule = null;
    }

    public void m() {
        this.b((int)this.mouseX, (int)this.mouseY, 0);
        this.b((int)this.mouseX, (int)this.mouseY, 1);
    }

    public void getNewCoordinates(Module module) {
        boolean shouldHaveNewX;
        Module topModule = module;
        while (topModule != null && topModule.getListedAfter() != null) {
            topModule = Module.getModuleByName(topModule.getListedAfter());
        }
        if (topModule == null) {
            return;
        }
        double currentY = topModule.getLastY();
        boolean rightbound = topModule.isRightBound(this.displayType);
        double maxY = currentY + topModule.getHeight();
        double maxX = topModule.getLastX() + (rightbound ? topModule.getWidth() : 0.0);
        double stackWidth = topModule.getWidth();
        double stackHeight = maxY - currentY;
        Module bottomModule = topModule;
        while (Module.getModulesByOverlistedModules().containsKey(bottomModule.getName())) {
            double x;
            bottomModule = Module.getModulesByOverlistedModules().get(bottomModule.getName());
            double width = bottomModule.getWidth();
            double d = x = !rightbound ? topModule.getLastX() + width : topModule.getLastX() - width;
            if (!rightbound && x > maxX || rightbound && x < maxX) {
                maxX = x;
                stackWidth = width;
            }
            double height = bottomModule.getHeight();
            maxY += height;
            stackHeight += height;
        }
        boolean bl = shouldHaveNewX = !rightbound && maxX > Module.getLastRight() || rightbound && maxX < Module.getLastLeft();
        if (maxY > Module.getLastBottom() || shouldHaveNewX) {
            double newY;
            double d = newY = maxY > Module.getLastBottom() ? Module.getLastBottom() - stackHeight : topModule.getLastY();
            double newX = shouldHaveNewX ? (!rightbound ? Module.getLastRight() - stackWidth : Module.getLastLeft() + stackWidth) : topModule.getLastX();
            EnumModuleRegion newRegion = this.getRegion(newX + topModule.getWidth() / 2.0, newY + topModule.getHeight() / 2.0);
            EnumModuleRegion oldRegion = topModule.getRegion(this.displayType.ordinal());
            if (newRegion != null && newRegion != oldRegion) {
                topModule.setRegion(this.displayType.ordinal(), newRegion);
            } else if (newRegion == null) {
                newRegion = oldRegion;
            }
            topModule.setX(this.displayType.ordinal(), newRegion.getOffsetX(newX, Module.getLastLeft(), Module.getLastRight()));
            topModule.setY(this.displayType.ordinal(), newRegion.getOffsetY(newY, Module.getLastTop(), Module.getLastBottom()));
            topModule.getModuleConfigElement().setX(this.displayType.ordinal(), topModule.getX(this.displayType.ordinal()));
            topModule.getModuleConfigElement().setY(this.displayType.ordinal(), topModule.getY(this.displayType.ordinal()));
            topModule.getModuleConfigElement().setRegion(this.displayType.ordinal(), topModule.getRegion(this.displayType.ordinal()));
        }
    }

    private EnumModuleRegion getRegion(double middleX, double middleY) {
        if (middleX < Module.getLastLeft()) {
            middleX = Module.getLastLeft();
        }
        if (middleX > Module.getLastRight()) {
            middleX = Module.getLastRight();
        }
        if (middleY < Module.getLastTop()) {
            middleY = Module.getLastTop();
        }
        if (middleY > Module.getLastBottom()) {
            middleY = Module.getLastBottom();
        }
        for (EnumModuleRegion regions : EnumModuleRegion.values()) {
            if (regions.getVerticalPosition() == 3 && regions.isInArea(middleX, middleY, Module.getLastLeft(), Module.getLastRight(), Module.getLastTop(), Module.getLastBottom())) {
                return regions;
            }
            if (!regions.isInArea(middleX, middleY, Module.getLastLeft(), Module.getLastRight(), Module.getLastTop(), Module.getLastBottom())) continue;
            return regions;
        }
        return null;
    }

    public double getMouseX() {
        return this.mouseX;
    }

    public double getMouseY() {
        return this.mouseY;
    }

    public List<CoordinatesConsumer> getMouseClickListeners() {
        return this.mouseClickListeners;
    }

    public List<CoordinatesConsumer> getMouseMoveListeners() {
        return this.mouseMoveListeners;
    }

    public List<CoordinatesConsumer> getMouseScrollListeners() {
        return this.mouseScrollListeners;
    }

    public List<CoordinatesConsumer> getMouseReleaseListeners() {
        return this.mouseReleaseListeners;
    }

    public List<KeyConsumer> getKeyTypeListeners() {
        return this.keyTypeListeners;
    }

    public List<Consumer<Module>> getDoubleClickModuleListeners() {
        return this.doubleClickModuleListeners;
    }

    public List<Consumer<Module>> getClickModuleListeners() {
        return this.clickModuleListeners;
    }

    public boolean isShowAllModules() {
        return this.showAllModules;
    }

    public boolean isMovableModules() {
        return this.movableModules;
    }

    public void setFocusedModule(Module focusedModule) {
        this.focusedModule = focusedModule;
    }

    public Module getDraggingModule() {
        return this.draggingModule;
    }

    public static interface ScalingEnabledCallback {
        public boolean get();
    }

    public static interface KeyConsumer {
        public void accept(char var1, int var2);
    }

    public static interface CoordinatesConsumer {
        public void accept(int var1, int var2, int var3, EnumDisplayType var4);
    }
}

