/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.ingamegui;

import com.google.common.base.Objects;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.labymod.ingamegui.Module;
import net.labymod.ingamegui.ModuleCategory;
import net.labymod.ingamegui.ModuleCategoryRegistry;
import net.labymod.ingamegui.ModuleConfigElement;
import net.labymod.ingamegui.ModuleGui;
import net.labymod.ingamegui.enums.EnumDisplayType;
import net.labymod.ingamegui.enums.EnumModuleAlignment;
import net.labymod.ingamegui.enums.EnumModuleFormatting;
import net.labymod.ingamegui.modules.CoordinatesModule;
import net.labymod.ingamegui.modules.FModule;
import net.labymod.ingamegui.modules.FPSModule;
import net.labymod.ingamegui.moduletypes.ItemModule;
import net.labymod.main.DefaultValues;
import net.labymod.main.Source;
import net.labymod.settings.LabyModModuleEditorGui;
import net.labymod.support.util.Debug;
import net.labymod.utils.ModUtils;
import net.labymod.utils.manager.ConfigManager;

public class ModuleConfig {
    private static final File MODULES_FILE = new File(Source.FILE_LABYMOD_FOLDER, "modules.json");
    private static final File MODULES_PROFILE_FOLDER = new File(Source.FILE_LABYMOD_FOLDER, "modules_profiles");
    public static final String SINGLEPLAYER_KEY = "singleplayer";
    private static ModuleConfig config;
    private static ConfigManager<ModuleConfig> configManager;
    public static String loadedProfile;
    private static List<Class<? extends Module>> defaultEnabledModules;
    private static Map<Class<? extends Module>, Class<? extends Module>> defaultListedAfterValues;
    private Map<String, ModuleConfigElement> modules = new HashMap<String, ModuleConfigElement>();
    private Map<String, Boolean> moduleCategories = new HashMap<String, Boolean>();
    private boolean modulesEnabled = true;
    private boolean gridEnabled = false;
    private boolean itemSlotGravity = true;
    private int guiScale = 100;
    private int prefixColor = DefaultValues.PREFIX_COLOR;
    private int bracketsColor = DefaultValues.BRACKETS_COLOR;
    private int valuesColor = DefaultValues.VALUE_COLOR;
    private int formattingBold = 0;
    private int formattingItalic = 0;
    private int formattingUnderline = 0;
    private boolean keyVisible = true;
    private boolean backgroundVisible = false;
    private int backgroundColor = DefaultValues.BACKGROUND_COLOR;
    private int backgroundTransparency = 50;
    private int padding = 0;
    private EnumModuleAlignment defaultAlignment = EnumModuleAlignment.AUTO;
    private EnumModuleFormatting defaultFormatting = DefaultValues.DEFAULT_FORMATTING;
    private ItemModule.DurabilityVisibility defaultDurabilityVisibility = DefaultValues.DEFAULT_DURABILITY_VISIBILITY;

    public static File[] listProfileFiles() {
        return MODULES_PROFILE_FOLDER.exists() ? MODULES_PROFILE_FOLDER.listFiles() : new File[]{};
    }

    public static void switchProfile(String serverIP, boolean force) {
        String profile = ModUtils.getProfileNameByIp(serverIP);
        if (Objects.equal((Object)profile, (Object)loadedProfile)) {
            return;
        }
        if (configManager != null) {
            configManager.save();
        }
        ModuleConfig.loadConfig(profile, force);
    }

    public static void deleteProfile(String profile) {
        if (profile != null && profile.equals(LabyModModuleEditorGui.SINGLEPLAYER_PROFILE)) {
            profile = SINGLEPLAYER_KEY;
        }
        configManager.getFile().delete();
        ModuleConfig.loadConfig(profile, false);
    }

    public static File getFile(String profile) {
        if (profile != null && profile.equals(LabyModModuleEditorGui.SINGLEPLAYER_PROFILE)) {
            profile = SINGLEPLAYER_KEY;
        }
        if (profile != null) {
            return new File(MODULES_PROFILE_FOLDER, profile + ".json");
        }
        return MODULES_FILE;
    }

    public static void loadConfig(String profile, boolean force) {
        if (profile != null && profile.equals(LabyModModuleEditorGui.SINGLEPLAYER_PROFILE)) {
            profile = SINGLEPLAYER_KEY;
        }
        File file = MODULES_FILE;
        if (profile != null) {
            File profileDir = MODULES_PROFILE_FOLDER;
            if (!profileDir.exists()) {
                if (force) {
                    profileDir.mkdir();
                } else {
                    profile = null;
                }
            }
            if (profile != null) {
                File profileFile = new File(profileDir, profile + ".json");
                if (profileFile.exists() || force) {
                    file = profileFile;
                } else {
                    profile = null;
                }
            }
        }
        Debug.log(Debug.EnumDebugMode.CONFIG_MANAGER, "Switched profile to " + (profile == null ? "default" : profile));
        LabyModModuleEditorGui.selectedProfile = profile;
        loadedProfile = profile;
        configManager = new ConfigManager<ModuleConfig>(file, ModuleConfig.class);
        config = configManager.getSettings();
        Module.getModulesByOverlistedModules().clear();
        for (Module module : Module.getModules()) {
            ModuleConfig.loadModule(module);
            if (module.rawBooleanElement == null) continue;
            module.createSettingElement();
        }
        ModuleCategoryRegistry.getCategories().clear();
        for (Field moduleCategoryField : ModuleCategoryRegistry.class.getDeclaredFields()) {
            if (!ModuleCategory.class.isAssignableFrom(moduleCategoryField.getType()) || !Modifier.isStatic(moduleCategoryField.getModifiers())) continue;
            try {
                ModuleCategory moduleCategory = (ModuleCategory)moduleCategoryField.get(null);
                if (moduleCategory.rawCategoryElement != null) {
                    moduleCategory.createCategoryElement();
                }
                ModuleCategoryRegistry.getCategories().add(moduleCategory);
                if (!config.getModuleCategories().containsKey(moduleCategory.getName())) {
                    config.getModuleCategories().put(moduleCategory.getName(), moduleCategory.isEnabled());
                    continue;
                }
                moduleCategory.setEnabled(config.getModuleCategories().get(moduleCategory.getName()));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        for (ModuleCategory moduleCategory : ModuleCategoryRegistry.ADDON_CATEGORY_LIST) {
            if (moduleCategory.rawCategoryElement != null) {
                moduleCategory.createCategoryElement();
            }
            ModuleCategoryRegistry.getCategories().add(moduleCategory);
            if (!config.getModuleCategories().containsKey(moduleCategory.getName())) {
                config.getModuleCategories().put(moduleCategory.getName(), moduleCategory.isEnabled());
                continue;
            }
            moduleCategory.setEnabled(config.getModuleCategories().get(moduleCategory.getName()));
        }
    }

    public static void loadModule(Module module) {
        if (config.getModules().containsKey(module.getName())) {
            ModuleConfig.loadExistingModule(module, config.getModules().get(module.getName()));
            return;
        }
        boolean contains = defaultEnabledModules.contains(module.getClass());
        ModuleConfigElement moduleConfigElement = new ModuleConfigElement(contains, defaultListedAfterValues.containsKey(module.getClass()) ? defaultListedAfterValues.get(module.getClass()).getSimpleName() : null);
        config.getModules().put(module.getName(), module.setModuleConfigElement(moduleConfigElement));
        ModuleConfig.loadExistingModule(module, module.getModuleConfigElement());
    }

    private static void loadExistingModule(Module module, ModuleConfigElement element) {
        ModuleConfigElement configElement = config.getModules().get(module.getName());
        HashSet<EnumDisplayType> enabled = new HashSet<EnumDisplayType>();
        for (EnumDisplayType type : configElement.getEnabled()) {
            boolean isValid = false;
            for (EnumDisplayType validType : module.getDisplayTypes()) {
                if (!validType.equals((Object)type)) continue;
                isValid = true;
            }
            if (!isValid) continue;
            enabled.add(type);
        }
        module.setModuleConfigElement(configElement);
        module.setRegions(configElement.getRegions());
        module.setX(configElement.getX());
        module.setY(configElement.getY());
        module.setEnabled(enabled);
        module.setListedAfter(configElement.getListedAfter());
        module.setAttributes(configElement.getAttributes());
        module.init();
        for (ModuleGui moduleGui : ModuleGui.INSTANCES) {
            module.initModuleGui(moduleGui);
        }
    }

    public static ModuleConfig getConfig() {
        return config;
    }

    public static ConfigManager<ModuleConfig> getConfigManager() {
        return configManager;
    }

    public Map<String, ModuleConfigElement> getModules() {
        return this.modules;
    }

    public boolean isModulesEnabled() {
        return this.modulesEnabled;
    }

    public void setModulesEnabled(boolean modulesEnabled) {
        this.modulesEnabled = modulesEnabled;
    }

    public void setModules(Map<String, ModuleConfigElement> modules) {
        this.modules = modules;
    }

    public Map<String, Boolean> getModuleCategories() {
        return this.moduleCategories;
    }

    public void setModuleCategories(Map<String, Boolean> moduleCategories) {
        this.moduleCategories = moduleCategories;
    }

    public boolean isGridEnabled() {
        return this.gridEnabled;
    }

    public void setGridEnabled(boolean gridEnabled) {
        this.gridEnabled = gridEnabled;
    }

    public boolean isItemSlotGravity() {
        return this.itemSlotGravity;
    }

    public void setItemSlotGravity(boolean itemSlotGravity) {
        this.itemSlotGravity = itemSlotGravity;
    }

    public int getGuiScale() {
        return this.guiScale;
    }

    public void setGuiScale(int guiScale) {
        this.guiScale = guiScale;
    }

    public int getPrefixColor() {
        return this.prefixColor;
    }

    public void setPrefixColor(int prefixColor) {
        this.prefixColor = prefixColor;
    }

    public int getBracketsColor() {
        return this.bracketsColor;
    }

    public void setBracketsColor(int bracketsColor) {
        this.bracketsColor = bracketsColor;
    }

    public int getValuesColor() {
        return this.valuesColor;
    }

    public void setValuesColor(int valuesColor) {
        this.valuesColor = valuesColor;
    }

    public int getFormattingBold() {
        return this.formattingBold;
    }

    public void setFormattingBold(int formattingBold) {
        this.formattingBold = formattingBold;
    }

    public int getFormattingItalic() {
        return this.formattingItalic;
    }

    public void setFormattingItalic(int formattingItalic) {
        this.formattingItalic = formattingItalic;
    }

    public int getFormattingUnderline() {
        return this.formattingUnderline;
    }

    public void setFormattingUnderline(int formattingUnderline) {
        this.formattingUnderline = formattingUnderline;
    }

    public boolean isKeyVisible() {
        return this.keyVisible;
    }

    public void setKeyVisible(boolean keyVisible) {
        this.keyVisible = keyVisible;
    }

    public boolean isBackgroundVisible() {
        return this.backgroundVisible;
    }

    public void setBackgroundVisible(boolean backgroundVisible) {
        this.backgroundVisible = backgroundVisible;
    }

    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(int backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public int getBackgroundTransparency() {
        return this.backgroundTransparency;
    }

    public void setBackgroundTransparency(int backgroundTransparency) {
        this.backgroundTransparency = backgroundTransparency;
    }

    public int getPadding() {
        return this.padding;
    }

    public void setPadding(int padding) {
        this.padding = padding;
    }

    public EnumModuleAlignment getDefaultAlignment() {
        return this.defaultAlignment;
    }

    public void setDefaultAlignment(EnumModuleAlignment defaultAlignment) {
        this.defaultAlignment = defaultAlignment;
    }

    public EnumModuleFormatting getDefaultFormatting() {
        return this.defaultFormatting;
    }

    public void setDefaultFormatting(EnumModuleFormatting defaultFormatting) {
        this.defaultFormatting = defaultFormatting;
    }

    public ItemModule.DurabilityVisibility getDefaultDurabilityVisibility() {
        return this.defaultDurabilityVisibility;
    }

    public void setDefaultDurabilityVisibility(ItemModule.DurabilityVisibility defaultDurabilityVisibility) {
        this.defaultDurabilityVisibility = defaultDurabilityVisibility;
    }

    static {
        defaultEnabledModules = new ArrayList<Class<? extends Module>>(){
            {
                this.add(FPSModule.class);
                this.add(CoordinatesModule.class);
                this.add(FModule.class);
            }
        };
        defaultListedAfterValues = new HashMap<Class<? extends Module>, Class<? extends Module>>(){
            {
                this.put(CoordinatesModule.class, FPSModule.class);
                this.put(FModule.class, CoordinatesModule.class);
            }
        };
    }
}

