/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.ingamegui;

import java.util.ArrayList;
import net.labymod.ingamegui.Module;
import net.labymod.main.lang.LanguageManager;
import net.labymod.settings.elements.CategoryModuleEditorElement;
import net.labymod.settings.elements.ControlElement;
import net.labymod.settings.elements.SettingsElement;

public class ModuleCategory {
    private String name;
    private boolean enabled;
    private ControlElement.IconData iconData;
    public CategoryModuleEditorElement rawCategoryElement;

    public ModuleCategory(String name, boolean enabled) {
        String key = "modulecategory_" + name;
        this.name = LanguageManager.translate(key);
        if (this.name.equals(key)) {
            this.name = name;
        }
        this.enabled = enabled;
        this.iconData = new ControlElement.IconData(new jy("labymod/textures/settings/guicategory/" + name + ".png"));
    }

    public ModuleCategory(String name, boolean enabled, ControlElement.IconData iconData) {
        String key = "modulecategory_" + name;
        this.name = LanguageManager.translate(key);
        if (this.name.equals(key)) {
            this.name = name;
        }
        this.enabled = enabled;
        this.iconData = iconData;
    }

    public String getName() {
        return this.name;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof ModuleCategory && ((ModuleCategory)obj).getName().equals(this.name);
    }

    public void createCategoryElement() {
        this.rawCategoryElement = new CategoryModuleEditorElement(this.name, this.iconData);
        ArrayList<SettingsElement> subList = new ArrayList<SettingsElement>();
        for (Module module : Module.getModules()) {
            if (module.getCategory() == null || !module.getCategory().equals(this)) continue;
            subList.add(module.getBooleanElement());
        }
        this.rawCategoryElement.getSubSettings().addAll(subList);
    }

    public CategoryModuleEditorElement getCategoryElement() {
        if (this.rawCategoryElement == null) {
            this.createCategoryElement();
        }
        return this.rawCategoryElement;
    }

    public void setCategoryElement(CategoryModuleEditorElement categoryModuleEditorElement) {
        this.rawCategoryElement = categoryModuleEditorElement;
    }

    public void setRawCategoryElement(CategoryModuleEditorElement rawCategoryElement) {
        this.rawCategoryElement = rawCategoryElement;
    }
}

