/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.ingamechat.tabs;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Scanner;
import net.labymod.core.LabyModCore;
import net.labymod.gui.elements.Scrollbar;
import net.labymod.ingamechat.GuiChatCustom;
import net.labymod.main.lang.LanguageManager;
import net.labymod.settings.elements.SettingsElement;
import net.labymod.utils.ModColor;
import org.lwjgl.input.Mouse;

public class GuiChatSymbols
extends GuiChatCustom {
    private static final char[] SYMBOLS = GuiChatSymbols.loadSymbols();
    private Scrollbar scrollbar = new Scrollbar(15);
    private HashMap<String, Long> pressedAnimation = new HashMap();
    private boolean canScroll;

    public GuiChatSymbols(String defaultText) {
        super(defaultText);
    }

    @Override
    public void b() {
        super.b();
        this.scrollbar.setPosition(this.l - 8, this.m - 145, this.l - 3, this.m - 20);
        this.scrollbar.update(SYMBOLS.length / 9);
        this.scrollbar.setSpeed(10);
        this.scrollbar.setEntryHeight(10.0);
    }

    @Override
    public void k() throws IOException {
        super.k();
        if (this.canScroll) {
            this.scrollbar.mouseInput();
            int i = Mouse.getEventDWheel();
            if (i != 0) {
                this.j.q.d().d();
            }
        }
    }

    @Override
    public void a(int mouseX, int mouseY, float partialTicks) {
        boolean bl;
        super.a(mouseX, mouseY, partialTicks);
        this.scrollbar.calc();
        GuiChatSymbols.a((int)(this.l - 100), (int)(this.m - 150), (int)(this.l - 2), (int)(this.m - 16), (int)Integer.MIN_VALUE);
        GuiChatSymbols.a((int)(this.l - 6), (int)(this.m - 145), (int)(this.l - 5), (int)(this.m - 20), (int)Integer.MIN_VALUE);
        GuiChatSymbols.a((int)(this.l - 7), (int)((int)this.scrollbar.getTop()), (int)(this.l - 4), (int)((int)(this.scrollbar.getTop() + this.scrollbar.getBarLength())), (int)Integer.MAX_VALUE);
        this.canScroll = mouseX > this.l - 100 && mouseX < this.l - 2 && mouseY > this.m - 150 && mouseY < this.m - 16;
        int row = 0;
        int column = 0;
        for (char symbol : SYMBOLS) {
            if ((double)(column * 10) + this.scrollbar.getScrollY() > -5.0 && (double)(column * 10) + this.scrollbar.getScrollY() < 125.0) {
                boolean hoverSymbol = mouseX > this.l - 93 + row * 10 - 5 && mouseX < this.l - 93 + row * 10 + 6 && (double)mouseY > (double)(this.m - 147 + column * 10) + this.scrollbar.getScrollY() - 5.0 && (double)mouseY < (double)(this.m - 147 + column * 10) + this.scrollbar.getScrollY() + 6.0;
                this.a(LabyModCore.getMinecraft().getFontRenderer(), String.valueOf(symbol), this.l - 93 + row * 10, (int)((double)(this.m - 147 + column * 10) + this.scrollbar.getScrollY()), hoverSymbol ? -24000 : -1);
            }
            if (++row <= 8) continue;
            row = 0;
            ++column;
        }
        row = 0;
        column = 0;
        for (String code : ModColor.COLOR_CODES) {
            boolean hoverCode;
            Long longPressed = this.pressedAnimation.get(code);
            int pressedCode = (int)(longPressed == null ? 0L : longPressed - System.currentTimeMillis());
            boolean bl2 = hoverCode = mouseX > this.l - 111 - column * 11 && mouseX < this.l - 111 + 10 - column * 11 && mouseY > this.m - 150 + row * 11 && mouseY < this.m - 150 + 10 + row * 11;
            GuiChatSymbols.a((int)(this.l - 111 - column * 11), (int)(this.m - 150 + row * 11), (int)(this.l - 111 + 10 - column * 11), (int)(this.m - 150 + 10 + row * 11), (int)(hoverCode || pressedCode != 0 ? ModColor.toRGB(132, 132, 132, pressedCode == 0 ? 130 : pressedCode / 4) : Integer.MIN_VALUE));
            this.a(LabyModCore.getMinecraft().getFontRenderer(), ModColor.cl(code) + code, this.l - 111 - column * 11 + 5, this.m - 150 + row * 11 + 1, Integer.MAX_VALUE);
            if (pressedCode < 0) {
                this.pressedAnimation.remove(code);
            }
            if (++row <= 11 && !code.equals("9") && !code.equals("f")) continue;
            row = 0;
            ++column;
        }
        boolean bl3 = false;
        for (String code : ModColor.COLOR_CODES) {
            if (!this.a.b().contains("&" + code)) continue;
            bl = true;
            break;
        }
        if (bl) {
            GuiChatSymbols.a((int)2, (int)(this.m - 16 - 11), (int)(this.l - 101), (int)(this.m - 15), (int)Integer.MIN_VALUE);
            String string = this.a.b().replace("&", ModColor.getCharAsString());
            while (string.contains("  ")) {
                string = string.replace("  ", " ");
            }
            this.c(LabyModCore.getMinecraft().getFontRenderer(), ModColor.cl("r") + string, 4, this.m - 16 - 9, Integer.MAX_VALUE);
        }
        this.c(LabyModCore.getMinecraft().getFontRenderer(), LanguageManager.translate("ingame_chat_tab_symbols"), this.l - 100, this.m - 160, -1);
    }

    @Override
    protected void a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.a(mouseX, mouseY, mouseButton);
        this.scrollbar.mouseAction(mouseX, mouseY, Scrollbar.EnumMouseAction.CLICKED);
        int row = 0;
        int column = 0;
        for (char symbol : SYMBOLS) {
            if ((double)(column * 10) + this.scrollbar.getScrollY() > -5.0 && (double)(column * 10) + this.scrollbar.getScrollY() < 125.0) {
                boolean hoverSymbol;
                boolean bl = hoverSymbol = mouseX > this.l - 93 + row * 10 - 5 && mouseX < this.l - 93 + row * 10 + 6 && (double)mouseY > (double)(this.m - 147 + column * 10) + this.scrollbar.getScrollY() - 5.0 && (double)mouseY < (double)(this.m - 147 + column * 10) + this.scrollbar.getScrollY() + 6.0;
                if (hoverSymbol) {
                    this.a.a(symbol, 0);
                    LabyModCore.getMinecraft().playSound(SettingsElement.BUTTON_PRESS_SOUND, 2.0f);
                    break;
                }
            }
            if (++row <= 8) continue;
            row = 0;
            ++column;
        }
        row = 0;
        column = 0;
        for (String code : ModColor.COLOR_CODES) {
            if (mouseX > this.l - 111 - column * 11 && mouseX < this.l - 111 + 10 - column * 11 && mouseY > this.m - 150 + row * 11 && mouseY < this.m - 150 + 10 + row * 11) {
                this.a.a("&".charAt(0), 0);
                this.a.a(code.charAt(0), 0);
                LabyModCore.getMinecraft().playSound(SettingsElement.BUTTON_PRESS_SOUND, 2.0f);
            }
            if (++row <= 11 && !code.equals("9") && !code.equals("f")) continue;
            row = 0;
            ++column;
        }
    }

    @Override
    protected void a(char typedChar, int keyCode) throws IOException {
        super.a(typedChar, keyCode);
        String currentText = this.a.b();
        int curser = this.a.i();
        if (curser > 1 && currentText.length() > 0) {
            String curserText = String.valueOf(typedChar);
            boolean isColorCode = false;
            for (String code : ModColor.COLOR_CODES) {
                if (!code.equals(curserText)) continue;
                isColorCode = true;
                break;
            }
            if (curser > 1 && isColorCode && String.valueOf(currentText.charAt(curser - 2)).equals("&")) {
                this.pressedAnimation.put(curserText, System.currentTimeMillis() + 1000L);
            }
        }
    }

    @Override
    protected void a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        this.scrollbar.mouseAction(mouseX, mouseY, Scrollbar.EnumMouseAction.DRAGGING);
        super.a(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
    }

    @Override
    protected void b(int mouseX, int mouseY, int state) {
        this.scrollbar.mouseAction(mouseX, mouseY, Scrollbar.EnumMouseAction.RELEASED);
        super.b(mouseX, mouseY, state);
    }

    private static char[] loadSymbols() {
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("assets/minecraft/labymod/data/symbols.txt");
        DataInputStream dis = new DataInputStream(inputStream);
        String string = "";
        Scanner scanner = new Scanner((InputStream)dis, "UTF-8");
        while (scanner.hasNext()) {
            string = string + scanner.next();
        }
        scanner.close();
        return string.toCharArray();
    }
}

