/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.ingamechat.tabs;

import java.io.IOException;
import java.util.List;
import net.labymod.core.LabyModCore;
import net.labymod.gui.elements.ModTextField;
import net.labymod.gui.elements.Scrollbar;
import net.labymod.ingamechat.GuiChatCustom;
import net.labymod.ingamechat.tools.shortcuts.Shortcuts;
import net.labymod.main.LabyMod;
import net.labymod.main.lang.LanguageManager;
import net.labymod.utils.DrawUtils;
import net.labymod.utils.ModColor;
import net.labymod.utils.manager.TooltipHelper;

public class GuiChatShortcuts
extends GuiChatCustom {
    private final int windowWidth = 148;
    private final int windowHeight = 194;
    private Scrollbar scrollbar = new Scrollbar(10);
    private Shortcuts.Shortcut openShortcutComponent = null;
    private Shortcuts.Shortcut hoverShortcutComponent = null;
    private boolean hoverAddButton = false;
    private boolean hoverCancelButton = false;
    private boolean hoverSaveButton = false;
    private boolean hoverDeleteButton = false;
    private ModTextField fieldShortcut;
    private ModTextField fieldReplacement;
    private boolean canHighlightRed = false;

    public GuiChatShortcuts(String defaultText) {
        super(defaultText);
    }

    @Override
    public void b() {
        super.b();
        this.fieldShortcut = new ModTextField(0, LabyModCore.getMinecraft().getFontRenderer(), 0, 0, 0, 10);
        this.fieldReplacement = new ModTextField(0, LabyModCore.getMinecraft().getFontRenderer(), 0, 0, 0, 10);
        this.fieldShortcut.setEnableBackgroundDrawing(false);
        this.fieldReplacement.setEnableBackgroundDrawing(false);
        this.fieldShortcut.setMaxStringLength(120);
        this.fieldReplacement.setMaxStringLength(120);
    }

    @Override
    public void a(int mouseX, int mouseY, float partialTicks) {
        super.a(mouseX, mouseY, partialTicks);
        DrawUtils draw = LabyMod.getInstance().getDrawUtils();
        int margin = 2;
        int chatHeight = 16;
        int x = draw.getWidth() - this.windowWidth - margin;
        int y = draw.getHeight() - this.windowHeight - chatHeight;
        DrawUtils.a((int)x, (int)y, (int)(x + this.windowWidth), (int)(y + this.windowHeight), (int)Integer.MIN_VALUE);
        draw.drawString(LanguageManager.translate("ingame_chat_tab_shortcut"), x, y - 10);
        this.hoverShortcutComponent = null;
        this.hoverDeleteButton = false;
        List<Shortcuts.Shortcut> shortcuts = LabyMod.getInstance().getChatToolManager().getShortcuts();
        this.scrollbar.setPosition(draw.getWidth() - margin - 1, y + margin, draw.getWidth() - margin, draw.getHeight() - chatHeight - margin);
        this.scrollbar.update(shortcuts.size());
        int listPadding = 2;
        int listX = x + listPadding;
        double listY = (double)(y + listPadding) + this.scrollbar.getScrollY();
        for (Shortcuts.Shortcut shortcutComponent : shortcuts) {
            if (listY >= (double)y && listY < (double)(draw.getHeight() - chatHeight - listPadding)) {
                boolean hoverDeleteButton;
                boolean hover = draw.drawRect(mouseX, mouseY, listX - listPadding, listY, listX - listPadding + this.windowWidth, listY + 10.0, 0, ModColor.toRGB(100, 200, 200, 100));
                String shortcut = shortcutComponent.getShortcut();
                draw.drawString(shortcut, listX, listY + 1.0);
                boolean bl = hoverDeleteButton = hover && mouseX > listX - listPadding + this.windowWidth - 10;
                if (hover) {
                    draw.drawRightString(ModColor.cl(hoverDeleteButton ? (char)'c' : '4') + "\u2718", listX - listPadding + this.windowWidth, listY + 1.0);
                }
                if (hover) {
                    this.hoverShortcutComponent = shortcutComponent;
                    this.hoverDeleteButton = hoverDeleteButton;
                }
            }
            listY += 10.0;
        }
        this.scrollbar.draw();
        if (this.openShortcutComponent == null) {
            int buttonSize = 14;
            int buttonMargin = 2;
            this.hoverAddButton = draw.drawRect(mouseX, mouseY, (this.hoverAddButton ? ModColor.cl('a') : "") + "+", x - buttonSize - buttonMargin, y, x - buttonMargin, y + buttonSize, Integer.MIN_VALUE, Integer.MAX_VALUE);
            this.hoverSaveButton = false;
            this.hoverCancelButton = false;
        } else {
            int editorWidth = 130;
            int editorMargin = 2;
            int editorPadding = 2;
            int editorYIndex = y + editorPadding;
            DrawUtils.a((int)(x - editorWidth - editorMargin), (int)y, (int)(x - editorMargin), (int)(y + this.windowHeight), (int)Integer.MIN_VALUE);
            draw.drawString(LanguageManager.translate("chat_shortcut_shortcut") + ":", x - editorWidth + editorPadding - editorMargin, editorYIndex);
            this.fieldShortcut.width = editorWidth - editorPadding * 2;
            this.fieldShortcut.xPosition = x - editorWidth + editorPadding - editorMargin;
            this.fieldShortcut.yPosition = (editorYIndex += 10) + 1;
            int fieldShortcutColor = this.canHighlightRed && this.fieldShortcut.getText().isEmpty() ? ModColor.toRGB(200, 100, 100, 200) : Integer.MAX_VALUE;
            DrawUtils.a((int)(x - editorWidth + editorPadding - editorMargin), (int)editorYIndex, (int)(x - editorPadding - editorMargin), (int)(editorYIndex + 10), (int)fieldShortcutColor);
            this.fieldShortcut.drawTextBox();
            draw.drawString(LanguageManager.translate("chat_shortcut_replacement") + ":", x - editorWidth + editorPadding - editorMargin, editorYIndex += 15);
            this.fieldReplacement.width = editorWidth - editorPadding * 2;
            this.fieldReplacement.xPosition = x - editorWidth + editorPadding - editorMargin;
            this.fieldReplacement.yPosition = (editorYIndex += 10) + 1;
            int fieldReplacementColor = this.canHighlightRed && this.fieldReplacement.getText().isEmpty() ? ModColor.toRGB(200, 100, 100, 200) : Integer.MAX_VALUE;
            DrawUtils.a((int)(x - editorWidth + editorPadding - editorMargin), (int)editorYIndex, (int)(x - editorPadding - editorMargin), (int)(editorYIndex + 10), (int)fieldReplacementColor);
            this.fieldReplacement.drawTextBox();
            editorYIndex += 13;
            if (mouseX > this.fieldReplacement.xPosition && mouseX < this.fieldReplacement.xPosition + this.fieldReplacement.width && mouseY > this.fieldReplacement.yPosition && mouseY < this.fieldReplacement.yPosition + this.fieldReplacement.height) {
                TooltipHelper.getHelper().pointTooltip(mouseX, mouseY, "%s = Username");
            }
            int buttonHeight = 12;
            this.hoverCancelButton = draw.drawRect(mouseX, mouseY, LanguageManager.translate("button_cancel"), x - editorWidth + editorPadding - editorMargin, y + this.windowHeight - editorPadding - buttonHeight, x - editorWidth + editorPadding - editorMargin + editorWidth / 2 - editorPadding, y + this.windowHeight - editorPadding, Integer.MAX_VALUE, ModColor.toRGB(200, 100, 100, 200));
            this.hoverSaveButton = draw.drawRect(mouseX, mouseY, LanguageManager.translate("button_save"), x - editorWidth + editorPadding - editorMargin + editorWidth / 2 + editorPadding, y + this.windowHeight - editorPadding - buttonHeight, x - editorMargin - editorPadding, y + this.windowHeight - editorPadding, Integer.MAX_VALUE, ModColor.toRGB(100, 200, 100, 200));
            this.hoverAddButton = false;
        }
    }

    @Override
    protected void a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.a(mouseX, mouseY, mouseButton);
        if (this.hoverAddButton && mouseButton == 0) {
            this.openShortcutComponent = new Shortcuts.Shortcut("", "");
            this.canHighlightRed = false;
            this.fieldShortcut.setText("");
            this.fieldReplacement.setText("");
        }
        if (this.hoverShortcutComponent != null && mouseButton == 0) {
            if (this.hoverDeleteButton) {
                List<Shortcuts.Shortcut> shortcuts = LabyMod.getInstance().getChatToolManager().getShortcuts();
                shortcuts.remove(this.hoverShortcutComponent);
                if (this.hoverShortcutComponent == this.openShortcutComponent) {
                    this.openShortcutComponent = null;
                }
                LabyMod.getInstance().getChatToolManager().saveTools();
            } else {
                this.openShortcutComponent = this.hoverShortcutComponent;
                this.canHighlightRed = false;
                this.fieldShortcut.setText(this.openShortcutComponent.getShortcut());
                this.fieldReplacement.setText(this.openShortcutComponent.getReplacement());
            }
        }
        if (this.hoverCancelButton && mouseButton == 0) {
            this.openShortcutComponent = null;
        }
        if (this.hoverSaveButton && mouseButton == 0) {
            String shortcut = this.fieldShortcut.getText();
            String replacement = this.fieldReplacement.getText();
            if (shortcut.isEmpty() || replacement.isEmpty()) {
                this.canHighlightRed = true;
                return;
            }
            this.canHighlightRed = false;
            this.openShortcutComponent.setShortcut(this.fieldShortcut.getText());
            this.openShortcutComponent.setReplacement(this.fieldReplacement.getText());
            List<Shortcuts.Shortcut> shortcuts = LabyMod.getInstance().getChatToolManager().getShortcuts();
            if (!shortcuts.contains(this.openShortcutComponent)) {
                shortcuts.add(this.openShortcutComponent);
            }
            this.openShortcutComponent = null;
            LabyMod.getInstance().getChatToolManager().saveTools();
        }
        if (this.openShortcutComponent != null) {
            this.fieldShortcut.mouseClicked(mouseX, mouseY, mouseButton);
            this.fieldReplacement.mouseClicked(mouseX, mouseY, mouseButton);
        }
    }

    @Override
    protected void a(char typedChar, int keyCode) throws IOException {
        if (this.openShortcutComponent != null) {
            this.fieldShortcut.textboxKeyTyped(typedChar, keyCode);
            this.fieldReplacement.textboxKeyTyped(typedChar, keyCode);
            if (keyCode == 15) {
                if (this.fieldShortcut.isFocused()) {
                    this.fieldShortcut.setFocused(false);
                    this.fieldReplacement.setFocused(true);
                } else {
                    this.fieldShortcut.setFocused(true);
                    this.fieldReplacement.setFocused(false);
                }
            }
            if (keyCode == 1) {
                super.a(typedChar, keyCode);
            }
        } else {
            super.a(typedChar, keyCode);
        }
    }

    @Override
    protected void b(int mouseX, int mouseY, int state) {
        super.b(mouseX, mouseY, state);
        this.scrollbar.mouseAction(mouseX, mouseY, Scrollbar.EnumMouseAction.RELEASED);
    }

    @Override
    protected void a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        super.a(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
        this.scrollbar.mouseAction(mouseX, mouseY, Scrollbar.EnumMouseAction.DRAGGING);
    }

    @Override
    public void k() throws IOException {
        super.k();
        this.scrollbar.mouseInput();
    }

    public void e() {
        if (this.openShortcutComponent != null) {
            this.fieldShortcut.updateCursorCounter();
            this.fieldReplacement.updateCursorCounter();
        }
    }
}

