/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.ingamechat.tabs;

import java.awt.Color;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.labymod.core.LabyModCore;
import net.labymod.gui.elements.Scrollbar;
import net.labymod.ingamechat.GuiChatCustom;
import net.labymod.ingamechat.tools.filter.FilterChatManager;
import net.labymod.ingamechat.tools.filter.Filters;
import net.labymod.main.LabyMod;
import net.labymod.main.lang.LanguageManager;
import net.labymod.utils.ModColor;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.lwjgl.input.Mouse;

public class GuiChatFilter
extends GuiChatCustom {
    private Scrollbar scrollbar = new Scrollbar(15);
    private Filters.Filter selectedFilter;
    private avw textFieldFilterName;
    private avw textFieldFilterContains;
    private avw textFieldFilterContainsNot;
    private avw textFieldFilterSoundfile;
    private avw textFieldFilterRoom;
    private int sliderDrag = -1;
    private boolean markFilterNameRed = false;
    private boolean markContainsRed = false;
    private boolean markSoundNameRed = false;
    private String editStartName = "";
    private boolean canScroll;
    private static List<String> soundNames = new ArrayList<String>();

    public GuiChatFilter(String defaultText) {
        super(defaultText);
    }

    @Override
    public void b() {
        super.b();
        this.scrollbar.setPosition(this.l - 6, this.m - 196, this.l - 5, this.m - 20);
        this.scrollbar.update(LabyMod.getInstance().getChatToolManager().getFilters().size());
        this.scrollbar.setSpeed(10);
        this.scrollbar.setEntryHeight(10.0);
        this.textFieldFilterName = new avw(0, LabyModCore.getMinecraft().getFontRenderer(), 0, 0, 110, 10);
        this.textFieldFilterContains = new avw(0, LabyModCore.getMinecraft().getFontRenderer(), 0, 0, 110, 10);
        this.textFieldFilterContainsNot = new avw(0, LabyModCore.getMinecraft().getFontRenderer(), 0, 0, 110, 10);
        this.textFieldFilterSoundfile = new avw(0, LabyModCore.getMinecraft().getFontRenderer(), 0, 0, 110, 10);
        this.textFieldFilterRoom = new avw(0, LabyModCore.getMinecraft().getFontRenderer(), 0, 0, 110, 10);
        this.markContainsRed = false;
        this.markFilterNameRed = false;
        this.markSoundNameRed = false;
        this.selectedFilter = null;
    }

    @Override
    public void k() throws IOException {
        super.k();
        if (this.canScroll) {
            this.scrollbar.mouseInput();
            int i = Mouse.getEventDWheel();
            if (i != 0) {
                this.j.q.d().d();
            }
        }
    }

    @Override
    public void a(int mouseX, int mouseY, float partialTicks) {
        super.a(mouseX, mouseY, partialTicks);
        this.scrollbar.calc();
        GuiChatFilter.a((int)(this.l - 150), (int)(this.m - 220), (int)(this.l - 2), (int)(this.m - 16), (int)Integer.MIN_VALUE);
        this.canScroll = mouseX > this.l - 150 && mouseX < this.l - 2 && mouseY > this.m - 150 && mouseY < this.m - 16;
        int row = 0;
        for (Filters.Filter component : LabyMod.getInstance().getChatToolManager().getFilters()) {
            boolean hover;
            double posY = (double)(this.m - 215 + row * 10) + this.scrollbar.getScrollY();
            ++row;
            if (posY < (double)(this.m - 220) || posY > (double)(this.m - 25)) continue;
            boolean bl = hover = this.selectedFilter == null && mouseX > this.l - 150 + 1 && mouseX < this.l - 2 - 1 && (double)mouseY > posY - 1.0 && (double)mouseY < posY + 9.0;
            if (hover || this.selectedFilter != null && (this.selectedFilter.getFilterName().equalsIgnoreCase(component.getFilterName()) || component.getFilterName().equalsIgnoreCase(this.editStartName))) {
                GuiChatFilter.a((int)(this.l - 150 + 1), (int)((int)posY - 1), (int)(this.l - 2 - 1), (int)((int)posY + 9), (int)(hover ? ModColor.toRGB(100, 200, 200, 100) : Integer.MAX_VALUE));
            }
            this.c(LabyModCore.getMinecraft().getFontRenderer(), LabyMod.getInstance().getDrawUtils().trimStringToWidth(component.getFilterName(), 130), this.l - 145, (int)posY, Integer.MAX_VALUE);
            if (this.selectedFilter != null) continue;
            boolean hoverX = mouseX > this.l - 12 - 1 && mouseX < this.l - 12 + 7 && (double)mouseY > posY && (double)mouseY < posY + 8.0;
            this.c(LabyModCore.getMinecraft().getFontRenderer(), ModColor.cl(hoverX ? "c" : "4") + "\u2718", this.l - 12, (int)posY, Integer.MAX_VALUE);
        }
        if (!this.scrollbar.isHidden()) {
            GuiChatFilter.a((int)(this.l - 6), (int)(this.m - 145), (int)(this.l - 5), (int)(this.m - 20), (int)Integer.MIN_VALUE);
            GuiChatFilter.a((int)(this.l - 7), (int)((int)this.scrollbar.getTop()), (int)(this.l - 4), (int)((int)(this.scrollbar.getTop() + this.scrollbar.getBarLength())), (int)Integer.MAX_VALUE);
        }
        if (this.selectedFilter == null) {
            boolean hover = mouseX > this.l - 165 && mouseX < this.l - 152 && mouseY > this.m - 220 && mouseY < this.m - 220 + 13;
            GuiChatFilter.a((int)(this.l - 165), (int)(this.m - 220), (int)(this.l - 152), (int)(this.m - 220 + 13), (int)(hover ? Integer.MAX_VALUE : Integer.MIN_VALUE));
            this.a(LabyModCore.getMinecraft().getFontRenderer(), "+", this.l - 158, this.m - 217, hover ? ModColor.toRGB(50, 220, 120, 210) : Integer.MAX_VALUE);
        } else {
            String hint;
            int count;
            int relYAtSoundHint = 0;
            int relYAtRoomHint = 0;
            GuiChatFilter.a((int)(this.l - 270), (int)(this.m - 220), (int)(this.l - 152), (int)(this.m - 16), (int)Integer.MIN_VALUE);
            int relX = this.l - 270;
            int relY = this.m - 220;
            this.drawElementTextField("name", this.textFieldFilterName, relX, relY, mouseX, mouseY);
            this.drawElementTextField("contains", this.textFieldFilterContains, relX, relY + 23, mouseX, mouseY);
            this.drawElementTextField("contains_not", this.textFieldFilterContainsNot, relX, relY + 46, mouseX, mouseY);
            this.drawElementTextField("room", this.textFieldFilterRoom, relX, relY + 69, mouseX, mouseY);
            relYAtRoomHint = relY + 69;
            this.drawElementCheckBox("play_sound", this.selectedFilter.isPlaySound(), relX, (relY += 23) + 69, mouseX, mouseY);
            if (this.selectedFilter.isPlaySound()) {
                this.drawElementTextField("", this.textFieldFilterSoundfile, relX, relY + 69, mouseX, mouseY);
                relYAtSoundHint = relY + 69;
            } else {
                relY -= 10;
            }
            this.drawElementCheckBox("highlight", this.selectedFilter.isHighlightMessage(), relX, relY + 92, mouseX, mouseY);
            if (this.selectedFilter.isHighlightMessage() && this.selectedFilter.getHighlightColor() != null) {
                this.drawElementSlider(this.selectedFilter.getHighlightColor().getRed(), relX, relY + 92 + 15, 0, mouseX, mouseY);
                this.drawElementSlider(this.selectedFilter.getHighlightColor().getGreen(), relX, relY + 92 + 15 + 9, 1, mouseX, mouseY);
                this.drawElementSlider(this.selectedFilter.getHighlightColor().getBlue(), relX, relY + 92 + 15 + 18, 2, mouseX, mouseY);
                GuiChatFilter.a((int)(relX + 85), (int)(relY + 92 + 1), (int)(relX + 85 + 9), (int)(relY + 92 + 1 + 9), (int)this.selectedFilter.getHighlightColor().getRGB());
            } else {
                relY -= 26;
            }
            this.drawElementCheckBox("hide", this.selectedFilter.isHideMessage(), relX, relY + 115 + 15, mouseX, mouseY);
            this.drawElementCheckBox("second_chat", this.selectedFilter.isDisplayInSecondChat(), relX, relY + 115 + 15 + 12, mouseX, mouseY);
            this.drawElementCheckBox("tooltip", this.selectedFilter.isFilterTooltips(), relX, relY + 115 + 15 + 24, mouseX, mouseY);
            boolean hoverCancel = mouseX > this.l - 268 && mouseX < this.l - 213 && mouseY > this.m - 30 && mouseY < this.m - 18;
            boolean hoverSave = mouseX > this.l - 210 && mouseX < this.l - 154 && mouseY > this.m - 30 && mouseY < this.m - 18;
            GuiChatFilter.a((int)(this.l - 268), (int)(this.m - 30), (int)(this.l - 213), (int)(this.m - 18), (int)(hoverCancel ? ModColor.toRGB(200, 100, 100, 200) : Integer.MAX_VALUE));
            GuiChatFilter.a((int)(this.l - 210), (int)(this.m - 30), (int)(this.l - 154), (int)(this.m - 18), (int)(hoverSave ? ModColor.toRGB(100, 200, 100, 200) : Integer.MAX_VALUE));
            this.a(LabyModCore.getMinecraft().getFontRenderer(), LanguageManager.translate("button_cancel"), this.l - 262 + 22, this.m - 30 + 2, Integer.MAX_VALUE);
            this.a(LabyModCore.getMinecraft().getFontRenderer(), LanguageManager.translate("button_save"), this.l - 205 + 23, this.m - 30 + 2, Integer.MAX_VALUE);
            this.textFieldFilterName.g();
            this.textFieldFilterContains.g();
            this.textFieldFilterContainsNot.g();
            this.textFieldFilterRoom.g();
            if (this.selectedFilter.isPlaySound()) {
                this.textFieldFilterSoundfile.g();
            }
            if (this.textFieldFilterSoundfile.m() && this.selectedFilter.isPlaySound() && this.textFieldFilterSoundfile != null && !this.textFieldFilterSoundfile.b().isEmpty()) {
                String lowerCase;
                count = 0;
                hint = "";
                for (String path : soundNames) {
                    if (!path.startsWith(lowerCase = this.textFieldFilterSoundfile.b().toLowerCase()) || path.equals(lowerCase)) continue;
                    hint = hint + path + "\n";
                    if (++count <= 5) continue;
                    break;
                }
                if (count == 0) {
                    for (String path : soundNames) {
                        if (!path.contains(lowerCase = this.textFieldFilterSoundfile.b().toLowerCase()) || path.equals(lowerCase)) continue;
                        hint = hint + path + "\n";
                        if (++count <= 5) continue;
                        break;
                    }
                }
                if (count != 0) {
                    LabyMod.getInstance().getDrawUtils().drawHoveringText(relX, relYAtSoundHint + 40, hint.split("\n"));
                }
            }
            if (this.textFieldFilterRoom.m()) {
                count = 0;
                hint = "";
                if (this.textFieldFilterRoom.b().isEmpty() || "Global".contains(this.textFieldFilterRoom.b().toUpperCase())) {
                    ++count;
                    hint = hint + "Global";
                }
                for (Filters.Filter filterComponent : LabyMod.getInstance().getChatToolManager().getFilters()) {
                    if (filterComponent.getRoom() == null || !filterComponent.getRoom().toLowerCase().contains(this.textFieldFilterRoom.b().toLowerCase()) || hint.contains(filterComponent.getRoom())) continue;
                    hint = hint + filterComponent.getRoom() + "\n";
                    ++count;
                }
                if (count != 0) {
                    LabyMod.getInstance().getDrawUtils().drawHoveringText(relX, relYAtRoomHint + 40, hint.split("\n"));
                }
            }
        }
        this.c(LabyModCore.getMinecraft().getFontRenderer(), LanguageManager.translate("ingame_chat_tab_filter"), this.l - 150, this.m - 230, -1);
        if (this.sliderDrag != -1) {
            this.a(mouseX, mouseY, 0, 0L);
        }
    }

    @Override
    protected void a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.a(mouseX, mouseY, mouseButton);
        this.scrollbar.mouseAction(mouseX, mouseY, Scrollbar.EnumMouseAction.CLICKED);
        if (this.selectedFilter == null && mouseX > this.l - 165 && mouseX < this.l - 152 && mouseY > this.m - 220 && mouseY < this.m - 220 + 13) {
            this.loadFilter(new Filters.Filter("", new String[0], new String[0], false, "note.harp", true, 200, 200, 50, false, false, false, "Global"));
        }
        if (this.selectedFilter == null) {
            int row = 0;
            Filters.Filter todoDelete = null;
            for (Filters.Filter component : LabyMod.getInstance().getChatToolManager().getFilters()) {
                double posY = (double)(this.m - 215 + row * 10) + this.scrollbar.getScrollY();
                ++row;
                if (posY < (double)(this.m - 220) || posY > (double)(this.m - 25)) continue;
                if (mouseX > this.l - 12 - 1 && mouseX < this.l - 12 + 7 && (double)mouseY > posY && (double)mouseY < posY + 8.0) {
                    todoDelete = component;
                    continue;
                }
                if (mouseX <= this.l - 150 + 1 || mouseX >= this.l - 2 - 1 || !((double)mouseY > posY - 1.0) || !((double)mouseY < posY + 9.0)) continue;
                this.loadFilter(new Filters.Filter(component));
                this.editStartName = component.getFilterName();
            }
            if (todoDelete != null) {
                LabyMod.getInstance().getChatToolManager().getFilters().remove(todoDelete);
                FilterChatManager.removeFilterComponent(todoDelete);
                LabyMod.getInstance().getChatToolManager().saveTools();
            }
        } else {
            boolean hoverSave;
            if (this.textFieldFilterRoom.b().contains(" ") || this.selectedFilter.getRoom() == null || this.selectedFilter.getRoom().contains(" ")) {
                this.textFieldFilterRoom.a(this.textFieldFilterRoom.b().replaceAll(" ", ""));
                this.selectedFilter.setRoom(this.textFieldFilterRoom.b());
            }
            if (this.textFieldFilterRoom.b().isEmpty() || this.selectedFilter.getRoom() == null || this.selectedFilter.getRoom().isEmpty()) {
                this.textFieldFilterRoom.a("Global");
                this.selectedFilter.setRoom(this.textFieldFilterRoom.b());
            }
            int relX = this.l - 270;
            int relY = this.m - 220;
            if (this.isHoverElementCheckbox("play_sound", this.selectedFilter.isPlaySound(), relX, (relY += 23) + 69, mouseX, mouseY)) {
                this.selectedFilter.setPlaySound(!this.selectedFilter.isPlaySound());
            }
            if (!this.selectedFilter.isPlaySound()) {
                relY -= 10;
            }
            if (this.isHoverElementCheckbox("highlight", this.selectedFilter.isHighlightMessage(), relX, relY + 92, mouseX, mouseY)) {
                this.selectedFilter.setHighlightMessage(!this.selectedFilter.isHighlightMessage());
            }
            if (this.selectedFilter.isHighlightMessage() && this.selectedFilter.getHighlightColor() != null) {
                this.dragElementSlider(relX, relY + 92 + 15, 0, mouseX, mouseY);
                this.dragElementSlider(relX, relY + 92 + 15 + 9, 1, mouseX, mouseY);
                this.dragElementSlider(relX, relY + 92 + 15 + 18, 2, mouseX, mouseY);
            } else {
                relY -= 26;
            }
            if (this.isHoverElementCheckbox("hide", this.selectedFilter.isHideMessage(), relX, relY + 115 + 15, mouseX, mouseY)) {
                this.selectedFilter.setHideMessage(!this.selectedFilter.isHideMessage());
            }
            if (this.isHoverElementCheckbox("second_chat", this.selectedFilter.isDisplayInSecondChat(), relX, relY + 115 + 15 + 12, mouseX, mouseY)) {
                this.selectedFilter.setDisplayInSecondChat(!this.selectedFilter.isDisplayInSecondChat());
            }
            if (this.isHoverElementCheckbox("tooltip", this.selectedFilter.isFilterTooltips(), relX, relY + 115 + 15 + 24, mouseX, mouseY)) {
                this.selectedFilter.setFilterTooltips(!this.selectedFilter.isFilterTooltips());
            }
            boolean hoverCancel = mouseX > this.l - 268 && mouseX < this.l - 213 && mouseY > this.m - 30 && mouseY < this.m - 18;
            boolean bl = hoverSave = mouseX > this.l - 210 && mouseX < this.l - 154 && mouseY > this.m - 30 && mouseY < this.m - 18;
            if (hoverCancel) {
                this.selectedFilter = null;
            }
            if (hoverSave) {
                if (this.selectedFilter.getFilterName().replaceAll(" ", "").isEmpty()) {
                    this.markFilterNameRed = true;
                }
                this.markContainsRed = this.selectedFilter.getWordsContains().length == 0;
                this.markSoundNameRed = this.selectedFilter.isPlaySound() && !soundNames.contains(this.textFieldFilterSoundfile.b().toLowerCase());
                if (!(this.markFilterNameRed || this.markSoundNameRed || this.markContainsRed)) {
                    Iterator<Filters.Filter> it = LabyMod.getInstance().getChatToolManager().getFilters().iterator();
                    while (it.hasNext()) {
                        Filters.Filter next = it.next();
                        if (this.editStartName == null) {
                            if (!next.getFilterName().equalsIgnoreCase(this.selectedFilter.getFilterName())) continue;
                            it.remove();
                            continue;
                        }
                        if (!next.getFilterName().equalsIgnoreCase(this.editStartName)) continue;
                        it.remove();
                    }
                    if (!LabyMod.getInstance().getChatToolManager().getFilters().contains(this.selectedFilter)) {
                        LabyMod.getInstance().getChatToolManager().getFilters().add(this.selectedFilter);
                    }
                    LabyMod.getInstance().getChatToolManager().saveTools();
                    FilterChatManager.getFilterResults().clear();
                    ave.A().q.d().b();
                    this.selectedFilter = null;
                    this.b();
                }
            }
        }
    }

    @Override
    protected void a(char typedChar, int keyCode) throws IOException {
        if (this.selectedFilter != null && (this.textFieldFilterName.m() || this.textFieldFilterContains.m() || this.textFieldFilterContainsNot.m() || this.textFieldFilterRoom.m() || this.textFieldFilterSoundfile.m())) {
            if (keyCode == 15) {
                if (this.textFieldFilterName.m()) {
                    this.textFieldFilterName.b(false);
                    this.textFieldFilterContains.b(true);
                    return;
                }
                if (this.textFieldFilterContains.m()) {
                    this.textFieldFilterContains.b(false);
                    this.textFieldFilterContainsNot.b(true);
                    return;
                }
                if (this.textFieldFilterContainsNot.m()) {
                    this.textFieldFilterContainsNot.b(false);
                    this.textFieldFilterRoom.b(true);
                    return;
                }
                if (this.textFieldFilterRoom.m()) {
                    this.textFieldFilterRoom.b(false);
                    if (this.selectedFilter.isPlaySound()) {
                        this.textFieldFilterSoundfile.b(true);
                    } else {
                        this.textFieldFilterName.b(true);
                    }
                    return;
                }
                if (this.textFieldFilterSoundfile.m()) {
                    this.textFieldFilterSoundfile.b(false);
                    this.textFieldFilterName.b(true);
                    return;
                }
            }
            if (this.textFieldFilterName.a(typedChar, keyCode)) {
                String newText = this.textFieldFilterName.b().replaceAll(" ", "");
                boolean equals = false;
                for (Filters.Filter filter : LabyMod.getInstance().getChatToolManager().getFilters()) {
                    if (!filter.getFilterName().equalsIgnoreCase(newText) || filter.getFilterName().equalsIgnoreCase(this.editStartName)) continue;
                    equals = true;
                    break;
                }
                if (equals) {
                    this.markFilterNameRed = true;
                    return;
                }
                this.selectedFilter.setFilterName(newText);
                this.markFilterNameRed = false;
            }
            if (this.textFieldFilterContains.a(typedChar, keyCode)) {
                this.selectedFilter.setWordsContains(this.splitWords(this.textFieldFilterContains.b()));
                this.markContainsRed = false;
            }
            if (this.textFieldFilterContainsNot.a(typedChar, keyCode)) {
                this.selectedFilter.setWordsContainsNot(this.splitWords(this.textFieldFilterContainsNot.b()));
            }
            if (this.textFieldFilterRoom.a(typedChar, keyCode)) {
                this.selectedFilter.setRoom(this.textFieldFilterRoom.b());
            }
            if (this.textFieldFilterSoundfile.a(typedChar, keyCode)) {
                this.selectedFilter.setSoundPath(this.textFieldFilterSoundfile.b().toLowerCase());
                this.markSoundNameRed = false;
            }
        } else {
            super.a(typedChar, keyCode);
        }
    }

    @Override
    protected void a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        this.scrollbar.mouseAction(mouseX, mouseY, Scrollbar.EnumMouseAction.DRAGGING);
        super.a(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
        if (this.selectedFilter != null) {
            int relX = this.l - 270;
            int relY = this.m - 200;
            if (!this.selectedFilter.isPlaySound()) {
                relY -= 10;
            }
            if (this.selectedFilter.isHighlightMessage() && this.selectedFilter.getHighlightColor() != null) {
                if (this.sliderDrag == 0) {
                    this.dragElementSlider(relX, relY + 92 + 15, 0, mouseX, mouseY);
                }
                if (this.sliderDrag == 1) {
                    this.dragElementSlider(relX, relY + 92 + 15 + 9, 1, mouseX, mouseY);
                }
                if (this.sliderDrag == 2) {
                    this.dragElementSlider(relX, relY + 92 + 15 + 18, 2, mouseX, mouseY);
                }
            }
        }
    }

    @Override
    protected void b(int mouseX, int mouseY, int mouseButton) {
        super.b(mouseX, mouseY, mouseButton);
        this.sliderDrag = -1;
        this.scrollbar.mouseAction(mouseX, mouseY, Scrollbar.EnumMouseAction.RELEASED);
        this.textFieldFilterName.a(mouseX, mouseY, mouseButton);
        this.textFieldFilterContains.a(mouseX, mouseY, mouseButton);
        this.textFieldFilterContainsNot.a(mouseX, mouseY, mouseButton);
        this.textFieldFilterRoom.a(mouseX, mouseY, mouseButton);
        this.textFieldFilterSoundfile.a(mouseX, mouseY, mouseButton);
    }

    public void e() {
        super.e();
        this.textFieldFilterName.a();
        this.textFieldFilterContains.a();
        this.textFieldFilterContainsNot.a();
        this.textFieldFilterRoom.a();
        this.textFieldFilterSoundfile.a();
    }

    private void drawElementTextField(String prefix, avw textField, int x, int y, int mouseX, int mouseY) {
        if (!prefix.isEmpty()) {
            prefix = LanguageManager.translate("chat_filter_" + prefix) + ":";
        }
        this.c(LabyModCore.getMinecraft().getFontRenderer(), prefix, x + 2, y + 2, Integer.MAX_VALUE);
        GuiChatFilter.a((int)(x + 2), (int)(y + 12), (int)(x + 2 + 114), (int)(y + 12 + 10), (int)(this.markContainsRed && textField != null && textField.equals(this.textFieldFilterContains) || this.markFilterNameRed && textField != null && textField.equals(this.textFieldFilterName) || this.markSoundNameRed && textField != null && textField.equals(this.textFieldFilterSoundfile) ? ModColor.toRGB(200, 100, 100, 200) : Integer.MAX_VALUE));
        if (textField == null) {
            return;
        }
        LabyModCore.getMinecraft().setTextFieldXPosition(textField, x + 2);
        LabyModCore.getMinecraft().setTextFieldYPosition(textField, y + 13);
        textField.a(false);
        textField.f(120);
    }

    private void drawElementCheckBox(String text, boolean check, int x, int y, int mouseX, int mouseY) {
        boolean hover = this.isHoverElementCheckbox(text, check, x, y, mouseX, mouseY);
        text = LanguageManager.translate("chat_filter_" + text);
        this.c(LabyModCore.getMinecraft().getFontRenderer(), text, x + 2, y + 2, Integer.MAX_VALUE);
        GuiChatFilter.a((int)((x += LabyModCore.getMinecraft().getFontRenderer().a(text) + 2) + 3), (int)(y + 1), (int)(x + 12), (int)(y + 10), (int)(hover ? 2147483547 : Integer.MAX_VALUE));
        if (!check) {
            return;
        }
        this.a(LabyModCore.getMinecraft().getFontRenderer(), ModColor.cl("a") + "\u2714", x + 8, y + 1, Integer.MAX_VALUE);
    }

    private void drawElementSlider(int value, int x, int y, int id, int mouseX, int mouseY) {
        GuiChatFilter.a((int)(x + 2), (int)y, (int)(x + 2 + 94), (int)(y + 1), (int)Integer.MAX_VALUE);
        double colorValue = value;
        double percent = colorValue / 255.0 * 94.0;
        int pos = (int)percent;
        GuiChatFilter.a((int)(x + 2 + pos), (int)(y - 3), (int)(x + 2 + pos + 2), (int)(y + 5), (int)ModColor.toRGB(id == 0 ? value : 0, id == 1 ? value : 0, id == 2 ? value : 0, 255));
    }

    private boolean isHoverElementCheckbox(String text, boolean check, int x, int y, int mouseX, int mouseY) {
        text = LanguageManager.translate("chat_filter_" + text);
        return mouseX > (x += LabyModCore.getMinecraft().getFontRenderer().a(text) + 2) + 3 && mouseX < x + 12 && mouseY > y + 1 && mouseY < y + 10;
    }

    private void dragElementSlider(int x, int y, int id, int mouseX, int mouseY) {
        if (mouseX <= x || mouseX >= x + 94 || (mouseY <= y - 5 || mouseY >= y + 5) && this.sliderDrag != id) {
            return;
        }
        if (mouseX < x) {
            mouseX = x;
        }
        if (mouseX > x + 94) {
            mouseX = x + 94;
        }
        double pos = mouseX - x;
        double value = pos * 255.0 / 94.0;
        int colorValue = (int)value;
        Color highlightColor = this.selectedFilter.getHighlightColor();
        int r = highlightColor.getRed();
        int g2 = highlightColor.getGreen();
        int b2 = highlightColor.getBlue();
        switch (id) {
            case 0: {
                r = colorValue;
                break;
            }
            case 1: {
                g2 = colorValue;
                break;
            }
            case 2: {
                b2 = colorValue;
            }
        }
        this.selectedFilter.setHighlightColorR((short)r);
        this.selectedFilter.setHighlightColorG((short)g2);
        this.selectedFilter.setHighlightColorB((short)b2);
        this.sliderDrag = id;
    }

    private void loadFilter(Filters.Filter filter) {
        this.editStartName = null;
        this.selectedFilter = filter;
        this.markFilterNameRed = false;
        this.textFieldFilterName.a(filter.getFilterName());
        this.textFieldFilterContains.a(this.wordsToString(filter.getWordsContains()));
        this.textFieldFilterContainsNot.a(this.wordsToString(filter.getWordsContainsNot()));
        this.textFieldFilterRoom.a(filter.getRoom() == null || filter.getRoom().isEmpty() ? "Global" : filter.getRoom());
        this.textFieldFilterSoundfile.a(filter.getSoundPath());
    }

    private String[] splitWords(String text) {
        String[] stringArray;
        if (text.contains(",")) {
            stringArray = text.split(",");
        } else if (text.isEmpty()) {
            stringArray = new String[]{};
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = text;
        }
        return stringArray;
    }

    private String wordsToString(String[] words) {
        String output = "";
        for (String word : words) {
            if (!output.isEmpty()) {
                output = output + ",";
            }
            output = output + word;
        }
        return output;
    }

    static {
        try {
            Field soundRegistryInSoundHandlerField = ReflectionHelper.findField(bpz.class, LabyModCore.getMappingAdapter().getSoundRegistryInSoundHandlerMappings());
            Field soundRegistryInSoundRegistryField = ReflectionHelper.findField(bqa.class, LabyModCore.getMappingAdapter().getSoundRegistryInSoundRegistryMappings());
            bqa soundRegistry = (bqa)soundRegistryInSoundHandlerField.get(ave.A().W());
            Map sounds = (Map)soundRegistryInSoundRegistryField.get(soundRegistry);
            for (Object resourceObject : sounds.keySet()) {
                soundNames.add(((jy)resourceObject).a());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

