/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.ingamechat.renderer.types;

import net.labymod.core.LabyModCore;
import net.labymod.ingamechat.IngameChatManager;
import net.labymod.ingamechat.renderer.ChatRenderer;
import net.labymod.main.LabyMod;

public class ChatRendererSecond
extends ChatRenderer {
    private avh gameSettings;

    public ChatRendererSecond(IngameChatManager manager) {
        super(manager, false, true);
        this.gameSettings = ave.A().t;
    }

    @Override
    public String getLogPrefix() {
        return "SECOND CHAT";
    }

    @Override
    public float getChatWidth() {
        return LabyMod.getSettings().secondChatWidth;
    }

    @Override
    public int getChatHeight() {
        return this.isChatOpen() ? LabyMod.getSettings().secondChatHeight : LabyMod.getSettings().secondChatHeight / 2;
    }

    @Override
    public float getChatScale() {
        return this.gameSettings.E;
    }

    @Override
    public float getChatOpacity() {
        return ave.A().t.q;
    }

    @Override
    public float getChatPositionX() {
        double screenWidth = LabyMod.getInstance().getDrawUtils().getWidth();
        float percent = this.getChatPercentX();
        if (percent > 99.0f) {
            return (float)(screenWidth - 2.0);
        }
        double pos = screenWidth - screenWidth / 100.0 * (double)(100.0f - percent);
        if (pos < (double)this.getChatWidth()) {
            pos = this.getChatWidth();
        }
        return (float)pos;
    }

    @Override
    public float getChatPositionY() {
        float height = (float)(this.lastRenderedLinesCount * LabyModCore.getMinecraft().getFontRenderer().a) * this.getChatScale();
        double screenHeight = LabyMod.getInstance().getDrawUtils().getHeight() - 28;
        float percent = this.getChatPercentY();
        if (percent > 99.0f) {
            return (float)screenHeight;
        }
        if (percent < 50.0f) {
            return (float)((double)(height + 2.0f) + screenHeight / 100.0 * (double)percent);
        }
        return (float)(screenHeight / 100.0 * (double)percent);
    }

    @Override
    public float getChatPercentX() {
        return LabyMod.getSettings().secondChatPercentX;
    }

    @Override
    public float getChatPercentY() {
        return LabyMod.getSettings().secondChatPercentY;
    }

    @Override
    public void updateChatSetting(ChatRenderer.ChatSettingType type, float value) {
        switch (type) {
            case WIDTH: {
                int min = 40;
                int max = 320;
                LabyMod.getSettings().secondChatWidth = (int)(value * (float)(max - min) + (float)min);
                break;
            }
            case HEIGHT: {
                int min = 20;
                int max = 180;
                LabyMod.getSettings().secondChatHeight = (int)(value * (float)(max - min) + (float)min);
                break;
            }
            case X: {
                LabyMod.getSettings().secondChatPercentX = value;
                break;
            }
            case Y: {
                LabyMod.getSettings().secondChatPercentY = value;
            }
        }
    }

    @Override
    public void save() {
        LabyMod.getMainConfig().save();
    }
}

