/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.gui.skin;

import java.util.ArrayList;
import java.util.List;
import net.labymod.gui.elements.CheckBox;
import net.labymod.gui.skin.SkinLayerSettingElement;
import net.labymod.main.LabyMod;
import net.labymod.main.ModTextures;
import net.labymod.utils.DrawUtils;

public abstract class SkinCustomizationSettingElement {
    protected String displayString;
    protected CheckBox checkBox;
    protected jy iconResource;
    private List<SkinLayerSettingElement> subSettingElements = new ArrayList<SkinLayerSettingElement>();

    public SkinCustomizationSettingElement(String displayString, String iconName) {
        this.displayString = displayString;
        this.iconResource = new jy("labymod/textures/settings/skin/" + iconName + ".png");
    }

    protected void initCheckBox() {
        this.checkBox = new CheckBox("", this.loadValue(), null, 0, 0, 15, 15);
    }

    protected abstract CheckBox.EnumCheckBoxValue loadValue();

    public void draw(boolean subElement, double x, double y, double elementWidth, double elementHeight, int mouseX, int mouseY) {
        DrawUtils draw = LabyMod.getInstance().getDrawUtils();
        double textureSize = 292.0;
        double textureScale = 36.0;
        ave.A().P().a(ModTextures.BUTTON_LARGE_DISABLED);
        draw.drawTexture(x, y, textureSize / 200.0 * elementWidth / 2.0, textureSize / 200.0 * elementHeight / 2.0, elementWidth / 2.0, elementHeight / 2.0);
        draw.drawTexture(x, y + elementHeight / 2.0, 0.0, -textureScale + textureSize - textureSize / 200.0 * elementHeight / 2.0, textureSize / 200.0 * elementWidth / 2.0, textureSize / 200.0 * elementHeight / 2.0, elementWidth / 2.0, elementHeight / 2.0);
        draw.drawTexture(x + elementWidth / 2.0, y, -textureScale + textureSize - textureSize / 200.0 * elementWidth / 2.0, 0.0, textureSize / 200.0 * elementWidth / 2.0, textureSize / 200.0 * elementHeight / 2.0, elementWidth / 2.0, elementHeight / 2.0);
        draw.drawTexture(x + elementWidth / 2.0, y + elementHeight / 2.0, -textureScale + textureSize - textureSize / 200.0 * elementWidth / 2.0, -textureScale + textureSize - textureSize / 200.0 * elementHeight / 2.0, textureSize / 200.0 * elementWidth / 2.0, textureSize / 200.0 * elementHeight / 2.0, elementWidth / 2.0, elementHeight / 2.0);
        ave.A().P().a(this.iconResource);
        draw.drawTexture(x + elementHeight / 4.0, y + elementHeight / 4.0, 256.0, 256.0, elementHeight / 2.0, elementHeight / 2.0);
        draw.drawString(draw.trimStringToWidth(this.displayString, (int)(elementWidth - (double)this.checkBox.getWidth() - 10.0 - elementHeight)), x + elementHeight, y + elementHeight / 2.0 - 4.0);
        this.checkBox.setX((int)(x + elementWidth - (double)this.checkBox.getWidth() - 5.0));
        this.checkBox.setY((int)(y + elementHeight / 2.0 - (double)(this.checkBox.getHeight() / 2)));
        this.checkBox.drawCheckbox(mouseX, mouseY);
    }

    public void addSubSetting(SkinLayerSettingElement subSetting) {
        this.subSettingElements.add(subSetting);
        subSetting.getCheckBox().setParentCheckBox(this.checkBox);
        this.checkBox.getChildCheckBoxes().add(subSetting.getCheckBox());
    }

    public CheckBox getCheckBox() {
        return this.checkBox;
    }

    public List<SkinLayerSettingElement> getSubSettingElements() {
        return this.subSettingElements;
    }
}

