/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.gui.account;

import java.awt.Color;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.Executors;
import net.labymod.accountmanager.AsyncAccountManager;
import net.labymod.accountmanager.authentication.AsyncAccountAuthentication;
import net.labymod.accountmanager.storage.account.Account;
import net.labymod.accountmanager.storage.account.AccountSessionState;
import net.labymod.accountmanager.storage.loader.external.model.ExternalAccount;
import net.labymod.core.LabyModCore;
import net.labymod.gui.elements.ModTextField;
import net.labymod.main.LabyMod;
import net.labymod.main.ModTextures;
import net.labymod.main.lang.LanguageManager;
import net.labymod.utils.DrawUtils;
import net.labymod.utils.ModColor;
import net.labymod.utils.UUIDFetcher;
import org.lwjgl.input.Keyboard;

public class GuiMojangLogin
extends axu {
    private axu lastScreen;
    private boolean saveAccount;
    private ModTextField fieldUsername;
    private ModTextField fieldPassword;
    private avs buttonLogin;
    private String lastErrorMessage = null;
    private long shakingError = 0L;
    private String renderHeadName;

    public GuiMojangLogin(axu lastScreen, boolean saveAccount) {
        this.lastScreen = lastScreen;
        this.saveAccount = saveAccount;
    }

    public void b() {
        super.b();
        Keyboard.enableRepeatEvents((boolean)true);
        this.n.clear();
        this.fieldUsername = new ModTextField(0, LabyModCore.getMinecraft().getFontRenderer(), this.l / 2 - 110, this.m / 2 - 60, 220, 20);
        this.fieldPassword = new ModTextField(0, LabyModCore.getMinecraft().getFontRenderer(), this.l / 2 - 110, this.m / 2 - 10, 220, 20);
        this.fieldPassword.setPasswordBox(true);
        this.fieldUsername.setMaxStringLength(90000);
        this.fieldPassword.setMaxStringLength(90000);
        this.n.add(new avs(1, this.l / 2 - 110, this.m / 2 + 30, 100, 20, LanguageManager.translate("button_cancel")));
        this.buttonLogin = new avs(2, this.l / 2, this.m / 2 + 30, 110, 20, "");
        this.n.add(this.buttonLogin);
    }

    public void m() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public void a(int mouseX, int mouseY, float partialTicks) {
        this.c(0);
        this.fieldUsername.drawTextBox();
        this.fieldPassword.drawTextBox();
        DrawUtils draw = LabyMod.getInstance().getDrawUtils();
        draw.drawString(LanguageManager.translate("username_email") + ":", this.l / 2 - 110, this.m / 2 - 75);
        draw.drawString(LanguageManager.translate("password") + ":", this.l / 2 - 110, this.m / 2 - 25);
        String offlineString = !this.fieldUsername.getText().isEmpty() && this.fieldPassword.getText().isEmpty() ? ModColor.cl("8") + " (" + ModColor.cl("c") + LanguageManager.translate("offline") + ModColor.cl("8") + ")" : "";
        this.buttonLogin.j = LanguageManager.translate(this.saveAccount ? "button_add" : "button_login") + offlineString;
        this.buttonLogin.l = !this.fieldUsername.getText().isEmpty();
        ave.A().P().a(ModTextures.MISC_MOJANGSTUDIOS);
        LabyMod.getInstance().getDrawUtils().drawTexture(this.l / 2 + 95, this.m / 2 - 80, 256.0, 256.0, 15.0, 15.0);
        if (this.renderHeadName != null && !this.renderHeadName.contains("@")) {
            LabyMod.getInstance().getDrawUtils().drawPlayerHead(this.renderHeadName, this.fieldUsername.xPosition - this.fieldUsername.height - 4, this.fieldUsername.yPosition, this.fieldUsername.height);
        }
        if (this.lastErrorMessage != null) {
            draw.drawRectangle(0, 0, this.l, 16, Color.RED.getRGB());
            int shaking = (int)(System.currentTimeMillis() % 10L) - 5;
            if (this.shakingError + 1000L < System.currentTimeMillis()) {
                shaking = 0;
            }
            draw.drawCenteredString(this.lastErrorMessage, (int)((float)this.l / 2.0f + (float)shaking), 4.0);
        }
        super.a(mouseX, mouseY, partialTicks);
    }

    protected void a(avs button) throws IOException {
        super.a(button);
        switch (button.k) {
            case 1: {
                ave.A().a(this.lastScreen);
                break;
            }
            case 2: {
                AsyncAccountManager accountManager = LabyMod.getInstance().getAccountManager();
                String username = this.fieldUsername.getText();
                String password = this.fieldPassword.getText();
                if (this.fieldPassword.getText().isEmpty()) {
                    Executors.newSingleThreadExecutor().execute(() -> {
                        try {
                            UUID uuid = UUIDFetcher.getUUID(username);
                            if (uuid == null) {
                                uuid = UUID.randomUUID();
                            }
                            ExternalAccount account = new ExternalAccount(uuid, username, "0");
                            account.setSessionState(AccountSessionState.OFFLINE);
                            if (this.saveAccount) {
                                accountManager.getStorage().addAccount(account);
                                accountManager.saveAsync(new Runnable[0]);
                            }
                            LabyMod.getInstance().setSession(account);
                            ave.A().a(this.lastScreen);
                        }
                        catch (Exception e) {
                            this.lastErrorMessage = ModColor.cl('c') + e.getMessage();
                        }
                    });
                    break;
                }
                AsyncAccountAuthentication auth = (AsyncAccountAuthentication)accountManager.getStorage().getAuthentication();
                auth.authenticateMojangAsync(username, password, account -> {
                    try {
                        if (this.saveAccount) {
                            accountManager.getStorage().addAccount((ExternalAccount)account);
                            accountManager.saveAsync(new Runnable[0]);
                        }
                        LabyMod.getInstance().setSession((Account)account);
                        ave.A().a(this.lastScreen);
                    }
                    catch (Exception e) {
                        this.lastErrorMessage = ModColor.cl('c') + e.getMessage();
                    }
                }, e -> {
                    this.lastErrorMessage = ModColor.cl('c') + e.getMessage();
                    this.shakingError = System.currentTimeMillis();
                });
            }
        }
    }

    protected void a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.a(mouseX, mouseY, mouseButton);
        boolean flag = this.fieldUsername.isFocused();
        this.fieldUsername.mouseClicked(mouseX, mouseY, mouseButton);
        if (this.fieldPassword.mouseClicked(mouseX, mouseY, mouseButton) && flag && !this.fieldUsername.isFocused()) {
            this.renderHeadName = this.fieldUsername.getText();
        }
    }

    protected void a(char typedChar, int keyCode) throws IOException {
        if (keyCode == 1) {
            ave.A().a(this.lastScreen);
            return;
        }
        if (keyCode == 28 && this.buttonLogin.l) {
            this.a(this.buttonLogin);
            return;
        }
        if (keyCode == 15) {
            boolean focusUsername = this.fieldUsername.isFocused();
            boolean focusPassword = this.fieldPassword.isFocused();
            this.fieldUsername.setFocused(focusPassword);
            this.fieldPassword.setFocused(focusUsername);
            if (this.fieldPassword.isFocused()) {
                this.renderHeadName = this.fieldUsername.getText();
            }
            return;
        }
        this.fieldUsername.textboxKeyTyped(typedChar, keyCode);
        this.fieldPassword.textboxKeyTyped(typedChar, keyCode);
        super.a(typedChar, keyCode);
    }

    public void e() {
        super.e();
        this.fieldUsername.updateCursorCounter();
        this.fieldPassword.updateCursorCounter();
    }
}

