/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.labymod.core.LabyModCore;
import net.labymod.core.ServerPingerData;
import net.labymod.gui.elements.CheckBox;
import net.labymod.main.LabyMod;
import net.labymod.main.lang.LanguageManager;
import net.labymod.utils.Consumer;
import net.labymod.utils.DrawUtils;
import net.labymod.utils.ModColor;
import net.labymod.utils.ModUtils;
import net.labymod.utils.manager.ServerInfoRenderer;

public class GuiSwitchServer
extends axu {
    private String title;
    private String address;
    private Result result;
    private boolean connectingScreen;
    private ServerInfoRenderer serverInfoRenderer;
    private long lastUpdate = 0L;
    private long updateCooldown = 2000L;
    private String currentServer;
    private CheckBox checkBox;

    public GuiSwitchServer(String address) {
        this.address = address;
        this.connectingScreen = true;
    }

    public GuiSwitchServer(String title, String address, boolean preview, Result result) {
        this.title = ModColor.createColors(title);
        this.address = address;
        this.result = result;
        this.connectingScreen = false;
        String string = this.currentServer = LabyMod.getInstance().getCurrentServerData() == null ? null : ModUtils.getProfileNameByIp(LabyMod.getInstance().getCurrentServerData().getIp());
        if (preview) {
            this.serverInfoRenderer = new ServerInfoRenderer(address, null);
        }
    }

    public void b() {
        super.b();
        if (!this.connectingScreen) {
            this.n.add(new avs(0, this.l / 2 + 20, this.m / 2 + 20, 100, 20, LanguageManager.translate("server_switch_no")));
            this.n.add(new avs(1, this.l / 2 - 120, this.m / 2 + 20, 130, 20, LanguageManager.translate("server_switch_yes")));
            this.checkBox = new CheckBox("", CheckBox.EnumCheckBoxValue.DISABLED, null, this.l / 2 - 120, this.m / 2 + 50, 20, 20);
        }
    }

    public void a(int mouseX, int mouseY, float partialTicks) {
        this.c();
        DrawUtils draw = LabyMod.getInstance().getDrawUtils();
        if (this.connectingScreen) {
            draw.drawCenteredString(bnq.a((String)"connect.connecting", (Object[])new Object[0]), this.l / 2, this.m / 2 - 5);
            draw.drawCenteredString(this.address, this.l / 2, this.m / 2 + 5);
        } else {
            draw.drawCenteredString(this.title, this.l / 2, this.m / 2 - 55 + (this.serverInfoRenderer == null ? 0 : -15));
            List<String> list = draw.listFormattedStringToWidth(LanguageManager.translate("server_switch_confirm", this.address), 250);
            int i = 0;
            for (String line : list) {
                draw.drawCenteredString(line, this.l / 2, this.m / 2 - 40 + i * 10 + (this.serverInfoRenderer == null ? 10 : -10));
                ++i;
            }
            if (this.serverInfoRenderer != null) {
                this.serverInfoRenderer.drawEntry(this.l / 2 - 125, this.m / 2 - 20, 250, mouseX, mouseY);
            }
            if (this.currentServer != null && !LabyMod.isForge()) {
                this.checkBox.drawCheckbox(mouseX, mouseY);
                draw.drawString(ModColor.cl('a') + LanguageManager.translate("server_switch_trust", this.currentServer), this.l / 2 - 95, this.m / 2 + 56);
            }
        }
        super.a(mouseX, mouseY, partialTicks);
    }

    protected void a(char typedChar, int keyCode) throws IOException {
        if (!this.connectingScreen) {
            super.a(typedChar, keyCode);
        }
    }

    public void e() {
        super.e();
        if (!this.connectingScreen && this.serverInfoRenderer != null && this.lastUpdate + this.updateCooldown < System.currentTimeMillis()) {
            this.lastUpdate = System.currentTimeMillis();
            LabyModCore.getServerPinger().pingServer(null, this.lastUpdate, this.address, new Consumer<ServerPingerData>(){

                @Override
                public void accept(ServerPingerData accepted) {
                    if (accepted != null && accepted.getTimePinged() != GuiSwitchServer.this.lastUpdate) {
                        return;
                    }
                    if (GuiSwitchServer.this.serverInfoRenderer != null) {
                        GuiSwitchServer.this.serverInfoRenderer.init(GuiSwitchServer.this.address, GuiSwitchServer.this.address, accepted);
                    }
                }
            });
        }
    }

    protected void a(avs button) throws IOException {
        super.a(button);
        if (button.k == 0) {
            this.result.notifyServer(this.address, false, false);
            ave.A().a(null);
        }
        if (button.k == 1) {
            boolean trusted;
            boolean bl = trusted = this.currentServer != null && this.checkBox.getValue() == CheckBox.EnumCheckBoxValue.ENABLED;
            if (trusted && !LabyMod.isForge()) {
                ArrayList<String> list = new ArrayList<String>(Arrays.asList(LabyMod.getSettings().trustedServers));
                String profileAddress = ModUtils.getProfileNameByIp(this.currentServer);
                if (trusted && !list.contains(profileAddress)) {
                    list.add(profileAddress);
                    String[] array = new String[list.size()];
                    list.toArray(array);
                    LabyMod.getSettings().trustedServers = array;
                    LabyMod.getMainConfig().save();
                }
            }
            this.result.notifyServer(this.address, true, trusted);
            LabyMod.getInstance().switchServer(this.address, true);
        }
    }

    protected void a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.a(mouseX, mouseY, mouseButton);
        if (!this.connectingScreen) {
            this.checkBox.mouseClicked(mouseX, mouseY, mouseButton);
        }
    }

    public static interface Result {
        public void notifyServer(String var1, boolean var2, boolean var3);
    }
}

