/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.gui;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import net.labymod.core.LabyModCore;
import net.labymod.gui.elements.CheckBox;
import net.labymod.gui.elements.Scrollbar;
import net.labymod.main.LabyMod;
import net.labymod.main.ModTextures;
import net.labymod.main.lang.LanguageManager;
import net.labymod.utils.Consumer;
import net.labymod.utils.DrawUtils;
import net.labymod.utils.ModColor;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class GuiShaderSelection
extends axu {
    private axu lastScreen;
    private Scrollbar scrollbar = new Scrollbar(12);
    private int hoveredShader = -1;
    private jy[] shaderResourceLocations;
    private static int shaderIndex;
    private CheckBox checkBox;
    private boolean enabled = false;

    public GuiShaderSelection(axu lastScreen) {
        this.lastScreen = lastScreen;
        if (LabyMod.getInstance().isInGame()) {
            try {
                Field field = ReflectionHelper.findField(bfk.class, LabyModCore.getMappingAdapter().getShaderResourceLocationsMappings());
                field.setAccessible(true);
                this.shaderResourceLocations = (jy[])field.get(ave.A().o);
                if (!ave.A().o.a()) {
                    shaderIndex = -1;
                }
                field = ReflectionHelper.findField(bfk.class, LabyModCore.getMappingAdapter().getUseShaderMappings());
                field.setAccessible(true);
                this.enabled = (Boolean)field.get(ave.A().o);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.checkBox = new CheckBox("Enabled", this.enabled ? CheckBox.EnumCheckBoxValue.ENABLED : CheckBox.EnumCheckBoxValue.DISABLED, null, 0, 0, 20, 20);
        this.checkBox.setUpdateListener(new Consumer<CheckBox.EnumCheckBoxValue>(){

            @Override
            public void accept(CheckBox.EnumCheckBoxValue accepted) {
                ave.A().o.c();
                if (accepted == CheckBox.EnumCheckBoxValue.DISABLED) {
                    LabyMod.getSettings().loadedShader = null;
                    LabyMod.getMainConfig().save();
                }
            }
        });
    }

    private void loadShader(int index) {
        if (index == -1) {
            shaderIndex = -1;
            this.j.o.b();
            LabyMod.getSettings().loadedShader = null;
            LabyMod.getMainConfig().save();
            return;
        }
        try {
            shaderIndex = index;
            jy resourceLocation = this.shaderResourceLocations[shaderIndex];
            LabyMod.getSettings().loadedShader = resourceLocation.a();
            LabyMod.getMainConfig().save();
            GuiShaderSelection.loadShader(resourceLocation);
            this.checkBox.setCurrentValue(CheckBox.EnumCheckBoxValue.ENABLED);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void b() {
        super.b();
        this.n.add(new avs(3, this.l / 2 - 100 + 30, this.m - 26, 170, 20, LanguageManager.translate("button_done")));
        this.scrollbar.setPosition(this.l / 2 + 100 - 5, 48, this.l / 2 + 100, this.m - 45);
        this.checkBox.setX(this.l / 2 - 100);
        this.checkBox.setY(this.m - 26);
    }

    public void a(int mouseX, int mouseY, float partialTicks) {
        DrawUtils draw = LabyMod.getInstance().getDrawUtils();
        draw.drawAutoDimmedBackground(this.scrollbar.getScrollY());
        this.hoveredShader = -2;
        if (LabyMod.getInstance().isInGame() && this.shaderResourceLocations != null) {
            double y = 48.0 + this.scrollbar.getScrollY();
            int index = -1;
            this.drawEntry("None " + ModColor.cl('e') + "(Default)", index, y, mouseX, mouseY);
            y += 12.0;
            ++index;
            for (jy resourceLocation : this.shaderResourceLocations) {
                String name = resourceLocation.a();
                if (name.contains("/")) {
                    String[] path = name.split("/");
                    name = path[path.length - 1];
                    name = name.split("\\.")[0];
                    name = Character.toUpperCase(name.charAt(0)) + name.substring(1, name.length());
                }
                this.drawEntry(name, index, y, mouseX, mouseY);
                y += 12.0;
                ++index;
            }
            this.scrollbar.update(this.shaderResourceLocations.length + 1);
            this.scrollbar.draw();
        } else {
            draw.drawCenteredString(ModColor.cl('c') + LanguageManager.translate("shader_selection_not_ingame"), this.l / 2, this.m / 2);
        }
        draw.drawOverlayBackground(0, 41);
        draw.drawOverlayBackground(this.m - 38, this.m);
        draw.drawGradientShadowTop(41.0, 0.0, this.l);
        draw.drawGradientShadowBottom(this.m - 38, 0.0, this.l);
        draw.drawCenteredString(LanguageManager.translate("title_shaders"), this.l / 2, 29.0);
        this.checkBox.drawCheckbox(mouseX, mouseY);
        super.a(mouseX, mouseY, partialTicks);
    }

    private void drawEntry(String name, int index, double y, int mouseX, int mouseY) {
        DrawUtils draw = LabyMod.getInstance().getDrawUtils();
        if (shaderIndex == index) {
            draw.drawRect(this.l / 2 - 102, y - 2.0, this.l / 2 + 100 - 6, y + 10.0, Integer.MIN_VALUE);
            draw.drawRectBorder(this.l / 2 - 102, y - 2.0, this.l / 2 + 100 - 6, y + 10.0, Integer.MAX_VALUE, 1.0);
            if (index == -1) {
                bfl.c((float)1.0f, (float)0.5f, (float)0.5f, (float)1.0f);
            } else {
                bfl.c((float)0.5f, (float)1.0f, (float)0.5f, (float)1.0f);
            }
        } else {
            bfl.c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        ave.A().P().a(ModTextures.MISC_MENU_POINT);
        draw.drawTexture(this.l / 2 - 100, y, 255.0, 255.0, 8.0, 8.0, 1.1f);
        draw.drawString(name, this.l / 2 - 100 + 10, y);
        if (mouseX > this.l / 2 - 100 && mouseX < this.l / 2 + 100 && (double)mouseY > y && (double)mouseY < y + 12.0 && mouseY > 41 && mouseY < this.m - 38) {
            this.hoveredShader = index;
        }
    }

    protected void a(avs button) throws IOException {
        if (button.k == 3) {
            ave.A().a(this.lastScreen);
        }
        super.a(button);
    }

    protected void a(char typedChar, int keyCode) throws IOException {
        if (keyCode == 1) {
            ave.A().a(this.lastScreen);
            return;
        }
        super.a(typedChar, keyCode);
    }

    protected void a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.a(mouseX, mouseY, mouseButton);
        if (this.hoveredShader != -2 && this.hoveredShader != shaderIndex) {
            this.loadShader(this.hoveredShader);
        }
        this.checkBox.mouseClicked(mouseX, mouseY, mouseButton);
        this.scrollbar.mouseAction(mouseX, mouseY, Scrollbar.EnumMouseAction.CLICKED);
    }

    protected void a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        super.a(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
        this.scrollbar.mouseAction(mouseX, mouseY, Scrollbar.EnumMouseAction.DRAGGING);
    }

    protected void b(int mouseX, int mouseY, int state) {
        super.b(mouseX, mouseY, state);
        this.scrollbar.mouseAction(mouseX, mouseY, Scrollbar.EnumMouseAction.RELEASED);
    }

    public void k() throws IOException {
        super.k();
        this.scrollbar.mouseInput();
    }

    public static void loadShader(jy resourceLocation) throws Exception {
        String[] methodNames = LabyModCore.getMappingAdapter().getLoadShaderMappings();
        Throwable exception = null;
        for (String methodName : methodNames) {
            try {
                Method method = bfk.class.getDeclaredMethod(methodName, jy.class);
                method.setAccessible(true);
                method.invoke((Object)ave.A().o, resourceLocation);
                break;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        if (exception != null) {
            exception.printStackTrace();
        }
    }
}

